<style type="text/css">
    body{ font-family: 'arial';}
    .id-card-holder {
        width: 100%;
        position: relative;
        text-align: center;
        margin-bottom: 20px;
    }
    .id-card-holder .id-card {
        border: 1px solid #ddd;
        position: relative;
        margin: 0 auto;
    }
    .id-card-holder .id-card img {
        max-width: 100%;
        height: auto;
    }
    .id-card-holder .header {
        position: absolute;
        top: 0;
        width: 100%;
        height: auto;
        padding: 10px;
    }
    .id-card-holder .content {
        position: absolute;
        width: 100%;
        height: auto;
        padding: 10px;
    }
    .id-card-holder .footer {
        position: absolute;
        bottom: 0;
        width: 100%;
        height: auto;
        padding: 10px;
    }
    .id-card-holder .student-image {
        position: absolute;
        overflow: hidden;
        border: 1px solid #ddd;
        background: #f8f9fa;
    }
    .id-card-holder .student-image img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }
    .id-card-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
        gap: 20px;
    }
    @media print {
        .id-card-grid {
            display: grid;
            grid-template-columns: repeat(<?php echo $idcard->cards_per_page; ?>, 1fr);
            gap: 10px;
            page-break-inside: avoid;
        }
        .id-card-holder {
            page-break-inside: avoid;
            margin-bottom: 10px;
        }
        @page {
            size: A4;
            margin: 10mm;
        }
    }
</style>

<div class="id-card-preview">
    <div class="row">
        <div class="col-md-12">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title"><?php echo $idcard->idcard_name; ?></h3>
                    <div class="box-tools pull-right">
                        <button type="button" class="btn btn-primary btn-sm" onclick="printDiv()"><i class="fa fa-print"></i> <?php echo $this->lang->line('print'); ?></button>
                    </div>
                </div>
                <div class="box-body">
                    <div id="printableArea">
                        <div class="id-card-grid">
                            <!-- Repeat this for multiple cards per page -->
                            <div class="id-card-holder">
                                <div class="id-card" style="width: <?php echo $idcard->card_width; ?>px; height: <?php echo $idcard->card_height; ?>px;">
                                    <?php if($idcard->background_image != ''){ ?>
                                    <img src="<?php echo base_url('uploads/idcard/') . $idcard->background_image; ?>" style="width: 100%; height: 100%; position: absolute; top: 0; left: 0; z-index: -1;">
                                    <?php } ?>
                                    
                                    <div class="header" style="height: <?php echo $idcard->header_height; ?>px; top: 0;">
                                        <table width="100%" style="table-layout: fixed;">
                                            <tr>
                                                <td style="width: 33%; text-align: left; vertical-align: middle; font-size: 14px;"><?php echo $idcard->left_header; ?></td>
                                                <td style="width: 33%; text-align: center; vertical-align: middle; font-size: 14px;"><?php echo $idcard->center_header; ?></td>
                                                <td style="width: 33%; text-align: right; vertical-align: middle; font-size: 14px;"><?php echo $idcard->right_header; ?></td>
                                            </tr>
                                        </table>
                                    </div>
                                    
                                    <div class="content" style="top: <?php echo $idcard->header_height; ?>px; height: <?php echo $idcard->content_height; ?>px; width: <?php echo $idcard->content_width; ?>px; margin: 0 auto; position: relative;">
                                        <?php if($idcard->enable_student_image == 1){ 
                                            // Set default values if not set
                                            $imageWidth = !empty($idcard->image_width) ? $idcard->image_width . 'px' : '100px';
                                            $imageHeight = !empty($idcard->enable_image_height) ? $idcard->enable_image_height . 'px' : '120px';
                                            $imageTop = !empty($idcard->image_top) ? $idcard->image_top . 'px' : '20px';
                                            $imageSide = !empty($idcard->image_side) ? $idcard->image_side . 'px' : '20px';
                                            
                                            // Set position based on selected position
                                            $positionStyle = '';
                                            $position = !empty($idcard->image_position) ? $idcard->image_position : 'top-left';
                                            
                                            switch($position) {
                                                case 'top-right':
                                                    $positionStyle = 'top: ' . $imageTop . '; right: ' . $imageSide . '; left: auto;';
                                                    break;
                                                case 'bottom-left':
                                                    $positionStyle = 'bottom: ' . $imageTop . '; left: ' . $imageSide . '; top: auto;';
                                                    break;
                                                case 'bottom-right':
                                                    $positionStyle = 'bottom: ' . $imageTop . '; right: ' . $imageSide . '; left: auto; top: auto;';
                                                    break;
                                                default: // top-left
                                                    $positionStyle = 'top: ' . $imageTop . '; left: ' . $imageSide . ';';
                                            }
                                        ?>
                                        <div class="student-image" style="
                                            position: absolute;
                                            <?php echo $positionStyle; ?>
                                            width: <?php echo $imageWidth; ?>;
                                            height: <?php echo $imageHeight; ?>;
                                            overflow: hidden;
                                            border: 1px solid #ddd;
                                            background: #f8f9fa;">
                                            <img src="<?php echo base_url('uploads/student_images/no_image.png'); ?>" 
                                                 style="width: 100%; height: 100%; object-fit: cover;">
                                        </div>
                                        <?php } ?>
                                        
                                        <div style="text-align: left; padding: 10px; position: relative; z-index: 1;">
                                            <?php echo $idcard->idcard_text; ?>
                                        </div>
                                    </div>
                                    
                                    <div class="footer" style="height: <?php echo $idcard->footer_height; ?>px; bottom: 0;">
                                        <table width="100%" style="table-layout: fixed;">
                                            <tr>
                                                <td style="width: 33%; text-align: left; vertical-align: middle; font-size: 12px;"><?php echo $idcard->left_footer; ?></td>
                                                <td style="width: 33%; text-align: center; vertical-align: middle; font-size: 12px;"><?php echo $idcard->center_footer; ?></td>
                                                <td style="width: 33%; text-align: right; vertical-align: middle; font-size: 12px;"><?php echo $idcard->right_footer; ?></td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <!-- Sample additional cards for preview -->
                            <?php if($idcard->cards_per_page > 1){ ?>
                            <div class="id-card-holder">
                                <div class="id-card" style="width: <?php echo $idcard->card_width; ?>px; height: <?php echo $idcard->card_height; ?>px;">
                                    <?php if($idcard->background_image != ''){ ?>
                                    <img src="<?php echo base_url('uploads/idcard/') . $idcard->background_image; ?>" style="width: 100%; height: 100%; position: absolute; top: 0; left: 0; z-index: -1;">
                                    <?php } ?>
                                    
                                    <div class="header" style="height: <?php echo $idcard->header_height; ?>px; top: 0;">
                                        <table width="100%" style="table-layout: fixed;">
                                            <tr>
                                                <td style="width: 33%; text-align: left; vertical-align: middle; font-size: 14px;"><?php echo $idcard->left_header; ?></td>
                                                <td style="width: 33%; text-align: center; vertical-align: middle; font-size: 14px;"><?php echo $idcard->center_header; ?></td>
                                                <td style="width: 33%; text-align: right; vertical-align: middle; font-size: 14px;"><?php echo $idcard->right_header; ?></td>
                                            </tr>
                                        </table>
                                    </div>
                                    
                                    <div class="content" style="top: <?php echo $idcard->header_height; ?>px; height: <?php echo $idcard->content_height; ?>px; width: <?php echo $idcard->content_width; ?>px; margin: 0 auto; position: relative;">
                                        <?php if($idcard->enable_student_image == 1){ 
                                            // Set default values if not set
                                            $imageWidth = !empty($idcard->image_width) ? $idcard->image_width . 'px' : '100px';
                                            $imageHeight = !empty($idcard->enable_image_height) ? $idcard->enable_image_height . 'px' : '120px';
                                            $imageTop = !empty($idcard->image_top) ? $idcard->image_top . 'px' : '20px';
                                            $imageSide = !empty($idcard->image_side) ? $idcard->image_side . 'px' : '20px';
                                            
                                            // Set position based on selected position
                                            $positionStyle = '';
                                            $position = !empty($idcard->image_position) ? $idcard->image_position : 'top-left';
                                            
                                            switch($position) {
                                                case 'top-right':
                                                    $positionStyle = 'top: ' . $imageTop . '; right: ' . $imageSide . '; left: auto;';
                                                    break;
                                                case 'bottom-left':
                                                    $positionStyle = 'bottom: ' . $imageTop . '; left: ' . $imageSide . '; top: auto;';
                                                    break;
                                                case 'bottom-right':
                                                    $positionStyle = 'bottom: ' . $imageTop . '; right: ' . $imageSide . '; left: auto; top: auto;';
                                                    break;
                                                default: // top-left
                                                    $positionStyle = 'top: ' . $imageTop . '; left: ' . $imageSide . ';';
                                            }
                                        ?>
                                        <div class="student-image" style="
                                            position: absolute;
                                            <?php echo $positionStyle; ?>
                                            width: <?php echo $imageWidth; ?>;
                                            height: <?php echo $imageHeight; ?>;
                                            overflow: hidden;
                                            border: 1px solid #ddd;
                                            background: #f8f9fa;">
                                            <img src="<?php echo base_url('uploads/student_images/no_image.png'); ?>" 
                                                 style="width: 100%; height: 100%; object-fit: cover;">
                                        </div>
                                        <?php } ?>
                                        
                                        <div style="text-align: left; padding: 10px; position: relative; z-index: 1;">
                                            <?php echo $idcard->idcard_text; ?>
                                        </div>
                                    </div>
                                    
                                    <div class="footer" style="height: <?php echo $idcard->footer_height; ?>px; bottom: 0;">
                                        <table width="100%" style="table-layout: fixed;">
                                            <tr>
                                                <td style="width: 33%; text-align: left; vertical-align: middle; font-size: 12px;"><?php echo $idcard->left_footer; ?></td>
                                                <td style="width: 33%; text-align: center; vertical-align: middle; font-size: 12px;"><?php echo $idcard->center_footer; ?></td>
                                                <td style="width: 33%; text-align: right; vertical-align: middle; font-size: 12px;"><?php echo $idcard->right_footer; ?></td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    function printDiv() {
        var printContents = document.getElementById('printableArea').innerHTML;
        var originalContents = document.body.innerHTML;
        document.body.innerHTML = printContents;
        window.print();
        document.body.innerHTML = originalContents;
        location.reload();
    }
</script>
