<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-balance-scale"></i> <?php echo $this->lang->line('balance_sheet'); ?>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url() ?>admin/dashboard"><i class="fa fa-dashboard"></i> <?php echo $this->lang->line('dashboard'); ?></a></li>
            <li><a href="<?php echo base_url() ?>admin/accounts"><i class="fa fa-calculator"></i> <?php echo $this->lang->line('accounts'); ?></a></li>
            <li class="active"><?php echo $this->lang->line('balance_sheet'); ?></li>
        </ol>
    </section>

    <section class="content">
        <!-- Balance Sheet Header -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border text-center">
                        <h3 class="box-title">
                            <i class="fa fa-building"></i> <?php echo $sch_setting_detail->name; ?>
                        </h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-primary btn-sm" onclick="printBalanceSheet()">
                                <i class="fa fa-print"></i> <?php echo $this->lang->line('print'); ?>
                            </button>
                            <button type="button" class="btn btn-success btn-sm" onclick="exportBalanceSheet()">
                                <i class="fa fa-file-excel-o"></i> <?php echo $this->lang->line('export'); ?>
                            </button>
                        </div>
                    </div>
                    
                    <div class="box-body text-center">
                        <h4><strong><?php echo $this->lang->line('balance_sheet'); ?></strong></h4>
                        <p>As on <?php echo date('d M Y'); ?></p>
                    </div>
                </div>
            </div>
        </div>

        <div class="row" id="balance-sheet-content">
            <!-- Assets Side -->
            <div class="col-md-6">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-plus-circle"></i> <?php echo $this->lang->line('assets'); ?></h3>
                    </div>
                    
                    <div class="box-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('account_name'); ?></th>
                                        <th class="text-right"><?php echo $this->lang->line('amount'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (!empty($assets)) { 
                                        foreach ($assets as $asset) { ?>
                                            <tr>
                                                <td>
                                                    <strong><?php echo $asset['account_name']; ?></strong>
                                                    <br><small class="text-muted"><?php echo $asset['account_number']; ?></small>
                                                </td>
                                                <td class="text-right">
                                                    <?php echo $currency_symbol . amountFormat($asset['opening_balance']); ?>
                                                </td>
                                            </tr>
                                        <?php } 
                                    } else { ?>
                                        <tr>
                                            <td colspan="2" class="text-center text-muted">
                                                <?php echo $this->lang->line('no_records_found'); ?>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr class="success">
                                        <th><?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('assets'); ?></th>
                                        <th class="text-right">
                                            <?php echo $currency_symbol . amountFormat($total_assets); ?>
                                        </th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- Asset Categories Breakdown -->
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-pie-chart"></i> Asset Categories</h3>
                    </div>
                    
                    <div class="box-body">
                        <?php if (!empty($assets)) { 
                            $asset_categories = array();
                            foreach ($assets as $asset) {
                                $category = ucfirst(str_replace('_', ' ', $asset['account_type']));
                                if (!isset($asset_categories[$category])) {
                                    $asset_categories[$category] = 0;
                                }
                                $asset_categories[$category] += $asset['opening_balance'];
                            }
                            
                            foreach ($asset_categories as $category => $amount) { ?>
                                <div class="progress-group">
                                    <span class="progress-text"><?php echo $category; ?></span>
                                    <span class="float-right">
                                        <b><?php echo $currency_symbol . amountFormat($amount); ?></b>/<?php echo $currency_symbol . amountFormat($total_assets); ?>
                                    </span>
                                    <div class="progress progress-sm">
                                        <div class="progress-bar bg-primary" style="width: <?php echo ($total_assets > 0) ? ($amount / $total_assets * 100) : 0; ?>%"></div>
                                    </div>
                                </div>
                            <?php } 
                        } ?>
                    </div>
                </div>
            </div>

            <!-- Liabilities & Equity Side -->
            <div class="col-md-6">
                <!-- Liabilities -->
                <div class="box box-danger">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-minus-circle"></i> <?php echo $this->lang->line('liabilities'); ?></h3>
                    </div>
                    
                    <div class="box-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('account_name'); ?></th>
                                        <th class="text-right"><?php echo $this->lang->line('amount'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (!empty($liabilities)) { 
                                        foreach ($liabilities as $liability) { ?>
                                            <tr>
                                                <td>
                                                    <strong><?php echo $liability['account_name']; ?></strong>
                                                    <br><small class="text-muted"><?php echo $liability['account_number']; ?></small>
                                                </td>
                                                <td class="text-right">
                                                    <?php echo $currency_symbol . amountFormat($liability['opening_balance']); ?>
                                                </td>
                                            </tr>
                                        <?php } 
                                    } else { ?>
                                        <tr>
                                            <td colspan="2" class="text-center text-muted">
                                                <?php echo $this->lang->line('no_records_found'); ?>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr class="danger">
                                        <th><?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('liabilities'); ?></th>
                                        <th class="text-right">
                                            <?php echo $currency_symbol . amountFormat($total_liabilities); ?>
                                        </th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- Equity -->
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-university"></i> <?php echo $this->lang->line('equity'); ?></h3>
                    </div>
                    
                    <div class="box-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('account_name'); ?></th>
                                        <th class="text-right"><?php echo $this->lang->line('amount'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (!empty($equity)) { 
                                        foreach ($equity as $eq) { ?>
                                            <tr>
                                                <td>
                                                    <strong><?php echo $eq['account_name']; ?></strong>
                                                    <br><small class="text-muted"><?php echo $eq['account_number']; ?></small>
                                                </td>
                                                <td class="text-right">
                                                    <?php echo $currency_symbol . amountFormat($eq['opening_balance']); ?>
                                                </td>
                                            </tr>
                                        <?php } 
                                    } else { ?>
                                        <tr>
                                            <td colspan="2" class="text-center text-muted">
                                                <?php echo $this->lang->line('no_records_found'); ?>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr class="info">
                                        <th><?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('equity'); ?></th>
                                        <th class="text-right">
                                            <?php echo $currency_symbol . amountFormat($total_equity); ?>
                                        </th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Balance Sheet Summary -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-warning">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-calculator"></i> Balance Sheet Summary</h3>
                    </div>
                    
                    <div class="box-body">
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <tbody>
                                    <tr class="success">
                                        <td><strong><?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('assets'); ?></strong></td>
                                        <td class="text-right">
                                            <strong><?php echo $currency_symbol . amountFormat($total_assets); ?></strong>
                                        </td>
                                    </tr>
                                    <tr class="danger">
                                        <td><strong><?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('liabilities'); ?></strong></td>
                                        <td class="text-right">
                                            <strong><?php echo $currency_symbol . amountFormat($total_liabilities); ?></strong>
                                        </td>
                                    </tr>
                                    <tr class="info">
                                        <td><strong><?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('equity'); ?></strong></td>
                                        <td class="text-right">
                                            <strong><?php echo $currency_symbol . amountFormat($total_equity); ?></strong>
                                        </td>
                                    </tr>
                                    <tr class="warning">
                                        <td><strong>Total Liabilities + Equity</strong></td>
                                        <td class="text-right">
                                            <strong><?php echo $currency_symbol . amountFormat($total_liabilities + $total_equity); ?></strong>
                                        </td>
                                    </tr>
                                    <tr class="<?php echo ($total_assets == ($total_liabilities + $total_equity)) ? 'success' : 'danger'; ?>">
                                        <td><strong>Balance Check</strong></td>
                                        <td class="text-right">
                                            <strong>
                                                <?php if ($total_assets == ($total_liabilities + $total_equity)) { ?>
                                                    <i class="fa fa-check text-green"></i> Balanced
                                                <?php } else { ?>
                                                    <i class="fa fa-times text-red"></i> Not Balanced
                                                    (Difference: <?php echo $currency_symbol . amountFormat(abs($total_assets - ($total_liabilities + $total_equity))); ?>)
                                                <?php } ?>
                                            </strong>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Financial Health Indicators -->
        <div class="row">
            <div class="col-md-4">
                <div class="info-box bg-aqua">
                    <span class="info-box-icon"><i class="fa fa-money"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Asset Coverage</span>
                        <span class="info-box-number">
                            <?php 
                            if ($total_liabilities > 0) {
                                $asset_coverage = ($total_assets / $total_liabilities) * 100;
                                echo number_format($asset_coverage, 1) . '%';
                            } else {
                                echo 'N/A';
                            }
                            ?>
                        </span>
                    </div>
                </div>
            </div>
            
            <div class="col-md-4">
                <div class="info-box bg-green">
                    <span class="info-box-icon"><i class="fa fa-percent"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Equity Ratio</span>
                        <span class="info-box-number">
                            <?php 
                            if ($total_assets > 0) {
                                $equity_ratio = ($total_equity / $total_assets) * 100;
                                echo number_format($equity_ratio, 1) . '%';
                            } else {
                                echo 'N/A';
                            }
                            ?>
                        </span>
                    </div>
                </div>
            </div>
            
            <div class="col-md-4">
                <div class="info-box bg-yellow">
                    <span class="info-box-icon"><i class="fa fa-balance-scale"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Debt Ratio</span>
                        <span class="info-box-number">
                            <?php 
                            if ($total_assets > 0) {
                                $debt_ratio = ($total_liabilities / $total_assets) * 100;
                                echo number_format($debt_ratio, 1) . '%';
                            } else {
                                echo 'N/A';
                            }
                            ?>
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script>
function printBalanceSheet() {
    var printContents = document.getElementById('balance-sheet-content').innerHTML;
    var originalContents = document.body.innerHTML;
    
    var printWindow = window.open('', '_blank');
    printWindow.document.write('<html><head><title>Balance Sheet</title>');
    printWindow.document.write('<style>table{width:100%;border-collapse:collapse;}th,td{border:1px solid #ddd;padding:8px;text-align:left;}.text-right{text-align:right;}</style>');
    printWindow.document.write('</head><body>');
    printWindow.document.write('<h2 style="text-align:center;">Balance Sheet</h2>');
    printWindow.document.write('<p style="text-align:center;">As on ' + new Date().toLocaleDateString() + '</p>');
    printWindow.document.write(printContents);
    printWindow.document.write('</body></html>');
    printWindow.document.close();
    printWindow.print();
}

function exportBalanceSheet() {
    var table = document.getElementById('balance-sheet-content');
    var html = table.outerHTML;
    
    var url = 'data:application/vnd.ms-excel,' + encodeURIComponent(html);
    var downloadLink = document.createElement("a");
    
    document.body.appendChild(downloadLink);
    downloadLink.href = url;
    downloadLink.download = 'Balance_Sheet_' + new Date().toISOString().slice(0,10) + '.xls';
    downloadLink.click();
    document.body.removeChild(downloadLink);
}
</script>
