<?php
#version 1.0.0
# Accounts Management Language File

// Main Module
$lang['accounts'] = "Accounts";
$lang['accounts_management'] = "Accounts Management";
$lang['financial_management'] = "Financial Management";

// Menu Items
$lang['account_numbers'] = "Account Numbers";
$lang['balance_sheet'] = "Balance Sheet";
$lang['chart_of_accounts'] = "Chart of Accounts";
$lang['dashboard'] = "Dashboard";

// Account Fields
$lang['account_number'] = "Account Number";
$lang['account_name'] = "Account Name";
$lang['account_type'] = "Account Type";
$lang['opening_balance'] = "Opening Balance";
$lang['current_balance'] = "Current Balance";
$lang['description'] = "Description";

// Account Types
$lang['assets'] = "Assets";
$lang['liabilities'] = "Liabilities";
$lang['equity'] = "Equity";
$lang['revenue'] = "Revenue";
$lang['expense_type'] = "Expense";

// Financial Terms
$lang['total_income'] = "Total Income";
$lang['total_expenses'] = "Total Expenses";
$lang['net_profit'] = "Net Profit";
$lang['net_loss'] = "Net Loss";
$lang['gross_profit'] = "Gross Profit";
$lang['gross_loss'] = "Gross Loss";

// Time Periods
$lang['monthly_income'] = "Monthly Income";
$lang['monthly_expenses'] = "Monthly Expenses";
$lang['monthly_profit'] = "Monthly Profit";
$lang['monthly_loss'] = "Monthly Loss";
$lang['yearly_income'] = "Yearly Income";
$lang['yearly_expenses'] = "Yearly Expenses";
$lang['yearly_profit'] = "Yearly Profit";
$lang['yearly_loss'] = "Yearly Loss";
$lang['monthly_summary'] = "Monthly Summary";
$lang['yearly_summary'] = "Yearly Summary";

// Actions
$lang['add_account'] = "Add Account";
$lang['edit_account'] = "Edit Account";
$lang['delete_account'] = "Delete Account";
$lang['view_account'] = "View Account";
$lang['manage_accounts'] = "Manage Accounts";

// Messages
$lang['account_created_successfully'] = "Account created successfully";
$lang['account_updated_successfully'] = "Account updated successfully";
$lang['account_deleted_successfully'] = "Account deleted successfully";
$lang['account_not_found'] = "Account not found";
$lang['account_already_exists'] = "Account already exists";
$lang['invalid_account_number'] = "Invalid account number";
$lang['invalid_account_type'] = "Invalid account type";

// Dashboard
$lang['financial_overview'] = "Financial Overview";
$lang['quick_actions'] = "Quick Actions";
$lang['total_accounts'] = "Total Accounts";
$lang['account_summary'] = "Account Summary";

// Reports
$lang['profit_loss_statement'] = "Profit & Loss Statement";
$lang['income_statement'] = "Income Statement";
$lang['balance_sheet_report'] = "Balance Sheet Report";
$lang['trial_balance'] = "Trial Balance";
$lang['cash_flow_statement'] = "Cash Flow Statement";

// Financial Ratios
$lang['profit_margin'] = "Profit Margin";
$lang['expense_ratio'] = "Expense Ratio";
$lang['revenue_growth'] = "Revenue Growth";
$lang['cash_flow'] = "Cash Flow";
$lang['financial_ratios'] = "Financial Ratios";
$lang['liquidity_ratio'] = "Liquidity Ratio";

// Account Categories
$lang['cash_accounts'] = "Cash Accounts";
$lang['bank_accounts'] = "Bank Accounts";
$lang['receivables'] = "Receivables";
$lang['payables'] = "Payables";
$lang['fixed_assets'] = "Fixed Assets";
$lang['current_assets'] = "Current Assets";
$lang['current_liabilities'] = "Current Liabilities";
$lang['long_term_liabilities'] = "Long Term Liabilities";

// Validation Messages
$lang['account_number_required'] = "Account number is required";
$lang['account_name_required'] = "Account name is required";
$lang['account_type_required'] = "Account type is required";
$lang['opening_balance_invalid'] = "Opening balance must be a valid number";
$lang['account_number_exists'] = "Account number already exists";
$lang['account_number_format'] = "Account number format is invalid";

// Form Labels
$lang['select_account_type'] = "Select Account Type";
$lang['enter_account_number'] = "Enter Account Number";
$lang['enter_account_name'] = "Enter Account Name";
$lang['enter_opening_balance'] = "Enter Opening Balance";
$lang['account_description'] = "Account Description";

// Buttons
$lang['save_account'] = "Save Account";
$lang['update_account'] = "Update Account";
$lang['cancel'] = "Cancel";
$lang['reset'] = "Reset";
$lang['search'] = "Search";
$lang['filter'] = "Filter";
$lang['export'] = "Export";
$lang['print'] = "Print";

// Table Headers
$lang['sr_no'] = "Sr. No.";
$lang['actions'] = "Actions";
$lang['status'] = "Status";
$lang['created_date'] = "Created Date";
$lang['last_updated'] = "Last Updated";

// Status
$lang['active'] = "Active";
$lang['inactive'] = "Inactive";
$lang['enabled'] = "Enabled";
$lang['disabled'] = "Disabled";

// Alerts
$lang['confirm_delete'] = "Are you sure you want to delete this account?";
$lang['confirm_action'] = "Are you sure you want to perform this action?";
$lang['operation_successful'] = "Operation completed successfully";
$lang['operation_failed'] = "Operation failed";
$lang['no_records_found'] = "No records found";
$lang['loading'] = "Loading...";

// Help Text
$lang['account_number_help'] = "Enter a unique account number (e.g., 1001, 2001)";
$lang['account_type_help'] = "Select the type of account from the dropdown";
$lang['opening_balance_help'] = "Enter the opening balance for this account";
$lang['account_name_help'] = "Enter a descriptive name for the account";

// Navigation
$lang['back_to_accounts'] = "Back to Accounts";
$lang['go_to_dashboard'] = "Go to Dashboard";
$lang['view_reports'] = "View Reports";
$lang['manage_settings'] = "Manage Settings";

// Additional Terms
$lang['debit'] = "Debit";
$lang['credit'] = "Credit";
$lang['balance'] = "Balance";
$lang['transaction'] = "Transaction";
$lang['journal_entry'] = "Journal Entry";
$lang['ledger'] = "Ledger";
$lang['voucher'] = "Voucher";
$lang['reference'] = "Reference";
$lang['date_range'] = "Date Range";
$lang['from_date'] = "From Date";
$lang['to_date'] = "To Date";
$lang['currency'] = "Currency";
$lang['amount'] = "Amount";
$lang['total'] = "Total";
$lang['subtotal'] = "Subtotal";
$lang['grand_total'] = "Grand Total";
?>
