<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Simple_receipt extends Admin_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('simple_receipt_model');
    }

    // List all templates
    public function index() {
        if (!$this->rbac->hasPrivilege('collect_fees', 'can_view')) {
            access_denied();
        }

        $data['title'] = 'Receipt Templates';
        $data['templates'] = $this->simple_receipt_model->get_all_templates();
        
        $this->load->view('layout/header', $data);
        $this->load->view('admin/simple_receipt/index', $data);
        $this->load->view('layout/footer', $data);
    }

    // Create new template
    public function create() {
        if (!$this->rbac->hasPrivilege('collect_fees', 'can_add')) {
            access_denied();
        }

        $data['title'] = 'Create Receipt Template';

        if ($this->input->method() == 'post') {
            $this->form_validation->set_rules('template_name', 'Template Name', 'trim|required');
            $this->form_validation->set_rules('template_code', 'Template Code', 'trim|required|alpha_dash');
            $this->form_validation->set_rules('template_content', 'Template Content', 'trim|required');

            if ($this->form_validation->run() == FALSE) {
                $this->load->view('layout/header', $data);
                $this->load->view('admin/simple_receipt/create', $data);
                $this->load->view('layout/footer', $data);
            } else {
                // Check if template code already exists
                if ($this->simple_receipt_model->code_exists($this->input->post('template_code'))) {
                    $this->session->set_flashdata('msg', '<div class="alert alert-danger">Template code already exists!</div>');
                    redirect('admin/simple_receipt/create');
                    return;
                }

                $template_data = array(
                    'template_name' => $this->input->post('template_name'),
                    'template_code' => $this->input->post('template_code'),
                    'template_content' => $this->input->post('template_content'),
                    'is_active' => $this->input->post('is_active') ? 1 : 0
                );

                $insert_id = $this->simple_receipt_model->create_template($template_data);
                
                if ($insert_id) {
                    $this->session->set_flashdata('msg', '<div class="alert alert-success">Receipt template created successfully!</div>');
                    redirect('admin/simple_receipt');
                } else {
                    $this->session->set_flashdata('msg', '<div class="alert alert-danger">Failed to create template!</div>');
                    redirect('admin/simple_receipt/create');
                }
            }
        } else {
            $this->load->view('layout/header', $data);
            $this->load->view('admin/simple_receipt/create', $data);
            $this->load->view('layout/footer', $data);
        }
    }

    // Edit template
    public function edit($id = null) {
        if (!$this->rbac->hasPrivilege('collect_fees', 'can_edit')) {
            access_denied();
        }

        if (!$id) {
            redirect('admin/simple_receipt');
        }

        $data['title'] = 'Edit Receipt Template';
        $data['template'] = $this->simple_receipt_model->get_template_by_id($id);

        if (!$data['template']) {
            $this->session->set_flashdata('msg', '<div class="alert alert-danger">Template not found!</div>');
            redirect('admin/simple_receipt');
        }

        if ($this->input->method() == 'post') {
            $this->form_validation->set_rules('template_name', 'Template Name', 'trim|required');
            $this->form_validation->set_rules('template_code', 'Template Code', 'trim|required|alpha_dash');
            $this->form_validation->set_rules('template_content', 'Template Content', 'trim|required');

            if ($this->form_validation->run() == FALSE) {
                $this->load->view('layout/header', $data);
                $this->load->view('admin/simple_receipt/edit', $data);
                $this->load->view('layout/footer', $data);
            } else {
                // Check if template code already exists (excluding current template)
                if ($this->simple_receipt_model->code_exists($this->input->post('template_code'), $id)) {
                    $this->session->set_flashdata('msg', '<div class="alert alert-danger">Template code already exists!</div>');
                    redirect('admin/simple_receipt/edit/' . $id);
                    return;
                }

                $template_data = array(
                    'template_name' => $this->input->post('template_name'),
                    'template_code' => $this->input->post('template_code'),
                    'template_content' => $this->input->post('template_content'),
                    'is_active' => $this->input->post('is_active') ? 1 : 0
                );

                if ($this->simple_receipt_model->update_template($id, $template_data)) {
                    $this->session->set_flashdata('msg', '<div class="alert alert-success">Receipt template updated successfully!</div>');
                    redirect('admin/simple_receipt');
                } else {
                    $this->session->set_flashdata('msg', '<div class="alert alert-danger">Failed to update template!</div>');
                    redirect('admin/simple_receipt/edit/' . $id);
                }
            }
        } else {
            $this->load->view('layout/header', $data);
            $this->load->view('admin/simple_receipt/edit', $data);
            $this->load->view('layout/footer', $data);
        }
    }

    // Delete template
    public function delete($id = null) {
        if (!$this->rbac->hasPrivilege('collect_fees', 'can_delete')) {
            access_denied();
        }

        if (!$id) {
            $this->session->set_flashdata('msg', '<div class="alert alert-danger">Invalid template ID!</div>');
            redirect('admin/simple_receipt');
        }

        // Check if template exists
        $template = $this->simple_receipt_model->get_template_by_id($id);
        if (!$template) {
            $this->session->set_flashdata('msg', '<div class="alert alert-danger">Template not found!</div>');
            redirect('admin/simple_receipt');
        }

        if ($this->simple_receipt_model->delete_template($id)) {
            $this->session->set_flashdata('msg', '<div class="alert alert-success">Template "' . $template->template_name . '" deleted successfully!</div>');
        } else {
            $this->session->set_flashdata('msg', '<div class="alert alert-danger">Failed to delete template!</div>');
        }

        redirect('admin/simple_receipt');
    }

    // Toggle template status (active/inactive)
    public function toggle_status($id = null) {
        if (!$this->rbac->hasPrivilege('collect_fees', 'can_edit')) {
            access_denied();
        }

        if (!$id) {
            $this->session->set_flashdata('msg', '<div class="alert alert-danger">Invalid template ID!</div>');
            redirect('admin/simple_receipt');
        }

        // Get current template
        $template = $this->simple_receipt_model->get_template_by_id($id);
        if (!$template) {
            $this->session->set_flashdata('msg', '<div class="alert alert-danger">Template not found!</div>');
            redirect('admin/simple_receipt');
        }

        // Toggle status
        $new_status = $template->is_active ? 0 : 1;
        $status_text = $new_status ? 'activated' : 'deactivated';

        if ($this->simple_receipt_model->update_template($id, array('is_active' => $new_status))) {
            $this->session->set_flashdata('msg', '<div class="alert alert-success">Template "' . $template->template_name . '" ' . $status_text . ' successfully!</div>');
        } else {
            $this->session->set_flashdata('msg', '<div class="alert alert-danger">Failed to update template status!</div>');
        }

        redirect('admin/simple_receipt');
    }

    // Preview template
    public function preview($id = null) {
        if (!$this->rbac->hasPrivilege('collect_fees', 'can_view')) {
            access_denied();
        }

        if (!$id) {
            redirect('admin/simple_receipt');
        }

        $template = $this->simple_receipt_model->get_template_by_id($id);
        
        if (!$template) {
            $this->session->set_flashdata('msg', '<div class="alert alert-danger">Template not found!</div>');
            redirect('admin/simple_receipt');
        }

        // Comprehensive sample data for preview
        $sample_data = array(
            // School Variables
            'school_name' => 'Sample School Name',
            'school_address' => '123 School Street, Education City, State - 123456',
            'school_phone' => '+91-9876543210',
            'school_email' => 'info@sampleschool.edu',
            'school_website' => 'www.sampleschool.edu',
            
            // Student Variables
            'student_name' => 'John Doe',
            'admission_no' => 'ADM2024001',
            'class_name' => 'Class 10',
            'section_name' => 'A',
            'father_name' => 'Robert Doe',
            'mother_name' => 'Jane Doe',
            'guardian_name' => 'Robert Doe',
            'student_mobile' => '+91-9876543210',
            'student_email' => 'john.doe@email.com',
            'student_address' => '456 Student Street, City, State - 654321',
            
            // Payment Variables
            'payment_date' => date('d-m-Y'),
            'payment_mode' => 'Cash',
            'receipt_no' => 'RCP' . date('Ymd') . '001',
            'transaction_id' => 'TXN' . date('YmdHis'),
            'collected_by' => 'Admin User',
            'payment_note' => 'Fee payment for academic year 2024-25',
            
            // Total Variables
            'total_amount' => '₹15,000.00',
            'total_paid' => '₹12,000.00',
            'total_discount' => '₹1,000.00',
            'total_fine' => '₹500.00',
            'total_balance_amount' => '₹2,500.00',
            'net_amount' => '₹14,500.00',
            
            // Date & Time Variables
            'current_date' => date('d-m-Y'),
            'current_time' => date('h:i A'),
            'current_datetime' => date('d-m-Y h:i A'),
            'due_date' => date('d-m-Y', strtotime('+30 days')),
            'invoice_date' => date('d-m-Y'),
            'invoice_no' => 'INV' . date('Ymd') . '001',
            
            // Fee Group Variables (3 groups)
            'fee_group_name_1' => 'Tuition Fee',
            'fee_group_name_2' => 'Transport Fee',
            'fee_group_name_3' => 'Library Fee',
            
            'fee_amount_1' => '₹8,000.00',
            'fee_amount_2' => '₹5,000.00',
            'fee_amount_3' => '₹2,000.00',
            
            'paid_amount_1' => '₹7,000.00',
            'paid_amount_2' => '₹4,000.00',
            'paid_amount_3' => '₹1,000.00',
            
            'balance_1' => '₹1,000.00',
            'balance_2' => '₹1,000.00',
            'balance_3' => '₹1,000.00',
            
            'discount_amount_1' => '₹500.00',
            'discount_amount_2' => '₹300.00',
            'discount_amount_3' => '₹200.00',
            
            'fine_amount_1' => '₹200.00',
            'fine_amount_2' => '₹200.00',
            'fine_amount_3' => '₹100.00',
            
            'due_date_1' => date('d-m-Y', strtotime('+15 days')),
            'due_date_2' => date('d-m-Y', strtotime('+30 days')),
            'due_date_3' => date('d-m-Y', strtotime('+45 days')),
            
            'payment_status_1' => 'Partial',
            'payment_status_2' => 'Partial',
            'payment_status_3' => 'Partial',
            
            'fee_type_1' => 'Academic',
            'fee_type_2' => 'Transport',
            'fee_type_3' => 'Library',
            
            'fee_code_1' => 'TF001',
            'fee_code_2' => 'TR001',
            'fee_code_3' => 'LB001',
            
            // Extended variables for up to 15 groups
            'fee_group_name_4' => 'Sports Fee',
            'fee_group_name_5' => 'Lab Fee',
            'fee_group_name_6' => 'Exam Fee',
            'fee_group_name_7' => 'Activity Fee',
            'fee_group_name_8' => 'Uniform Fee',
            'fee_group_name_9' => 'Book Fee',
            'fee_group_name_10' => 'Hostel Fee',
            'fee_group_name_11' => 'Mess Fee',
            'fee_group_name_12' => 'Medical Fee',
            'fee_group_name_13' => 'Insurance Fee',
            'fee_group_name_14' => 'Development Fee',
            'fee_group_name_15' => 'Miscellaneous Fee',
            
            // Total calculations
            'total_fee_amount' => '₹15,000.00',
            'total_paid_amount' => '₹12,000.00',
            'total_balance' => '₹3,000.00',
            'total_discount_amount' => '₹1,000.00'
        );

        $rendered_content = $this->simple_receipt_model->render_template($template->template_code, $sample_data);

        echo '<!DOCTYPE html>
        <html>
        <head>
            <title>Template Preview</title>
            <style>
                body { font-family: Arial, sans-serif; margin: 20px; }
                .preview-container { border: 1px solid #ddd; padding: 20px; }
            </style>
        </head>
        <body>
            <h2>Template Preview: ' . $template->template_name . '</h2>
            <div class="preview-container">
                ' . $rendered_content . '
            </div>
        </body>
        </html>';
    }

    // Get active templates for AJAX requests
    public function get_templates() {
        if (!$this->rbac->hasPrivilege('collect_fees', 'can_view')) {
            echo json_encode([]);
            return;
        }

        $templates = $this->simple_receipt_model->get_active_templates();
        
        // Return JSON response
        header('Content-Type: application/json');
        echo json_encode($templates);
    }

    // AJAX preview method for visual editor
    public function ajax_preview() {
        if (!$this->rbac->hasPrivilege('collect_fees', 'can_view')) {
            echo json_encode(['success' => false, 'message' => 'Access denied']);
            return;
        }

        $template_content = $this->input->post('template_content');
        
        if (!$template_content) {
            echo json_encode(['success' => false, 'message' => 'No template content provided']);
            return;
        }

        // Comprehensive sample data for preview
        $sample_data = array(
            // School Variables
            'school_name' => 'Sample School Name',
            'school_address' => '123 School Street, Education City, State - 123456',
            'school_phone' => '+91-9876543210',
            'school_email' => 'info@sampleschool.edu',
            'school_website' => 'www.sampleschool.edu',
            
            // Student Variables
            'student_name' => 'John Doe',
            'admission_no' => 'ADM2024001',
            'class_name' => 'Class 10',
            'section_name' => 'A',
            'father_name' => 'Robert Doe',
            'mother_name' => 'Jane Doe',
            'guardian_name' => 'Robert Doe',
            'student_mobile' => '+91-9876543210',
            'student_email' => 'john.doe@email.com',
            'student_address' => '456 Student Street, City, State - 654321',
            
            // Payment Variables
            'payment_date' => date('d-m-Y'),
            'payment_mode' => 'Cash',
            'receipt_no' => 'RCP' . date('Ymd') . '001',
            'transaction_id' => 'TXN' . date('YmdHis'),
            'collected_by' => 'Admin User',
            'payment_note' => 'Fee payment for academic year 2024-25',
            
            // Total Variables
            'total_amount' => '₹15,000.00',
            'total_paid' => '₹12,000.00',
            'total_discount' => '₹1,000.00',
            'total_fine' => '₹500.00',
            'total_balance_amount' => '₹2,500.00',
            'net_amount' => '₹14,500.00',
            
            // Date & Time Variables
            'current_date' => date('d-m-Y'),
            'current_time' => date('h:i A'),
            'current_datetime' => date('d-m-Y h:i A'),
            'due_date' => date('d-m-Y', strtotime('+30 days')),
            'invoice_date' => date('d-m-Y'),
            'invoice_no' => 'INV' . date('Ymd') . '001',
            
            // Fee Group Variables (3 groups)
            'fee_group_name_1' => 'Tuition Fee',
            'fee_group_name_2' => 'Transport Fee',
            'fee_group_name_3' => 'Library Fee',
            
            'fee_amount_1' => '₹8,000.00',
            'fee_amount_2' => '₹5,000.00',
            'fee_amount_3' => '₹2,000.00',
            
            'paid_amount_1' => '₹7,000.00',
            'paid_amount_2' => '₹4,000.00',
            'paid_amount_3' => '₹1,000.00',
            
            'balance_1' => '₹1,000.00',
            'balance_2' => '₹1,000.00',
            'balance_3' => '₹1,000.00',
            
            'discount_amount_1' => '₹500.00',
            'discount_amount_2' => '₹300.00',
            'discount_amount_3' => '₹200.00',
            
            'fine_amount_1' => '₹200.00',
            'fine_amount_2' => '₹200.00',
            'fine_amount_3' => '₹100.00',
            
            'due_date_1' => date('d-m-Y', strtotime('+15 days')),
            'due_date_2' => date('d-m-Y', strtotime('+30 days')),
            'due_date_3' => date('d-m-Y', strtotime('+45 days')),
            
            'payment_status_1' => 'Partial',
            'payment_status_2' => 'Partial',
            'payment_status_3' => 'Partial',
            
            'fee_type_1' => 'Academic',
            'fee_type_2' => 'Transport',
            'fee_type_3' => 'Library',
            
            'fee_code_1' => 'TF001',
            'fee_code_2' => 'TR001',
            'fee_code_3' => 'LB001',
            
            // Extended variables for up to 15 groups
            'fee_group_name_4' => 'Sports Fee',
            'fee_group_name_5' => 'Lab Fee',
            'fee_group_name_6' => 'Exam Fee',
            'fee_group_name_7' => 'Activity Fee',
            'fee_group_name_8' => 'Uniform Fee',
            'fee_group_name_9' => 'Book Fee',
            'fee_group_name_10' => 'Hostel Fee',
            'fee_group_name_11' => 'Mess Fee',
            'fee_group_name_12' => 'Medical Fee',
            'fee_group_name_13' => 'Insurance Fee',
            'fee_group_name_14' => 'Development Fee',
            'fee_group_name_15' => 'Miscellaneous Fee',
            
            // Total calculations
            'total_fee_amount' => '₹15,000.00',
            'total_paid_amount' => '₹12,000.00',
            'total_balance' => '₹3,000.00',
            'total_discount_amount' => '₹1,000.00'
        );

        // Replace variables with actual data
        $rendered_content = $template_content;
        foreach ($sample_data as $key => $value) {
            $rendered_content = str_replace('{{' . $key . '}}', $value, $rendered_content);
        }

        header('Content-Type: application/json');
        echo json_encode(['success' => true, 'content' => $rendered_content]);
    }
}
?>
