-- Add ID Card menu items to the sidebar menu

-- First, check if Certificate menu already exists
SET @certificate_menu_id = (SELECT id FROM `sidebar_menus` WHERE `activate_menu` = 'certificate');

-- If Certificate menu doesn't exist, create it
INSERT INTO `sidebar_menus` (`id`, `menu`, `icon`, `lang_key`, `activate_menu`, `access_permissions`, `is_active`, `created_at`)
SELECT NULL, 'Certificate', 'fa fa-file-text-o', 'certificate', 'certificate', 'student_certificate|can_view', 1, NOW()
WHERE NOT EXISTS (SELECT * FROM `sidebar_menus` WHERE `activate_menu` = 'certificate');

-- Get the Certificate menu ID
SET @certificate_menu_id = (SELECT id FROM `sidebar_menus` WHERE `activate_menu` = 'certificate');

-- Add ID Card submenu items
INSERT INTO `sidebar_sub_menus` (`id`, `sidebar_menu_id`, `menu`, `lang_key`, `url`, `permission_group_id`, `activate_controller`, `activate_methods`, `access_permissions`, `is_active`, `created_at`)
VALUES
(NULL, @certificate_menu_id, 'Student ID Card', 'student_id_card', 'admin/idcard', NULL, 'idcard', 'index,edit,delete,view', 'student_id_card|can_view', 1, NOW()),
(NULL, @certificate_menu_id, 'Generate ID Card', 'generate_id_card', 'admin/idcardgenerate', NULL, 'idcardgenerate', 'index,search,generate,generatemultiple', 'student_id_card|can_view', 1, NOW());

-- Note: Language strings will be handled by the application code
-- No need to insert into language tables
