/**
 * Thank You Message Script
 * Displays a nice thank you message with the user's name after marking attendance
 */

function showThankYouMessage(userName, userType) {
    // Create the notification container if it doesn't exist
    let notificationContainer = document.getElementById('attendance-notification');
    
    if (!notificationContainer) {
        notificationContainer = document.createElement('div');
        notificationContainer.id = 'attendance-notification';
        notificationContainer.style.cssText = `
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            background-color: rgba(0, 0, 0, 0.8);
            color: white;
            padding: 30px;
            border-radius: 10px;
            text-align: center;
            z-index: 9999;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.5);
            display: none;
            font-family: Arial, sans-serif;
            min-width: 300px;
        `;
        document.body.appendChild(notificationContainer);
    }
    
    // Play a beep sound if available
    try {
        const beep = new Audio(base_url + 'backend/faceattendance/beep.mp3');
        beep.play();
    } catch (e) {
        console.log('Beep sound not available');
    }
    
    // Set the message based on user type
    const greeting = userType === 'student' ? 'Hello, Student' : 'Hello, Staff Member';
    const message = `
        <h2 style="margin-top: 0; color: #4CAF50;">${greeting}</h2>
        <h1 style="font-size: 24px; margin: 15px 0;">${userName}</h1>
        <p style="font-size: 18px; margin-bottom: 20px;">Your attendance has been marked successfully!</p>
        <p style="font-size: 16px;">Thank you for using the face recognition system.</p>
        <div style="width: 100px; height: 100px; margin: 20px auto; background-color: #4CAF50; border-radius: 50%; display: flex; justify-content: center; align-items: center;">
            <div style="color: white; font-size: 50px;">✓</div>
        </div>
    `;
    
    // Set the message and show the notification
    notificationContainer.innerHTML = message;
    notificationContainer.style.display = 'block';
    
    // Hide the notification after 3 seconds
    setTimeout(() => {
        notificationContainer.style.display = 'none';
    }, 3000);
}
