<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="theme-color" content="#424242" />
        <title>Login : <?php echo $name; ?></title>
        <link href="<?php echo base_url(); ?>uploads/school_content/admin_small_logo/<?php $this->setting_model->getAdminsmalllogo();?>" rel="shortcut icon" type="image/x-icon">
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:400,100,300,500">
        <link rel="stylesheet" href="<?php echo base_url(); ?>backend/usertemplate/assets/bootstrap/css/bootstrap.min.css">
        <link rel="stylesheet" href="<?php echo base_url(); ?>backend/usertemplate/assets/font-awesome/css/font-awesome.min.css">
        <style>
            @keyframes fadeInUp {
                from {
                    opacity: 0;
                    transform: translateY(20px);
                }
                to {
                    opacity: 1;
                    transform: translateY(0);
                }
            }

            @keyframes shake {
                0%, 100% { transform: translateX(0); }
                25% { transform: translateX(-5px); }
                75% { transform: translateX(5px); }
            }

            body {
                background: #581845;
                font-family: 'Roboto', sans-serif;
                height: 100vh;
                display: flex;
                align-items: center;
                justify-content: center;
            }
            .login-container {
                background: white;
                padding: 40px;
                border-radius: 8px;
                box-shadow: 0 0 20px rgba(0,0,0,0.1);
                width: 100%;
                max-width: 400px;
                animation: fadeInUp 0.8s ease-out;
            }
            .login-title {
                text-align: center;
                margin-bottom: 30px;
            }
            .login-title img {
                max-width: 150px;
                margin-bottom: 20px;
                height: auto;
                animation: fadeInUp 0.8s ease-out 0.2s both;
            }
            .login-title h3 {
                animation: fadeInUp 0.8s ease-out 0.4s both;
            }
            .form-group {
                animation: fadeInUp 0.8s ease-out 0.6s both;
            }
            .form-control {
                height: 45px;
                border-radius: 4px;
                border: 1px solid #ddd;
                padding: 10px 15px;
                font-size: 14px;
                margin-bottom: 15px;
                transition: all 0.3s ease;
            }
            .form-control:focus {
                border-color: #424242;
                box-shadow: 0 0 0 2px rgba(66,66,66,0.1);
                transform: translateY(-2px);
            }
            .form-control.input-error {
                border-color: #ff3e3e;
                animation: shake 0.5s ease-in-out;
            }
            .btn-login {
                background: #424242;
                color: white;
                padding: 12px;
                border-radius: 4px;
                width: 100%;
                font-size: 16px;
                font-weight: 500;
                border: none;
                cursor: pointer;
                transition: all 0.3s ease;
                animation: fadeInUp 0.8s ease-out 0.8s both;
            }
            .btn-login:hover {
                background: #2d2d2d;
                transform: translateY(-2px);
                box-shadow: 0 4px 8px rgba(0,0,0,0.1);
            }
            .forgot-link {
                text-align: center;
                margin-top: 15px;
                animation: fadeInUp 0.8s ease-out 1s both;
            }
            .forgot-link a {
                color: #424242;
                text-decoration: none;
                transition: all 0.3s ease;
            }
            .forgot-link a:hover {
                text-decoration: underline;
                opacity: 0.8;
            }
            .staff-btn {
                display: block;
                width: 50%;
                padding: 12px;
                background: #3498db;
                color: #fff;
                border: none;
                border-radius: 4px;
                font-size: 14px;
                cursor: pointer;
                margin: 20px auto 0;
                transition: all 0.3s ease;
                text-decoration: none;
                text-align: center;
                animation: fadeInUp 0.8s ease-out 1.2s both;
            }
            .staff-btn:hover {
                background: #2980b9;
                transform: translateY(-2px);
                box-shadow: 0 4px 8px rgba(0,0,0,0.1);
            }
            .alert {
                animation: fadeInUp 0.8s ease-out;
            }
        </style>
    </head>
    <body>
        <div class="login-container">
            <div class="login-title">
                <?php 
                $admin_logo = $this->setting_model->getAdminlogo();
                $logo_url = base_url() . "uploads/school_content/admin_logo/" . $admin_logo;
                ?>
                <img src="<?php echo $logo_url; ?>" alt="<?php echo $name; ?> Logo">
                <h3><?php echo $name; ?></h3>
            </div>
            
            <?php
            if (isset($error_message)) {
                echo "<div class='alert alert-danger'>" . $error_message . "</div>";
            }
            ?>
            
            <form action="<?php echo site_url('site/userlogin') ?>" method="post">
                <?php echo $this->customlib->getCSRF(); ?>
                <div class="form-group">
                    <input type="text" name="username" placeholder="Username" class="form-control" required>
                </div>
                <div class="form-group">
                    <input type="password" name="password" placeholder="Password" class="form-control" required>
                </div>
                <?php if ($is_captcha) {?>
                <div class="form-group has-feedback row">
                    <div class='col-lg-7 col-md-12 col-sm-6'>
                        <span id="captcha_image"><?php echo $captcha_image; ?></span>
                        <span class="fa fa-refresh catpcha" title='<?php echo $this->lang->line("refresh_captcha") ?>' onclick="refreshCaptcha()"></span>
                    </div>
                    <div class='col-lg-5 col-md-12 col-sm-6'>
                        <input type="text" name="captcha" placeholder="<?php echo $this->lang->line('captcha'); ?>" autocomplete="off" class="form-control" id="captcha">
                        <span class="text-danger"><?php echo form_error('captcha'); ?></span>
                    </div>
                </div>
                <?php }?>
                <button type="submit" class="btn-login">Login</button>
            </form>
            
            <div class="forgot-link">
                <a href="<?php echo site_url('site/ufpassword') ?>">Forgot Password?</a>
            </div>

            <a href="<?php echo site_url('site/Login'); ?>" class="staff-btn">Staff Login</a>
        </div>

        <script src="<?php echo base_url(); ?>backend/usertemplate/assets/js/jquery.min.js"></script>
        <script src="<?php echo base_url(); ?>backend/usertemplate/assets/bootstrap/js/bootstrap.min.js"></script>
        <script type="text/javascript">
            function refreshCaptcha(){
                $.ajax({
                    type: "POST",
                    url: "<?php echo base_url('site/refreshCaptcha'); ?>",
                    data: {},
                    success: function(captcha){
                        $("#captcha_image").html(captcha);
                    }
                });
            }
        </script>
    </body>
</html>