<div class="container">
    <div class="row">
        <div class="col-md-12">
            <div class="well well-sm">
                <div class="row">
                    <div class="col-md-8 col-md-offset-2">
                        <h3 class="text-center"><?php echo $this->lang->line('certificate_verification_result'); ?></h3>
                        
                        <?php if ($certificate) { ?>
                            <div class="alert alert-success">
                                <i class="fa fa-check-circle"></i> <?php echo $this->lang->line('certificate_verified_successfully'); ?>
                            </div>
                            
                            <div class="panel panel-default">
                                <div class="panel-heading">
                                    <h4><?php echo $this->lang->line('certificate_details'); ?></h4>
                                </div>
                                <div class="panel-body">
                                    <table class="table table-bordered table-striped">
                                        <tr>
                                            <th width="30%"><?php echo $this->lang->line('certificate_name'); ?></th>
                                            <td><?php echo $certificate['certificate_name']; ?></td>
                                        </tr>
                                        <tr>
                                            <th><?php echo $this->lang->line('certificate_reference_no'); ?></th>
                                            <td><?php echo $certificate['certificate_ref_no']; ?></td>
                                        </tr>
                                        <tr>
                                            <th><?php echo $this->lang->line('student_name'); ?></th>
                                            <td><?php echo $certificate['firstname'] . ' ' . $certificate['lastname']; ?></td>
                                        </tr>
                                        <tr>
                                            <th><?php echo $this->lang->line('class'); ?></th>
                                            <td><?php echo $certificate['class'] . ' (' . $certificate['section'] . ')'; ?></td>
                                        </tr>
                                        <tr>
                                            <th><?php echo $this->lang->line('issue_date'); ?></th>
                                            <td><?php echo date($this->customlib->getSchoolDateFormat(), strtotime($certificate['created_at'])); ?></td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                            
                        <?php } else { ?>
                            <div class="alert alert-danger">
                                <i class="fa fa-times-circle"></i> <?php echo $this->lang->line('certificate_not_found'); ?>
                            </div>
                            <div class="alert alert-info">
                                <?php echo $this->lang->line('certificate_with_reference_no') . ' <strong>' . $ref_no . '</strong> ' . $this->lang->line('not_found_in_our_records'); ?>
                            </div>
                        <?php } ?>
                        
                        <div class="text-center">
                            <a href="<?php echo site_url('verifycertificate'); ?>" class="btn btn-primary">
                                <i class="fa fa-arrow-left"></i> <?php echo $this->lang->line('back_to_verification'); ?>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
