<?php
$currency_symbol = $this->customlib->getSchoolCurrencyFormat();

?>
<style type="text/css">
    @media print {
    .displaynone { display:block !important;}
}
</style>
 <link rel="stylesheet" href="<?php echo base_url(); ?>backend/dist/css/multi_branch.css">
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <!-- general form elements -->
                <div class="box box-primary">
                    <div class="box-header ptbnull">
                        <h3 class="box-title titlefix"><?php echo $this->lang->line('overview'); ?> </h3>
                      
                        <div class="box-tools pull-right">
                            <button class="btn btn-primary btn-xs print_page" title="<?php echo $this->lang->line('print'); ?>">
                                
                        <i class="fa fa-print"></i>
                            </button>
                        </div><!-- /.box-tools -->
                    </div><!-- /.box-header -->
                    <div id="print_div">
                    <div class="box-body">
                        <h3 class="displaynone"><?php echo $this->lang->line('overview'); ?> </h3>
                        
                        <!-- Graph Section -->
                        <div class="row" style="margin-top: 0;">
                            <div class="col-md-6">
                                <div class="box box-info" style="margin-bottom: 10px;">
                                    <div class="box-header with-border" style="padding: 5px 10px;">
                                        <h3 class="box-title" style="font-size: 14px;"><?php echo $this->lang->line('fees_collection'); ?></h3>
                                    </div>
                                    <div class="box-body" style="padding: 5px;">
                                        <div style="height: 200px;">
                                            <canvas id="feesChart"></canvas>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="box box-success" style="margin-bottom: 10px;">
                                    <div class="box-header with-border" style="padding: 5px 10px;">
                                        <h3 class="box-title" style="font-size: 14px;"><?php echo $this->lang->line('student_distribution'); ?></h3>
                                    </div>
                                    <div class="box-body" style="padding: 5px;">
                                        <div style="height: 200px;">
                                            <canvas id="studentChart"></canvas>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Transport Fees Graph Section -->
                        <div class="row" style="margin-top: 0;">
                            <div class="col-md-6">
                                <div class="box box-warning" style="margin-bottom: 10px;">
                                    <div class="box-header with-border" style="padding: 5px 10px;">
                                        <h3 class="box-title" style="font-size: 14px;"><?php echo $this->lang->line('transport_fees_details'); ?></h3>
                                    </div>
                                    <div class="box-body" style="padding: 5px;">
                                        <div style="height: 200px;">
                                            <canvas id="transportFeesChart"></canvas>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="box box-primary" style="margin-bottom: 10px;">
                                    <div class="box-header with-border" style="padding: 5px 10px;">
                                        <h3 class="box-title" style="font-size: 14px;"><?php echo $this->lang->line('student_admission'); ?></h3>
                                    </div>
                                    <div class="box-body" style="padding: 5px;">
                                        <div style="height: 200px;">
                                            <canvas id="admissionChart"></canvas>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Library and Alumni Graph Section -->
                        <div class="row" style="margin-top: 0;">
                            <div class="col-md-6">
                                <div class="box box-danger" style="margin-bottom: 10px;">
                                    <div class="box-header with-border" style="padding: 5px 10px;">
                                        <h3 class="box-title" style="font-size: 14px;"><?php echo $this->lang->line('library_details'); ?></h3>
                                    </div>
                                    <div class="box-body" style="padding: 5px;">
                                        <div style="height: 200px;">
                                            <canvas id="libraryChart"></canvas>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="box box-info" style="margin-bottom: 10px;">
                                    <div class="box-header with-border" style="padding: 5px 10px;">
                                        <h3 class="box-title" style="font-size: 14px;"><?php echo $this->lang->line('alumni_students'); ?></h3>
                                    </div>
                                    <div class="box-body" style="padding: 5px;">
                                        <div style="height: 200px;">
                                            <canvas id="alumniChart"></canvas>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Staff Payroll and Attendance Graph Section -->
                        <div class="row" style="margin-top: 0;">
                            <div class="col-md-6">
                                <div class="box box-success" style="margin-bottom: 10px;">
                                    <div class="box-header with-border" style="padding: 5px 10px;">
                                        <h3 class="box-title" style="font-size: 14px;"><?php echo $this->lang->line('staff_payroll_of'); ?> <?php echo $this->lang->line(strtolower($month)); ?></h3>
                                    </div>
                                    <div class="box-body" style="padding: 5px;">
                                        <div style="height: 200px;">
                                            <canvas id="payrollChart"></canvas>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="box box-primary" style="margin-bottom: 10px;">
                                    <div class="box-header with-border" style="padding: 5px 10px;">
                                        <h3 class="box-title" style="font-size: 14px;"><?php echo $this->lang->line('staff_attendance_details'); ?></h3>
                                    </div>
                                    <div class="box-body" style="padding: 5px;">
                                        <div style="height: 200px;">
                                            <canvas id="staffAttendanceChart"></canvas>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="box-table-card mb25">
                        <h4 class="pagetitleh-box"><?php echo $this->lang->line('fees_details'); ?></h4>
                        <div class="table-responsive mt5">
                        <table class="table table-hover mb5 table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th width="26%"><?php echo $this->lang->line('branch'); ?> </th>
                                    <th><?php echo $this->lang->line('current_session'); ?></th>
                                    <th><?php echo $this->lang->line('total_students'); ?></th>
                                    <th class="text text-right"><?php echo $this->lang->line('total_fees'); ?></th>
                                    <th class="text text-right"><?php echo $this->lang->line('total_paid_fees'); ?></th>
                                    <th class="text text-right"><?php echo $this->lang->line('total_balance_fees'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                   <?php
                                if (!empty($school_students)) {
                                    foreach ($school_students as $school_key => $school_value) {
                                                                  
                                        ?>
                                <tr>
                                    <td width="26%"><?php echo $school_value['name']; ?></td>
                                    <td><?php echo $school_value['session']; ?></td>
                                    <td><?php echo $school_value['total_student']; ?></td>
                                    <td class="text text-right"><?php echo $currency_symbol.amountFormat($school_value['total_fees']); ?></td>
                                    <td class="text text-right"><?php echo $currency_symbol.amountFormat($school_value['total_paid']); ?></td>
                                    <td class="text text-right"><?php echo $currency_symbol.amountFormat($school_value['total_balance']); ?></td>
                                </tr>
                                <?php

                                    }

                                } else {

                                }

                                ?>
                            </tbody>
                        </table>
                    </div>
                    </div>
                    <div class="box-table-card mb25">
                        <h4 class="pagetitleh-box"><?php echo $this->lang->line('transport_fees_details'); ?></h4>

                      <div class="table-responsive mt5">
                        <table class="table table-hover mb5 table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th width="26%"><?php echo $this->lang->line('branch'); ?></th>
                                    <th><?php echo $this->lang->line('current_session'); ?></th>                  
                                    <th class="text text-right"><?php echo $this->lang->line('total_fees'); ?></th>
                                    <th class="text text-right"><?php echo $this->lang->line('total_paid_fees'); ?></th>
                                    <th class="text text-right"><?php echo $this->lang->line('total_balance_fees'); ?></th>
                                </tr>
                            </thead>
                            <tbody>

                                   <?php
                                if (!empty($school_transport_fees)) {
                                    foreach ($school_transport_fees as $school_key => $school_value) {
                                       
                                        ?>
                                <tr>
                                    <td width="26%"><?php echo $school_value['name']; ?></td>
                                    <td ><?php echo $school_value['session']; ?></td>                                
                                    <td class="text text-right"><?php echo $currency_symbol.amountFormat($school_value['total_fees']); ?></td>
                                    <td class="text text-right"><?php echo $currency_symbol.amountFormat($school_value['total_paid']); ?></td>
                                    <td class="text text-right"><?php echo $currency_symbol.amountFormat($school_value['total_balance']); ?></td>
                                </tr>
                                <?php

                                    }

                                } else {

                                }

                                ?>
                            </tbody>
                        </table>
                    </div>     
                    </div>
                    <div class="box-table-card mb25">
                     <h4 class="pagetitleh-box"><?php echo $this->lang->line('student_admission'); ?></h4>
                      <div class="table-responsive mt5">
                        <table class="table table-hover mb5 table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th><?php echo $this->lang->line('branch'); ?></th>
                                    <th><?php echo $this->lang->line('current_session'); ?></th>
                                    <th><?php echo $this->lang->line('offline_admission'); ?></th>
                                    <th><?php echo $this->lang->line('online_admission'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                   <?php

                                if (!empty($student_admission_list)) {
                                    foreach ($student_admission_list as $student_key => $student_value) {                                       
                                        ?>
                                <tr>
                                    <td width="26%"><?php echo $student_value['name']; ?></td>
                                    <td><?php echo $student_value['session']; ?></td>
                                    <td><?php echo $student_value['offline_admission']; ?></td>
                                    <td><?php echo $student_value['online_admission']; ?></td>                              

                                </tr>
                                <?php

                                    }

                                } else {

                                }

                                ?>
                            </tbody>
                        </table>
                    </div>
                    </div>
                    <div class="box-table-card mb25">
                       <h4 class="pagetitleh-box"><?php echo $this->lang->line('library_details'); ?></h4>
                      <div class="table-responsive mt5">
                        <table class="table table-hover mb5 table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th><?php echo $this->lang->line('branch'); ?></th>
                                    <th><?php echo $this->lang->line('total_books'); ?></th>
                                    <th><?php echo $this->lang->line('members'); ?></th>
                                    <th><?php echo $this->lang->line('book_issued'); ?></th>                                
                                </tr>
                            </thead>
                            <tbody>
                                   <?php

                                if (!empty($student_books_list)) {
                                    foreach ($student_books_list as $books_key => $books_value) {
                                       
                                        ?>
                                <tr>
                                    <td width="26%"><?php echo $books_value['name']; ?></td>
                                    <td><?php echo $books_value['total_books']; ?></td>
                                    <td><?php echo $books_value['libarary_members']; ?></td>
                                    <td><?php echo $books_value['book_issued']; ?></td>

                                </tr>
                                <?php

                                    }

                                } else {

                                }

                                ?>
                            </tbody>
                        </table>
                    </div>
                    </div>

                    <div class="box-table-card mb25">
                      <h4 class="pagetitleh-box"><?php echo $this->lang->line('alumni_students'); ?></h4>
                      <div class="table-responsive mt5">
                        <table class="table table-hover mb5 table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th><?php echo $this->lang->line('branch'); ?></th>                                  
                                    <th><?php echo $this->lang->line('alumni_students'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                   <?php

                                if (!empty($alumni_student_list)) {
                                    foreach ($alumni_student_list as $alumini_student_key => $alumini_student_value) {
                                       
                                        ?>
                                <tr>
                                    <td width="26%"><?php echo $alumini_student_value['name']; ?></td>
                                    <td><?php echo $alumini_student_value['total_alumni_student']; ?></td>             

                                </tr>
                                <?php

                                    }

                                } else {

                                }

                                ?>
                            </tbody>
                        </table>
                    </div>
                    </div>
                    <div class="box-table-card mb25">
                     <h4 class="pagetitleh-box"><?php echo $this->lang->line('staff_payroll_of'); ?> <?php echo $this->lang->line(strtolower($month)) ; ?> </h4>
                      <div class="table-responsive mt5">
                        <table class="table table-hover mb5 table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th width="26%"><?php echo $this->lang->line('branch'); ?></th>
                                    <th width="150"><?php echo $this->lang->line('total_staff'); ?></th>
                                    <th width="140"><?php echo $this->lang->line('payroll_generated'); ?> </th>
                                    <th><?php echo $this->lang->line('payroll_not_generated'); ?></th>
                                    <th><?php echo $this->lang->line('payroll_paid'); ?></th>
                                    <th class="text-right"><?php echo $this->lang->line('net_amount'); ?> </th>
                                    <th class="text-right"><?php echo $this->lang->line('paid_amount'); ?></th>
                                  
                                </tr>
                            </thead>
                            <tbody>

                                   <?php
                                if (!empty($staff_payslip)) {
                                    foreach ($staff_payslip as $staff_payslip_key => $staff_payslip_value) {
                                    
                                        ?>
                                <tr>
                                    <td width="26%"><?php echo $staff_payslip_value['name']; ?></td>
                                    <td><?php echo $staff_payslip_value['staff']; ?></td>
                                    <td><?php echo $staff_payslip_value['staff_status_generated']; ?></td>
                                    <td><?php echo $staff_payslip_value['staff'] - $staff_payslip_value['staff_status_generated']-$staff_payslip_value['staff_status_paid']; ?></td>
                                    <td><?php echo $staff_payslip_value['staff_status_paid']; ?></td>
                                    <td class="text text-right"><?php echo $currency_symbol.amountFormat($staff_payslip_value['payroll_amount']); ?></td>
                                    <td class="text text-right"><?php echo $currency_symbol.amountFormat($staff_payslip_value['payroll_amount_paid']); ?></td>                             

                                </tr>
                                <?php

                                    }

                                } else {

                                }

                                ?>
                            </tbody>
                        </table>
                    </div>
                    </div>
                    <div class="box-table-card mb25">
                    <h4 class="pagetitleh-box"><?php echo $this->lang->line('staff_attendance_details'); ?> <?php echo $this->customlib->dateformat(date("Y/m/d")) ?> </h4>

                      <div class="table-responsive mt5">
                        <table class="table table-hover mb5 table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th><?php echo $this->lang->line('branch'); ?></th>
                                    <th><?php echo $this->lang->line('total_staff'); ?></th>
                                    <th><?php echo $this->lang->line('present'); ?></th>
                                    <th><?php echo $this->lang->line('absent'); ?></th>                                 

                                </tr>
                            </thead>
                            <tbody>
                                   <?php

                                if (!empty($staff_list)) {
                                    foreach ($staff_list as $staff_key => $staff_value) {                                    
                                       
                                        ?>
                                <tr>
                                    <td width="26%"><?php echo $staff_value['name']; ?></td>
                                    <td><?php echo $staff_value['total_staff']; ?></td>
                                    <td><?php echo ($staff_value['staff_present'] || $staff_value['staff_absent']) ? $staff_value['staff_present'] : "-"; ?></td>
                                    <td><?php  echo ($staff_value['staff_present'] || $staff_value['staff_absent']) ? $staff_value['staff_absent'] : "-"; ?> </td>                     

                                </tr>
                                <?php

                                    }

                                } else {

                                }

                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                    <div class="box-table-card mb25">
                      <h4 class="pagetitleh-box"><?php echo $this->lang->line('user_log_details'); ?></h4>
                      <div class="table-responsive mt5">
                        <table class="table table-hover mb5 table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th><?php echo $this->lang->line('branch'); ?></th>
                                    <th><?php echo $this->lang->line('total_user_log'); ?></th>                            

                                </tr>
                            </thead>
                            <tbody>
                                   <?php

                                if (!empty($user_log_list)) {
                                    foreach ($user_log_list as $user_log_key => $user_log_value) {

                                        ?>
                                <tr>
                                    <td width="26%"><?php echo $user_log_value['name']; ?></td>
                                    <td><?php echo $user_log_value['total_userlog']; ?></td>                                 

                                </tr>
                                <?php

                                    }

                                } else {

                                }

                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                    </div><!-- /.box-body -->
                    </div><!-- /.box-body -->
                </div>
            </div><!--/.col (left) -->            <!-- right column -->

        </div>

    </section><!-- /.content -->
</div><!-- /.content-wrapper -->


<script type="text/javascript">
    $(document).on('click','.print_page',function(){
       
        var page_content= document.getElementById("print_div").innerHTML;
             Popup(page_content,false);

    });
       function Popup(data, winload = false)
    {
        var frame1 = $('<iframe />').attr("id", "printDiv");
        frame1[0].name = "frame1";
        frame1.css({"position": "absolute", "top": "-1000000px"});
        $("body").append(frame1);
        var frameDoc = frame1[0].contentWindow ? frame1[0].contentWindow : frame1[0].contentDocument.document ? frame1[0].contentDocument.document : frame1[0].contentDocument;
        frameDoc.document.open();
        //Create a new HTML document.
        frameDoc.document.write('<html>');
        frameDoc.document.write('<head>');
        frameDoc.document.write('<title></title>');
        frameDoc.document.write('<link rel="stylesheet" href="' + base_url + 'backend/bootstrap/css/bootstrap.min.css">');
        frameDoc.document.write('<link rel="stylesheet" href="' + base_url + 'backend/dist/css/font-awesome.min.css">');
        frameDoc.document.write('<link rel="stylesheet" href="' + base_url + 'backend/dist/css/ionicons.min.css">');
        frameDoc.document.write('<link rel="stylesheet" href="' + base_url + 'backend/dist/css/AdminLTE.min.css">');
        frameDoc.document.write('<link rel="stylesheet" href="' + base_url + 'backend/dist/css/skins/_all-skins.min.css">');
        frameDoc.document.write('<link rel="stylesheet" href="' + base_url + 'backend/plugins/iCheck/flat/blue.css">');
        frameDoc.document.write('<link rel="stylesheet" href="' + base_url + 'backend/plugins/morris/morris.css">');
        frameDoc.document.write('<link rel="stylesheet" href="' + base_url + 'backend/plugins/jvectormap/jquery-jvectormap-1.2.2.css">');
        frameDoc.document.write('<link rel="stylesheet" href="' + base_url + 'backend/plugins/datepicker/datepicker3.css">');
        frameDoc.document.write('<link rel="stylesheet" href="' + base_url + 'backend/plugins/daterangepicker/daterangepicker-bs3.css">');
        frameDoc.document.write('</head>');
        frameDoc.document.write('<body>');
        frameDoc.document.write(data);
        frameDoc.document.write('</body>');
        frameDoc.document.write('</html>');
        frameDoc.document.close();
        setTimeout(function () {
        document.getElementById('printDiv').contentWindow.focus();
        document.getElementById('printDiv').contentWindow.print();
        $("#printDiv", top.document).remove();
            if (winload) {
                window.location.reload(true);
            }
        }, 500);

        return true;
    }
</script>

<script type="text/javascript">
    // Initialize charts after page load
    $(document).ready(function() {
        // Load Chart.js directly from CDN
        var script = document.createElement('script');
        script.src = 'https://cdn.jsdelivr.net/npm/chart.js@3.7.1/dist/chart.min.js';
        script.onload = function() {
            setTimeout(initializeCharts, 500); // Add delay to ensure DOM is ready
        };
        document.head.appendChild(script);
    });
    
    function initializeCharts() {
        console.log('Initializing charts...');
        
        // Get all canvas elements
        var feesCanvas = document.getElementById('feesChart');
        var studentCanvas = document.getElementById('studentChart');
        var transportFeesCanvas = document.getElementById('transportFeesChart');
        var admissionCanvas = document.getElementById('admissionChart');
        var libraryCanvas = document.getElementById('libraryChart');
        var alumniCanvas = document.getElementById('alumniChart');
        var payrollCanvas = document.getElementById('payrollChart');
        var staffAttendanceCanvas = document.getElementById('staffAttendanceChart');
        
        // Check if main canvas elements exist
        if (!feesCanvas || !studentCanvas) {
            console.error('Main canvas elements not found');
            return;
        }
        
        // Common chart colors
        var chartColors = {
            backgroundColor: [
                'rgba(255, 99, 132, 0.7)',
                'rgba(54, 162, 235, 0.7)',
                'rgba(255, 206, 86, 0.7)',
                'rgba(75, 192, 192, 0.7)',
                'rgba(153, 102, 255, 0.7)',
                'rgba(255, 159, 64, 0.7)',
                'rgba(199, 199, 199, 0.7)',
                'rgba(83, 102, 255, 0.7)',
                'rgba(40, 159, 64, 0.7)',
                'rgba(210, 199, 199, 0.7)'
            ],
            borderColor: [
                'rgba(255, 99, 132, 1)',
                'rgba(54, 162, 235, 1)',
                'rgba(255, 206, 86, 1)',
                'rgba(75, 192, 192, 1)',
                'rgba(153, 102, 255, 1)',
                'rgba(255, 159, 64, 1)',
                'rgba(199, 199, 199, 1)',
                'rgba(83, 102, 255, 1)',
                'rgba(40, 159, 64, 1)',
                'rgba(210, 199, 199, 1)'
            ]
        };
        
        // Common chart options
        var commonOptions = {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'right',
                    labels: {
                        boxWidth: 10,
                        font: {
                            size: 10
                        }
                    }
                }
            }
        };
        
        // Extract branch names for all charts
        var branchNames = [];
        <?php if (!empty($school_students)) { 
            foreach ($school_students as $school_key => $school_value) { ?>
                branchNames.push('<?php echo $school_value["name"]; ?>');
        <?php } } ?>
        
        // 1. Fees Collection Chart
        if (feesCanvas) {
            var feesCtx = feesCanvas.getContext('2d');
            var totalFees = [];
            var paidFees = [];
            var balanceFees = [];
            
            <?php if (!empty($school_students)) { 
                foreach ($school_students as $school_key => $school_value) { ?>
                    totalFees.push(<?php echo $school_value["total_fees"]; ?>);
                    paidFees.push(<?php echo $school_value["total_paid"]; ?>);
                    balanceFees.push(<?php echo $school_value["total_balance"]; ?>);
            <?php } } ?>
            
            var feesChart = new Chart(feesCtx, {
                type: 'bar',
                data: {
                    labels: branchNames,
                    datasets: [
                        {
                            label: '<?php echo $this->lang->line("total_fees"); ?>',
                            data: totalFees,
                            backgroundColor: 'rgba(54, 162, 235, 0.5)',
                            borderColor: 'rgba(54, 162, 235, 1)',
                            borderWidth: 1
                        },
                        {
                            label: '<?php echo $this->lang->line("total_paid_fees"); ?>',
                            data: paidFees,
                            backgroundColor: 'rgba(75, 192, 192, 0.5)',
                            borderColor: 'rgba(75, 192, 192, 1)',
                            borderWidth: 1
                        },
                        {
                            label: '<?php echo $this->lang->line("total_balance_fees"); ?>',
                            data: balanceFees,
                            backgroundColor: 'rgba(255, 99, 132, 0.5)',
                            borderColor: 'rgba(255, 99, 132, 1)',
                            borderWidth: 1
                        }
                    ]
                },
                options: {
                    ...commonOptions,
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    }
                }
            });
        }
        
        // 2. Student Distribution Chart
        if (studentCanvas) {
            var studentCtx = studentCanvas.getContext('2d');
            var studentCounts = [];
            
            <?php if (!empty($school_students)) { 
                foreach ($school_students as $school_key => $school_value) { ?>
                    studentCounts.push(<?php echo $school_value["total_student"]; ?>);
            <?php } } ?>
            
            var studentChart = new Chart(studentCtx, {
                type: 'pie',
                data: {
                    labels: branchNames,
                    datasets: [{
                        data: studentCounts,
                        backgroundColor: chartColors.backgroundColor,
                        borderColor: chartColors.borderColor,
                        borderWidth: 1
                    }]
                },
                options: commonOptions
            });
        }
        
        // 3. Transport Fees Chart
        if (transportFeesCanvas) {
            var transportFeesCtx = transportFeesCanvas.getContext('2d');
            var transportTotalFees = [];
            var transportPaidFees = [];
            var transportBalanceFees = [];
            
            <?php if (!empty($school_transport_fees)) { 
                foreach ($school_transport_fees as $transport_key => $transport_value) { ?>
                    transportTotalFees.push(<?php echo $transport_value["total_fees"]; ?>);
                    transportPaidFees.push(<?php echo $transport_value["total_paid"]; ?>);
                    transportBalanceFees.push(<?php echo $transport_value["total_balance"]; ?>);
            <?php } } ?>
            
            var transportLabels = [];
            <?php if (!empty($school_transport_fees)) { 
                foreach ($school_transport_fees as $transport_key => $transport_value) { ?>
                    transportLabels.push('<?php echo $transport_value["name"]; ?>');
            <?php } } ?>
            
            var transportFeesChart = new Chart(transportFeesCtx, {
                type: 'bar',
                data: {
                    labels: transportLabels,
                    datasets: [
                        {
                            label: '<?php echo $this->lang->line("total_fees"); ?>',
                            data: transportTotalFees,
                            backgroundColor: 'rgba(255, 159, 64, 0.5)',
                            borderColor: 'rgba(255, 159, 64, 1)',
                            borderWidth: 1
                        },
                        {
                            label: '<?php echo $this->lang->line("total_paid_fees"); ?>',
                            data: transportPaidFees,
                            backgroundColor: 'rgba(75, 192, 192, 0.5)',
                            borderColor: 'rgba(75, 192, 192, 1)',
                            borderWidth: 1
                        },
                        {
                            label: '<?php echo $this->lang->line("total_balance_fees"); ?>',
                            data: transportBalanceFees,
                            backgroundColor: 'rgba(255, 99, 132, 0.5)',
                            borderColor: 'rgba(255, 99, 132, 1)',
                            borderWidth: 1
                        }
                    ]
                },
                options: {
                    ...commonOptions,
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    }
                }
            });
        }
        
        // 4. Student Admission Chart
        if (admissionCanvas) {
            var admissionCtx = admissionCanvas.getContext('2d');
            var offlineAdmissions = [];
            var onlineAdmissions = [];
            var admissionLabels = [];
            
            <?php if (!empty($student_admission_list)) { 
                foreach ($student_admission_list as $admission_key => $admission_value) { ?>
                    admissionLabels.push('<?php echo $admission_value["name"]; ?>');
                    offlineAdmissions.push(<?php echo $admission_value["offline_admission"]; ?>);
                    onlineAdmissions.push(<?php echo $admission_value["online_admission"]; ?>);
            <?php } } ?>
            
            var admissionChart = new Chart(admissionCtx, {
                type: 'bar',
                data: {
                    labels: admissionLabels,
                    datasets: [
                        {
                            label: '<?php echo $this->lang->line("offline_admission"); ?>',
                            data: offlineAdmissions,
                            backgroundColor: 'rgba(54, 162, 235, 0.5)',
                            borderColor: 'rgba(54, 162, 235, 1)',
                            borderWidth: 1
                        },
                        {
                            label: '<?php echo $this->lang->line("online_admission"); ?>',
                            data: onlineAdmissions,
                            backgroundColor: 'rgba(153, 102, 255, 0.5)',
                            borderColor: 'rgba(153, 102, 255, 1)',
                            borderWidth: 1
                        }
                    ]
                },
                options: {
                    ...commonOptions,
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    }
                }
            });
        }
        
        // 5. Library Chart
        if (libraryCanvas) {
            var libraryCtx = libraryCanvas.getContext('2d');
            var totalBooks = [];
            var libraryMembers = [];
            var booksIssued = [];
            var libraryLabels = [];
            
            <?php if (!empty($student_books_list)) { 
                foreach ($student_books_list as $books_key => $books_value) { ?>
                    libraryLabels.push('<?php echo $books_value["name"]; ?>');
                    totalBooks.push(<?php echo $books_value["total_books"]; ?>);
                    libraryMembers.push(<?php echo $books_value["libarary_members"]; ?>);
                    booksIssued.push(<?php echo $books_value["book_issued"]; ?>);
            <?php } } ?>
            
            var libraryChart = new Chart(libraryCtx, {
                type: 'bar',
                data: {
                    labels: libraryLabels,
                    datasets: [
                        {
                            label: '<?php echo $this->lang->line("total_books"); ?>',
                            data: totalBooks,
                            backgroundColor: 'rgba(255, 99, 132, 0.5)',
                            borderColor: 'rgba(255, 99, 132, 1)',
                            borderWidth: 1
                        },
                        {
                            label: '<?php echo $this->lang->line("members"); ?>',
                            data: libraryMembers,
                            backgroundColor: 'rgba(54, 162, 235, 0.5)',
                            borderColor: 'rgba(54, 162, 235, 1)',
                            borderWidth: 1
                        },
                        {
                            label: '<?php echo $this->lang->line("book_issued"); ?>',
                            data: booksIssued,
                            backgroundColor: 'rgba(255, 206, 86, 0.5)',
                            borderColor: 'rgba(255, 206, 86, 1)',
                            borderWidth: 1
                        }
                    ]
                },
                options: {
                    ...commonOptions,
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    }
                }
            });
        }
        
        // 6. Alumni Students Chart
        if (alumniCanvas) {
            var alumniCtx = alumniCanvas.getContext('2d');
            var alumniCounts = [];
            var alumniLabels = [];
            
            <?php if (!empty($alumni_student_list)) { 
                foreach ($alumni_student_list as $alumni_key => $alumni_value) { ?>
                    alumniLabels.push('<?php echo $alumni_value["name"]; ?>');
                    alumniCounts.push(<?php echo $alumni_value["total_alumni_student"]; ?>);
            <?php } } ?>
            
            var alumniChart = new Chart(alumniCtx, {
                type: 'doughnut',
                data: {
                    labels: alumniLabels,
                    datasets: [{
                        data: alumniCounts,
                        backgroundColor: chartColors.backgroundColor,
                        borderColor: chartColors.borderColor,
                        borderWidth: 1
                    }]
                },
                options: commonOptions
            });
        }
        
        // 7. Staff Payroll Chart
        if (payrollCanvas) {
            var payrollCtx = payrollCanvas.getContext('2d');
            var payrollNetAmount = [];
            var payrollPaidAmount = [];
            var payrollLabels = [];
            
            <?php if (!empty($staff_payslip)) { 
                foreach ($staff_payslip as $payroll_key => $payroll_value) { ?>
                    payrollLabels.push('<?php echo $payroll_value["name"]; ?>');
                    payrollNetAmount.push(<?php echo $payroll_value["payroll_amount"]; ?>);
                    payrollPaidAmount.push(<?php echo $payroll_value["payroll_amount_paid"]; ?>);
            <?php } } ?>
            
            var payrollChart = new Chart(payrollCtx, {
                type: 'bar',
                data: {
                    labels: payrollLabels,
                    datasets: [
                        {
                            label: '<?php echo $this->lang->line("net_amount"); ?>',
                            data: payrollNetAmount,
                            backgroundColor: 'rgba(75, 192, 192, 0.5)',
                            borderColor: 'rgba(75, 192, 192, 1)',
                            borderWidth: 1
                        },
                        {
                            label: '<?php echo $this->lang->line("paid_amount"); ?>',
                            data: payrollPaidAmount,
                            backgroundColor: 'rgba(153, 102, 255, 0.5)',
                            borderColor: 'rgba(153, 102, 255, 1)',
                            borderWidth: 1
                        }
                    ]
                },
                options: {
                    ...commonOptions,
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    }
                }
            });
        }
        
        // 8. Staff Attendance Chart
        if (staffAttendanceCanvas) {
            var staffAttendanceCtx = staffAttendanceCanvas.getContext('2d');
            var staffPresent = [];
            var staffAbsent = [];
            var staffAttendanceLabels = [];
            
            <?php if (!empty($staff_list)) { 
                foreach ($staff_list as $staff_key => $staff_value) { ?>
                    staffAttendanceLabels.push('<?php echo $staff_value["name"]; ?>');
                    staffPresent.push(<?php echo ($staff_value["staff_present"] || $staff_value["staff_absent"]) ? $staff_value["staff_present"] : 0; ?>);
                    staffAbsent.push(<?php echo ($staff_value["staff_present"] || $staff_value["staff_absent"]) ? $staff_value["staff_absent"] : 0; ?>);
            <?php } } ?>
            
            var staffAttendanceChart = new Chart(staffAttendanceCtx, {
                type: 'bar',
                data: {
                    labels: staffAttendanceLabels,
                    datasets: [
                        {
                            label: '<?php echo $this->lang->line("present"); ?>',
                            data: staffPresent,
                            backgroundColor: 'rgba(75, 192, 192, 0.5)',
                            borderColor: 'rgba(75, 192, 192, 1)',
                            borderWidth: 1
                        },
                        {
                            label: '<?php echo $this->lang->line("absent"); ?>',
                            data: staffAbsent,
                            backgroundColor: 'rgba(255, 99, 132, 0.5)',
                            borderColor: 'rgba(255, 99, 132, 1)',
                            borderWidth: 1
                        }
                    ]
                },
                options: {
                    ...commonOptions,
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    }
                }
            });
        }
    }
</script>