<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-eye"></i> View Requisition
            <small>Requisition Details</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="<?php echo base_url(); ?>admin/inventory"><i class="fa fa-cubes"></i> Inventory</a></li>
            <li><a href="<?php echo base_url(); ?>admin/inventory/requisitions"><i class="fa fa-file-text"></i> Requisitions</a></li>
            <li class="active">View Requisition</li>
        </ol>
    </section>

    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-info-circle"></i> Requisition Information</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-default btn-sm" onclick="window.close()">
                                <i class="fa fa-times"></i> Close
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <?php if ($requisition) { ?>
                            <div class="row">
                                <div class="col-md-6">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th width="40%">Requisition Number:</th>
                                            <td><strong><?php echo $requisition->requisition_number; ?></strong></td>
                                        </tr>
                                        <tr>
                                            <th>Request Date:</th>
                                            <td><?php echo date('d-m-Y', strtotime($requisition->request_date)); ?></td>
                                        </tr>
                                        <tr>
                                            <th>Required Date:</th>
                                            <td><?php echo $requisition->required_date ? date('d-m-Y', strtotime($requisition->required_date)) : 'N/A'; ?></td>
                                        </tr>
                                        <tr>
                                            <th>Department:</th>
                                            <td><?php echo $requisition->department ?: 'N/A'; ?></td>
                                        </tr>
                                    </table>
                                </div>
                                <div class="col-md-6">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th width="40%">Status:</th>
                                            <td>
                                                <?php
                                                $class = '';
                                                switch ($requisition->status) {
                                                    case 'PENDING':
                                                        $class = 'label-warning';
                                                        break;
                                                    case 'APPROVED':
                                                        $class = 'label-info';
                                                        break;
                                                    case 'ISSUED':
                                                        $class = 'label-success';
                                                        break;
                                                    case 'REJECTED':
                                                        $class = 'label-danger';
                                                        break;
                                                    case 'CANCELLED':
                                                        $class = 'label-default';
                                                        break;
                                                }
                                                ?>
                                                <span class="label <?php echo $class; ?>"><?php echo $requisition->status; ?></span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>Requested By:</th>
                                            <td><?php echo $requisition->requested_by_name ?: 'N/A'; ?></td>
                                        </tr>
                                        <tr>
                                            <th>Approved By:</th>
                                            <td><?php echo $requisition->approved_by_name ?: 'N/A'; ?></td>
                                        </tr>
                                        <tr>
                                            <th>Issued By:</th>
                                            <td><?php echo $requisition->issued_by_name ?: 'N/A'; ?></td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                            
                            <?php if ($requisition->notes) { ?>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>Notes:</label>
                                            <div class="well well-sm">
                                                <?php echo nl2br(htmlspecialchars($requisition->notes)); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php } ?>

                            <div class="row">
                                <div class="col-md-12">
                                    <h4><i class="fa fa-list"></i> Requested Items</h4>
                                    <div class="table-responsive">
                                        <table class="table table-striped table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>Item Code</th>
                                                    <th>Item Name</th>
                                                    <th>Quantity Requested</th>
                                                    <th>Quantity Approved</th>
                                                    <th>Quantity Issued</th>
                                                    <th>Current Stock</th>
                                                    <th>Notes</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php if ($requisition_items && count($requisition_items) > 0) { ?>
                                                    <?php foreach ($requisition_items as $item) { ?>
                                                        <tr>
                                                            <td><?php echo $item->item_code; ?></td>
                                                            <td><?php echo $item->item_name; ?></td>
                                                            <td class="text-center"><?php echo $item->quantity_requested; ?></td>
                                                            <td class="text-center"><?php echo $item->quantity_approved ?: '0'; ?></td>
                                                            <td class="text-center"><?php echo $item->quantity_issued ?: '0'; ?></td>
                                                            <td class="text-center"><?php echo $item->current_stock ?? 'N/A'; ?></td>
                                                            <td><?php echo $item->notes ?: 'N/A'; ?></td>
                                                        </tr>
                                                    <?php } ?>
                                                <?php } else { ?>
                                                    <tr>
                                                        <td colspan="7" class="text-center">No items found for this requisition</td>
                                                    </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label>Timeline:</label>
                                        <ul class="timeline timeline-inverse">
                                            <li>
                                                <i class="fa fa-plus bg-blue"></i>
                                                <div class="timeline-item">
                                                    <span class="time"><i class="fa fa-clock-o"></i> <?php echo date('d-m-Y H:i', strtotime($requisition->created_at)); ?></span>
                                                    <h3 class="timeline-header">Requisition Created</h3>
                                                    <div class="timeline-body">
                                                        Requisition was created by <?php echo $requisition->requested_by_name; ?>
                                                    </div>
                                                </div>
                                            </li>
                                            
                                            <?php if ($requisition->status != 'PENDING') { ?>
                                                <li>
                                                    <i class="fa fa-check bg-green"></i>
                                                    <div class="timeline-item">
                                                        <span class="time"><i class="fa fa-clock-o"></i> <?php echo date('d-m-Y H:i', strtotime($requisition->updated_at)); ?></span>
                                                        <h3 class="timeline-header">Status Updated</h3>
                                                        <div class="timeline-body">
                                                            Status changed to <strong><?php echo $requisition->status; ?></strong>
                                                            <?php if ($requisition->approved_by_name && $requisition->status == 'APPROVED') { ?>
                                                                by <?php echo $requisition->approved_by_name; ?>
                                                            <?php } ?>
                                                            <?php if ($requisition->issued_by_name && $requisition->status == 'ISSUED') { ?>
                                                                by <?php echo $requisition->issued_by_name; ?>
                                                            <?php } ?>
                                                        </div>
                                                    </div>
                                                </li>
                                            <?php } ?>
                                            
                                            <li>
                                                <i class="fa fa-clock-o bg-gray"></i>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        <?php } else { ?>
                            <div class="alert alert-danger">
                                <i class="fa fa-exclamation-triangle"></i> Requisition not found!
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<style>
.timeline {
    position: relative;
    margin: 0 0 30px 0;
    padding: 0;
    list-style: none;
}

.timeline:before {
    content: '';
    position: absolute;
    top: 0;
    bottom: 0;
    left: 31px;
    width: 4px;
    background: #ddd;
}

.timeline > li {
    position: relative;
    margin-right: 10px;
    margin-bottom: 15px;
}

.timeline > li:before,
.timeline > li:after {
    content: " ";
    display: table;
}

.timeline > li:after {
    clear: both;
}

.timeline > li > .timeline-item {
    -webkit-box-shadow: 0 1px 1px rgba(0, 0, 0, 0.1);
    box-shadow: 0 1px 1px rgba(0, 0, 0, 0.1);
    border-radius: 3px;
    margin-top: 0;
    background: #fff;
    color: #444;
    margin-left: 60px;
    margin-right: 15px;
    padding: 0;
    position: relative;
}

.timeline > li > .timeline-item > .time {
    color: #999;
    float: right;
    padding: 10px;
    font-size: 12px;
}

.timeline > li > .timeline-item > .timeline-header {
    margin: 0;
    color: #555;
    border-bottom: 1px solid #f4f4f4;
    padding: 10px;
    font-size: 16px;
    line-height: 1.1;
}

.timeline > li > .timeline-item > .timeline-body,
.timeline > li > .timeline-item > .timeline-footer {
    padding: 10px;
}

.timeline > li > .fa,
.timeline > li > .glyphicon,
.timeline > li > .ion {
    width: 30px;
    height: 30px;
    font-size: 15px;
    line-height: 30px;
    position: absolute;
    color: #666;
    background: #d2d6de;
    border-radius: 50%;
    text-align: center;
    left: 18px;
    top: 0;
}

.bg-blue {
    background-color: #3c8dbc !important;
    color: #fff !important;
}

.bg-green {
    background-color: #00a65a !important;
    color: #fff !important;
}

.bg-gray {
    background-color: #d2d6de !important;
    color: #fff !important;
}
</style>
