<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-exchange"></i> Stock Movements
            <small>Track inventory movements</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="<?php echo base_url(); ?>admin/inventory"><i class="fa fa-cubes"></i> Inventory</a></li>
            <li class="active">Stock Movements</li>
        </ol>
    </section>

    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-list"></i> Stock Movements History</h3>
                        <div class="box-tools pull-right">
                            <?php if ($this->rbac->hasPrivilege('inventory_movements', 'can_add')) { ?>
                                <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#addMovementModal">
                                    <i class="fa fa-plus"></i> Record Movement
                                </button>
                            <?php } ?>
                        </div>
                    </div>
                    <div class="box-body">
                        <!-- Filter Section -->
                        <div class="row">
                            <div class="col-md-12">
                                <div class="box box-info collapsed-box">
                                    <div class="box-header with-border">
                                        <h3 class="box-title">Filters</h3>
                                        <div class="box-tools pull-right">
                                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                                <i class="fa fa-plus"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="box-body">
                                        <form id="filterForm">
                                            <div class="row">
                                                <div class="col-md-3">
                                                    <div class="form-group">
                                                        <label>From Date</label>
                                                        <input type="date" class="form-control" id="date_from" name="date_from">
                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <div class="form-group">
                                                        <label>To Date</label>
                                                        <input type="date" class="form-control" id="date_to" name="date_to">
                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <div class="form-group">
                                                        <label>Movement Type</label>
                                                        <select class="form-control" id="movement_type_filter" name="movement_type">
                                                            <option value="">All Types</option>
                                                            <option value="IN">Stock In</option>
                                                            <option value="OUT">Stock Out</option>
                                                            <option value="ADJUSTMENT">Adjustment</option>
                                                            <option value="TRANSFER">Transfer</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <div class="form-group">
                                                        <label>&nbsp;</label>
                                                        <div>
                                                            <button type="button" class="btn btn-info" onclick="applyFilters()">
                                                                <i class="fa fa-filter"></i> Apply Filters
                                                            </button>
                                                            <button type="button" class="btn btn-default" onclick="clearFilters()">
                                                                <i class="fa fa-refresh"></i> Clear
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="table-responsive">
                            <table class="table table-striped table-bordered table-hover" id="movementsTable">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Item</th>
                                        <th>Type</th>
                                        <th>Quantity</th>
                                        <th>Unit Price</th>
                                        <th>Total Amount</th>
                                        <th>Reference</th>
                                        <th>Staff</th>
                                        <th>Notes</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($movements as $movement) { ?>
                                        <tr>
                                            <td><?php echo date('d-m-Y', strtotime($movement->movement_date)); ?></td>
                                            <td>
                                                <strong><?php echo $movement->item_name; ?></strong>
                                                <br><small class="text-muted"><?php echo $movement->item_code; ?></small>
                                            </td>
                                            <td>
                                                <?php
                                                $class = '';
                                                switch ($movement->movement_type) {
                                                    case 'IN':
                                                        $class = 'label-success';
                                                        break;
                                                    case 'OUT':
                                                        $class = 'label-danger';
                                                        break;
                                                    case 'ADJUSTMENT':
                                                        $class = 'label-warning';
                                                        break;
                                                    case 'TRANSFER':
                                                        $class = 'label-info';
                                                        break;
                                                }
                                                ?>
                                                <span class="label <?php echo $class; ?>"><?php echo $movement->movement_type; ?></span>
                                            </td>
                                            <td><?php echo $movement->quantity; ?></td>
                                            <td><?php echo $movement->unit_price ? number_format($movement->unit_price, 2) : 'N/A'; ?></td>
                                            <td><?php echo $movement->total_amount ? number_format($movement->total_amount, 2) : 'N/A'; ?></td>
                                            <td>
                                                <?php if ($movement->reference_type) { ?>
                                                    <span class="label label-default"><?php echo $movement->reference_type; ?></span>
                                                    <?php if ($movement->reference_number) { ?>
                                                        <br><small><?php echo $movement->reference_number; ?></small>
                                                    <?php } ?>
                                                <?php } else { ?>
                                                    N/A
                                                <?php } ?>
                                            </td>
                                            <td><?php echo $movement->staff_name ?: 'System'; ?></td>
                                            <td><?php echo $movement->notes ? substr($movement->notes, 0, 30) . (strlen($movement->notes) > 30 ? '...' : '') : 'N/A'; ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Add Movement Modal -->
<div class="modal fade" id="addMovementModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title"><i class="fa fa-plus"></i> Record Stock Movement</h4>
            </div>
            <form id="addMovementForm">
                <div class="modal-body">
                    <div class="form-group">
                        <label for="item_id">Item <span class="text-danger">*</span></label>
                        <select class="form-control select2" id="item_id" name="item_id" required>
                            <option value="">Select Item</option>
                            <?php foreach ($items as $item) { ?>
                                <option value="<?php echo $item->id; ?>" data-stock="<?php echo $item->current_stock; ?>" data-price="<?php echo $item->purchase_price; ?>">
                                    <?php echo $item->name . ' (' . $item->item_code . ') - Stock: ' . $item->current_stock; ?>
                                </option>
                            <?php } ?>
                        </select>
                        <small id="current_stock_info" class="text-muted"></small>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="movement_type">Movement Type <span class="text-danger">*</span></label>
                                <select class="form-control" id="movement_type" name="movement_type" required>
                                    <option value="">Select Type</option>
                                    <option value="IN">Stock In</option>
                                    <option value="OUT">Stock Out</option>
                                    <option value="ADJUSTMENT">Adjustment</option>
                                    <option value="TRANSFER">Transfer</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="quantity">Quantity <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="quantity" name="quantity" required min="1">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="unit_price">Unit Price</label>
                                <input type="number" class="form-control" id="unit_price" name="unit_price" step="0.01" min="0">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="movement_date">Movement Date</label>
                                <input type="date" class="form-control" id="movement_date" name="movement_date" value="<?php echo date('Y-m-d'); ?>">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="reference_type">Reference Type</label>
                        <select class="form-control" id="reference_type" name="reference_type">
                            <option value="">Select Reference</option>
                            <option value="PURCHASE">Purchase</option>
                            <option value="SALE">Sale</option>
                            <option value="RETURN">Return</option>
                            <option value="DAMAGE">Damage</option>
                            <option value="LOST">Lost</option>
                            <option value="MANUAL">Manual Adjustment</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="reference_number">Reference Number</label>
                        <input type="text" class="form-control" id="reference_number" name="reference_number">
                    </div>
                    <div class="form-group">
                        <label for="notes">Notes</label>
                        <textarea class="form-control" id="notes" name="notes" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Record Movement</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Initialize DataTable
    $('#movementsTable').DataTable({
        "paging": true,
        "lengthChange": true,
        "searching": true,
        "ordering": true,
        "info": true,
        "autoWidth": false,
        "responsive": true,
        "order": [[0, "desc"]]
    });

    // Initialize Select2 for item selection
    $('#item_id').select2({
        placeholder: "Search and select item...",
        allowClear: true
    });

    // Show current stock when item is selected
    $('#item_id').on('change', function() {
        var selectedOption = $(this).find('option:selected');
        var currentStock = selectedOption.data('stock');
        var price = selectedOption.data('price');
        
        if (currentStock !== undefined) {
            $('#current_stock_info').text('Current Stock: ' + currentStock);
            $('#unit_price').val(price || '');
        } else {
            $('#current_stock_info').text('');
            $('#unit_price').val('');
        }
    });

    // Add Movement Form Submit
    $('#addMovementForm').on('submit', function(e) {
        e.preventDefault();
        
        // Validate stock for OUT movements
        var movementType = $('#movement_type').val();
        var quantity = parseInt($('#quantity').val());
        var currentStock = parseInt($('#item_id').find('option:selected').data('stock'));
        
        if (movementType === 'OUT' && quantity > currentStock) {
            alert('Error: Quantity exceeds current stock (' + currentStock + ')');
            return;
        }
        
        $.ajax({
            url: '<?php echo base_url("admin/inventory/add_stock_movement"); ?>',
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    $('#addMovementModal').modal('hide');
                    location.reload();
                } else {
                    alert('Error: ' + response.error);
                }
            },
            error: function() {
                alert('An error occurred while recording the movement.');
            }
        });
    });
});

function applyFilters() {
    // Implement filter functionality
    var dateFrom = $('#date_from').val();
    var dateTo = $('#date_to').val();
    var movementType = $('#movement_type_filter').val();
    
    // Reload table with filters
    location.reload(); // Simple reload for now, can be enhanced with AJAX
}

function clearFilters() {
    $('#filterForm')[0].reset();
    location.reload();
}
</script>

<style>
.select2-container {
    width: 100% !important;
}

.select2-container--default .select2-selection--single {
    height: 34px;
    border: 1px solid #d2d6de;
    border-radius: 0;
}

.select2-container--default .select2-selection--single .select2-selection__rendered {
    line-height: 32px;
    padding-left: 12px;
}

.select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 32px;
}
</style>
