<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-file-text"></i> Inventory Requisitions
            <small>Manage inventory requests</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="<?php echo base_url(); ?>admin/inventory"><i class="fa fa-cubes"></i> Inventory</a></li>
            <li class="active">Requisitions</li>
        </ol>
    </section>

    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-list"></i> Requisitions List</h3>
                        <div class="box-tools pull-right">
                            <?php if ($this->rbac->hasPrivilege('inventory_requisitions', 'can_add')) { ?>
                                <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#addRequisitionModal">
                                    <i class="fa fa-plus"></i> Create Requisition
                                </button>
                            <?php } ?>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered table-hover" id="requisitionsTable">
                                <thead>
                                    <tr>
                                        <th>Requisition #</th>
                                        <th>Request Date</th>
                                        <th>Requested By</th>
                                        <th>Department</th>
                                        <th>Required Date</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($requisitions as $requisition) { ?>
                                        <tr>
                                            <td><strong><?php echo $requisition->requisition_number; ?></strong></td>
                                            <td><?php echo date('d-m-Y', strtotime($requisition->request_date)); ?></td>
                                            <td><?php echo $requisition->requested_by_name; ?></td>
                                            <td><?php echo $requisition->department ?: 'N/A'; ?></td>
                                            <td><?php echo $requisition->required_date ? date('d-m-Y', strtotime($requisition->required_date)) : 'N/A'; ?></td>
                                            <td>
                                                <?php
                                                $class = '';
                                                switch ($requisition->status) {
                                                    case 'PENDING':
                                                        $class = 'label-warning';
                                                        break;
                                                    case 'APPROVED':
                                                        $class = 'label-info';
                                                        break;
                                                    case 'ISSUED':
                                                        $class = 'label-success';
                                                        break;
                                                    case 'REJECTED':
                                                        $class = 'label-danger';
                                                        break;
                                                    case 'CANCELLED':
                                                        $class = 'label-default';
                                                        break;
                                                }
                                                ?>
                                                <span class="label <?php echo $class; ?>"><?php echo $requisition->status; ?></span>
                                            </td>
                                            <td>
                                                <div class="btn-group">
                                                    <button type="button" class="btn btn-info btn-xs" onclick="viewRequisition(<?php echo $requisition->id; ?>)" title="View Details">
                                                        <i class="fa fa-eye"></i>
                                                    </button>
                                                    <?php if ($requisition->status == 'PENDING' && $this->rbac->hasPrivilege('inventory_requisitions', 'can_edit')) { ?>
                                                        <button type="button" class="btn btn-success btn-xs" onclick="approveRequisition(<?php echo $requisition->id; ?>)" title="Approve">
                                                            <i class="fa fa-check"></i>
                                                        </button>
                                                        <button type="button" class="btn btn-danger btn-xs" onclick="rejectRequisition(<?php echo $requisition->id; ?>)" title="Reject">
                                                            <i class="fa fa-times"></i>
                                                        </button>
                                                    <?php } ?>
                                                    <?php if ($requisition->status == 'APPROVED' && $this->rbac->hasPrivilege('inventory_requisitions', 'can_edit')) { ?>
                                                        <button type="button" class="btn btn-primary btn-xs" onclick="issueRequisition(<?php echo $requisition->id; ?>)" title="Issue Items">
                                                            <i class="fa fa-share"></i>
                                                        </button>
                                                    <?php } ?>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Add Requisition Modal -->
<div class="modal fade" id="addRequisitionModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title"><i class="fa fa-plus"></i> Create New Requisition</h4>
            </div>
            <form id="addRequisitionForm">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="requisition_number">Requisition Number</label>
                                <input type="text" class="form-control" id="requisition_number" name="requisition_number" readonly>
                                <button type="button" class="btn btn-xs btn-default" onclick="generateRequisitionNumber()">
                                    <i class="fa fa-refresh"></i> Generate
                                </button>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="department">Department</label>
                                <input type="text" class="form-control" id="department" name="department">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="request_date">Request Date <span class="text-danger">*</span></label>
                                <input type="date" class="form-control" id="request_date" name="request_date" value="<?php echo date('Y-m-d'); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="required_date">Required Date</label>
                                <input type="date" class="form-control" id="required_date" name="required_date">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="notes">Notes</label>
                        <textarea class="form-control" id="notes" name="notes" rows="3"></textarea>
                    </div>
                    
                    <!-- Items Section -->
                    <div class="form-group">
                        <label>Requested Items</label>
                        <div class="table-responsive">
                            <table class="table table-bordered" id="requisitionItemsTable">
                                <thead>
                                    <tr>
                                        <th>Item</th>
                                        <th>Quantity Requested</th>
                                        <th>Notes</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody id="requisitionItemsBody">
                                    <tr>
                                        <td>
                                            <select class="form-control item-select" name="items[0][item_id]" required>
                                                <option value="">Select Item</option>
                                                <!-- Items will be loaded via AJAX -->
                                            </select>
                                        </td>
                                        <td>
                                            <input type="number" class="form-control" name="items[0][quantity_requested]" min="1" required>
                                        </td>
                                        <td>
                                            <input type="text" class="form-control" name="items[0][notes]">
                                        </td>
                                        <td>
                                            <button type="button" class="btn btn-danger btn-xs" onclick="removeRequisitionItem(this)">
                                                <i class="fa fa-trash"></i>
                                            </button>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <button type="button" class="btn btn-success btn-sm" onclick="addRequisitionItem()">
                            <i class="fa fa-plus"></i> Add Item
                        </button>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Create Requisition</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
var itemsData = [];
var requisitionItemIndex = 1;

$(document).ready(function() {
    // Initialize DataTable
    $('#requisitionsTable').DataTable({
        "paging": true,
        "lengthChange": true,
        "searching": true,
        "ordering": true,
        "info": true,
        "autoWidth": false,
        "responsive": true,
        "order": [[1, "desc"]]
    });

    // Load items data
    loadItemsData();
    
    // Generate initial requisition number
    generateRequisitionNumber();

    // Add Requisition Form Submit
    $('#addRequisitionForm').on('submit', function(e) {
        e.preventDefault();
        
        // Validate that at least one item is added
        var itemCount = $('#requisitionItemsBody tr').length;
        if (itemCount === 0) {
            alert('Please add at least one item to the requisition.');
            return;
        }
        
        $.ajax({
            url: '<?php echo base_url("admin/inventory/add_requisition"); ?>',
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    $('#addRequisitionModal').modal('hide');
                    location.reload();
                } else {
                    alert('Error: ' + response.error);
                }
            },
            error: function() {
                alert('An error occurred while creating the requisition.');
            }
        });
    });
});

function loadItemsData() {
    $.ajax({
        url: '<?php echo base_url("admin/inventory/get_items_list"); ?>',
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            itemsData = data;
            populateItemSelects();
        },
        error: function() {
            console.error('Failed to load items data');
        }
    });
}

function populateItemSelects() {
    $('.item-select').each(function() {
        var select = $(this);
        select.empty().append('<option value="">Select Item</option>');
        
        itemsData.forEach(function(item) {
            select.append('<option value="' + item.id + '">' + item.name + ' (' + item.item_code + ') - Stock: ' + item.current_stock + '</option>');
        });
    });
}

function generateRequisitionNumber() {
    $.ajax({
        url: '<?php echo base_url("admin/inventory/generate_requisition_number"); ?>',
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.requisition_number) {
                $('#requisition_number').val(response.requisition_number);
            }
        },
        error: function() {
            console.error('Failed to generate requisition number');
        }
    });
}

function addRequisitionItem() {
    var newRow = '<tr>';
    newRow += '<td>';
    newRow += '<select class="form-control item-select" name="items[' + requisitionItemIndex + '][item_id]" required>';
    newRow += '<option value="">Select Item</option>';
    
    itemsData.forEach(function(item) {
        newRow += '<option value="' + item.id + '">' + item.name + ' (' + item.item_code + ') - Stock: ' + item.current_stock + '</option>';
    });
    
    newRow += '</select>';
    newRow += '</td>';
    newRow += '<td><input type="number" class="form-control" name="items[' + requisitionItemIndex + '][quantity_requested]" min="1" required></td>';
    newRow += '<td><input type="text" class="form-control" name="items[' + requisitionItemIndex + '][notes]"></td>';
    newRow += '<td><button type="button" class="btn btn-danger btn-xs" onclick="removeRequisitionItem(this)"><i class="fa fa-trash"></i></button></td>';
    newRow += '</tr>';
    
    $('#requisitionItemsBody').append(newRow);
    requisitionItemIndex++;
}

function removeRequisitionItem(button) {
    $(button).closest('tr').remove();
}

function viewRequisition(id) {
    window.open('<?php echo base_url("admin/inventory/view_requisition/"); ?>' + id, '_blank');
}

function approveRequisition(id) {
    if (confirm('Are you sure you want to approve this requisition?')) {
        $.ajax({
            url: '<?php echo base_url("admin/inventory/approve_requisition/"); ?>' + id,
            type: 'POST',
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    location.reload();
                } else {
                    alert('Error: ' + response.error);
                }
            },
            error: function() {
                alert('An error occurred while approving the requisition.');
            }
        });
    }
}

function rejectRequisition(id) {
    var reason = prompt('Please enter the reason for rejection:');
    if (reason !== null && reason.trim() !== '') {
        $.ajax({
            url: '<?php echo base_url("admin/inventory/reject_requisition/"); ?>' + id,
            type: 'POST',
            data: { reason: reason },
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    location.reload();
                } else {
                    alert('Error: ' + response.error);
                }
            },
            error: function() {
                alert('An error occurred while rejecting the requisition.');
            }
        });
    }
}

function issueRequisition(id) {
    if (confirm('Are you sure you want to issue items for this requisition?')) {
        $.ajax({
            url: '<?php echo base_url("admin/inventory/issue_requisition/"); ?>' + id,
            type: 'POST',
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    location.reload();
                } else {
                    alert('Error: ' + response.error);
                }
            },
            error: function() {
                alert('An error occurred while issuing the requisition.');
            }
        });
    }
}
</script>
