<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-bar-chart"></i> Inventory Reports
            <small>Generate comprehensive inventory reports</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="<?php echo base_url(); ?>admin/inventory"><i class="fa fa-cubes"></i> Inventory</a></li>
            <li class="active">Reports</li>
        </ol>
    </section>

    <section class="content">
        <!-- Report Selection Cards -->
        <div class="row">
            <div class="col-lg-3 col-md-6">
                <div class="info-box bg-aqua">
                    <span class="info-box-icon"><i class="fa fa-cubes"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Stock Report</span>
                        <span class="info-box-number">Current Inventory</span>
                        <div class="progress">
                            <div class="progress-bar" style="width: 100%"></div>
                        </div>
                        <span class="progress-description">
                            <button class="btn btn-xs btn-default" onclick="generateStockReport()">
                                <i class="fa fa-file-excel-o"></i> Generate
                            </button>
                        </span>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-6">
                <div class="info-box bg-green">
                    <span class="info-box-icon"><i class="fa fa-exchange"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Movement Report</span>
                        <span class="info-box-number">Stock Transactions</span>
                        <div class="progress">
                            <div class="progress-bar" style="width: 100%"></div>
                        </div>
                        <span class="progress-description">
                            <button class="btn btn-xs btn-default" onclick="showMovementReportModal()">
                                <i class="fa fa-file-excel-o"></i> Generate
                            </button>
                        </span>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-6">
                <div class="info-box bg-yellow">
                    <span class="info-box-icon"><i class="fa fa-dollar"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Valuation Report</span>
                        <span class="info-box-number">Stock Value</span>
                        <div class="progress">
                            <div class="progress-bar" style="width: 100%"></div>
                        </div>
                        <span class="progress-description">
                            <button class="btn btn-xs btn-default" onclick="generateValuationReport()">
                                <i class="fa fa-file-excel-o"></i> Generate
                            </button>
                        </span>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-6">
                <div class="info-box bg-red">
                    <span class="info-box-icon"><i class="fa fa-exclamation-triangle"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Low Stock Report</span>
                        <span class="info-box-number">Alert Items</span>
                        <div class="progress">
                            <div class="progress-bar" style="width: 100%"></div>
                        </div>
                        <span class="progress-description">
                            <button class="btn btn-xs btn-default" onclick="generateLowStockReport()">
                                <i class="fa fa-file-excel-o"></i> Generate
                            </button>
                        </span>
                    </div>
                </div>
            </div>

        </div>

        <!-- Report Display Area -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-table"></i> Report Results</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-success btn-sm" id="exportExcelBtn" style="display: none;">
                                <i class="fa fa-file-excel-o"></i> Export to Excel
                            </button>
                            <button type="button" class="btn btn-info btn-sm" id="printReportBtn" style="display: none;">
                                <i class="fa fa-print"></i> Print Report
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <div id="reportContent">
                            <div class="text-center text-muted" style="padding: 50px;">
                                <i class="fa fa-bar-chart fa-3x"></i>
                                <p style="margin-top: 20px;">Select a report type above to generate and view results</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Stats Row -->
        <div class="row">
            <div class="col-md-6">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title">Quick Statistics</h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="description-block border-right">
                                    <span class="description-percentage text-green">
                                        <i class="fa fa-caret-up"></i> 
                                        <span id="totalItemsCount">Loading...</span>
                                    </span>
                                    <h5 class="description-header">Total Items</h5>
                                    <span class="description-text">INVENTORY</span>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="description-block">
                                    <span class="description-percentage text-yellow">
                                        <i class="fa fa-caret-left"></i> 
                                        <span id="lowStockCount">Loading...</span>
                                    </span>
                                    <h5 class="description-header">Low Stock</h5>
                                    <span class="description-text">ALERTS</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title">Stock Value Summary</h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="description-block">
                                    <span class="description-percentage text-green">
                                        <i class="fa fa-rupee"></i>
                                    </span>
                                    <h5 class="description-header" id="totalStockValue">Loading...</h5>
                                    <span class="description-text">TOTAL INVENTORY VALUE</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Movement Report Modal -->
<div class="modal fade" id="movementReportModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title"><i class="fa fa-exchange"></i> Movement Report Parameters</h4>
            </div>
            <form id="movementReportForm">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="date_from">From Date <span class="text-danger">*</span></label>
                                <input type="date" class="form-control" id="date_from" name="date_from" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="date_to">To Date <span class="text-danger">*</span></label>
                                <input type="date" class="form-control" id="date_to" name="date_to" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="movement_type_filter">Movement Type</label>
                                <select class="form-control" id="movement_type_filter" name="movement_type">
                                    <option value="">All Types</option>
                                    <option value="IN">Stock In</option>
                                    <option value="OUT">Stock Out</option>
                                    <option value="ADJUSTMENT">Adjustment</option>
                                    <option value="TRANSFER">Transfer</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="item_filter">Item (Optional)</label>
                                <select class="form-control" id="item_filter" name="item_id">
                                    <option value="">All Items</option>
                                    <!-- Items will be loaded via AJAX -->
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Generate Report</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Load quick statistics
    loadQuickStats();
    
    // Set default dates for movement report
    var today = new Date();
    var lastMonth = new Date(today.getFullYear(), today.getMonth() - 1, today.getDate());
    
    $('#date_from').val(lastMonth.toISOString().split('T')[0]);
    $('#date_to').val(today.toISOString().split('T')[0]);

    // Movement Report Form Submit
    $('#movementReportForm').on('submit', function(e) {
        e.preventDefault();
        generateMovementReport();
    });

    // Export and Print handlers
    $('#exportExcelBtn').on('click', function() {
        exportToExcel();
    });

    $('#printReportBtn').on('click', function() {
        printReport();
    });
});

function loadQuickStats() {
    $.ajax({
        url: '<?php echo base_url("admin/inventory/get_quick_stats"); ?>',
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            $('#totalItemsCount').text(data.total_items || 0);
            $('#lowStockCount').text(data.low_stock_count || 0);
            $('#totalStockValue').text('Rs ' + (data.total_stock_value || 0).toLocaleString());
        },
        error: function() {
            $('#totalItemsCount').text('Error');
            $('#lowStockCount').text('Error');
            $('#totalStockValue').text('Error');
        }
    });
}

function generateStockReport() {
    showLoading();
    
    $.ajax({
        url: '<?php echo base_url("admin/inventory/generate_stock_report"); ?>',
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            displayStockReport(data);
            showExportButtons();
        },
        error: function() {
            showError('Failed to generate stock report');
        }
    });
}

function showMovementReportModal() {
    // Load items for filter
    $.ajax({
        url: '<?php echo base_url("admin/inventory/get_items_list"); ?>',
        type: 'GET',
        dataType: 'json',
        success: function(items) {
            var select = $('#item_filter');
            select.empty().append('<option value="">All Items</option>');
            
            items.forEach(function(item) {
                select.append('<option value="' + item.id + '">' + item.name + ' (' + item.item_code + ')</option>');
            });
        }
    });
    
    $('#movementReportModal').modal('show');
}

function generateMovementReport() {
    var formData = $('#movementReportForm').serialize();
    showLoading();
    
    $.ajax({
        url: '<?php echo base_url("admin/inventory/generate_movement_report"); ?>',
        type: 'POST',
        data: formData,
        dataType: 'json',
        success: function(data) {
            displayMovementReport(data);
            showExportButtons();
            $('#movementReportModal').modal('hide');
        },
        error: function() {
            showError('Failed to generate movement report');
        }
    });
}

function generateValuationReport() {
    showLoading();
    
    $.ajax({
        url: '<?php echo base_url("admin/inventory/generate_valuation_report"); ?>',
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            displayValuationReport(data);
            showExportButtons();
        },
        error: function() {
            showError('Failed to generate valuation report');
        }
    });
}

function generateLowStockReport() {
    showLoading();
    
    $.ajax({
        url: '<?php echo base_url("admin/inventory/generate_low_stock_report"); ?>',
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            displayLowStockReport(data);
            showExportButtons();
        },
        error: function() {
            showError('Failed to generate low stock report');
        }
    });
}

function displayStockReport(data) {
    var html = '<div class="report-header">';
    html += '<h3><i class="fa fa-cubes"></i> Current Stock Report</h3>';
    html += '<p class="text-muted">Generated on: ' + new Date().toLocaleDateString() + '</p>';
    html += '</div>';
    
    html += '<div class="table-responsive">';
    html += '<table class="table table-striped table-bordered" id="reportTable">';
    html += '<thead><tr>';
    html += '<th>Item Code</th><th>Item Name</th><th>Category</th>';
    html += '<th>Current Stock</th><th>Min Stock</th><th>Unit Price</th><th>Total Value</th>';
    html += '</tr></thead><tbody>';
    
    data.forEach(function(item) {
        var totalValue = item.current_stock * item.purchase_price;
        html += '<tr>';
        html += '<td>' + item.item_code + '</td>';
        html += '<td>' + item.name + '</td>';
        html += '<td>' + (item.category_name || 'N/A') + '</td>';
        html += '<td>' + item.current_stock + '</td>';
        html += '<td>' + item.minimum_stock + '</td>';
        html += '<td>Rs ' + parseFloat(item.purchase_price).toFixed(2) + '</td>';
        html += '<td>Rs ' + totalValue.toFixed(2) + '</td>';
        html += '</tr>';
    });
    
    html += '</tbody></table></div>';
    
    $('#reportContent').html(html);
    $('#reportTable').DataTable({
        "paging": true,
        "searching": true,
        "ordering": true
    });
}

function displayMovementReport(data) {
    var html = '<div class="report-header">';
    html += '<h3><i class="fa fa-exchange"></i> Stock Movement Report</h3>';
    html += '<p class="text-muted">Generated on: ' + new Date().toLocaleDateString() + '</p>';
    html += '</div>';
    
    html += '<div class="table-responsive">';
    html += '<table class="table table-striped table-bordered" id="reportTable">';
    html += '<thead><tr>';
    html += '<th>Date</th><th>Item</th><th>Type</th><th>Quantity</th>';
    html += '<th>Unit Price</th><th>Total Amount</th><th>Reference</th><th>Staff</th>';
    html += '</tr></thead><tbody>';
    
    data.forEach(function(movement) {
        html += '<tr>';
        html += '<td>' + new Date(movement.movement_date).toLocaleDateString() + '</td>';
        html += '<td>' + movement.item_name + ' (' + movement.item_code + ')</td>';
        html += '<td><span class="label label-' + getMovementTypeClass(movement.movement_type) + '">' + movement.movement_type + '</span></td>';
        html += '<td>' + movement.quantity + '</td>';
        html += '<td>Rs ' + parseFloat(movement.unit_price || 0).toFixed(2) + '</td>';
        html += '<td>Rs ' + parseFloat(movement.total_amount || 0).toFixed(2) + '</td>';
        html += '<td>' + (movement.reference_type || 'N/A') + '</td>';
        html += '<td>' + (movement.staff_name || 'System') + '</td>';
        html += '</tr>';
    });
    
    html += '</tbody></table></div>';
    
    $('#reportContent').html(html);
    $('#reportTable').DataTable({
        "paging": true,
        "searching": true,
        "ordering": true
    });
}

function displayValuationReport(data) {
    var html = '<div class="report-header">';
    html += '<h3><i class="fa fa-rupee"></i> Inventory Valuation Report</h3>';
    html += '<p class="text-muted">Generated on: ' + new Date().toLocaleDateString() + '</p>';
    html += '</div>';
    
    var totalValue = 0;
    
    html += '<div class="table-responsive">';
    html += '<table class="table table-striped table-bordered" id="reportTable">';
    html += '<thead><tr>';
    html += '<th>Item Code</th><th>Item Name</th><th>Category</th>';
    html += '<th>Current Stock</th><th>Unit Price</th><th>Total Value</th>';
    html += '</tr></thead><tbody>';
    
    data.forEach(function(item) {
        totalValue += parseFloat(item.total_value);
        html += '<tr>';
        html += '<td>' + item.item_code + '</td>';
        html += '<td>' + item.name + '</td>';
        html += '<td>' + (item.category_name || 'N/A') + '</td>';
        html += '<td>' + item.current_stock + '</td>';
        html += '<td>Rs ' + parseFloat(item.purchase_price).toFixed(2) + '</td>';
        html += '<td>Rs ' + parseFloat(item.total_value).toFixed(2) + '</td>';
        html += '</tr>';
    });
    
    html += '</tbody>';
    html += '<tfoot><tr class="bg-primary">';
    html += '<td colspan="5"><strong>Total Inventory Value</strong></td>';
    html += '<td><strong>Rs ' + totalValue.toFixed(2) + '</strong></td>';
    html += '</tr></tfoot>';
    html += '</table></div>';
    
    $('#reportContent').html(html);
    $('#reportTable').DataTable({
        "paging": true,
        "searching": true,
        "ordering": true
    });
}

function displayLowStockReport(data) {
    var html = '<div class="report-header">';
    html += '<h3><i class="fa fa-exclamation-triangle"></i> Low Stock Report</h3>';
    html += '<p class="text-muted">Generated on: ' + new Date().toLocaleDateString() + '</p>';
    html += '</div>';
    
    html += '<div class="table-responsive">';
    html += '<table class="table table-striped table-bordered" id="reportTable">';
    html += '<thead><tr>';
    html += '<th>Item Code</th><th>Item Name</th><th>Category</th>';
    html += '<th>Current Stock</th><th>Minimum Stock</th><th>Shortage</th><th>Status</th>';
    html += '</tr></thead><tbody>';
    
    data.forEach(function(item) {
        var shortage = item.minimum_stock - item.current_stock;
        var status = item.current_stock <= 0 ? 'Out of Stock' : 'Low Stock';
        var statusClass = item.current_stock <= 0 ? 'label-danger' : 'label-warning';
        
        html += '<tr>';
        html += '<td>' + item.item_code + '</td>';
        html += '<td>' + item.name + '</td>';
        html += '<td>' + (item.category_name || 'N/A') + '</td>';
        html += '<td>' + item.current_stock + '</td>';
        html += '<td>' + item.minimum_stock + '</td>';
        html += '<td>' + shortage + '</td>';
        html += '<td><span class="label ' + statusClass + '">' + status + '</span></td>';
        html += '</tr>';
    });
    
    html += '</tbody></table></div>';
    
    $('#reportContent').html(html);
    $('#reportTable').DataTable({
        "paging": true,
        "searching": true,
        "ordering": true
    });
}

function getMovementTypeClass(type) {
    switch(type) {
        case 'IN': return 'success';
        case 'OUT': return 'danger';
        case 'ADJUSTMENT': return 'warning';
        case 'TRANSFER': return 'info';
        default: return 'default';
    }
}

function showLoading() {
    $('#reportContent').html('<div class="text-center" style="padding: 50px;"><i class="fa fa-spinner fa-spin fa-3x"></i><p style="margin-top: 20px;">Generating report...</p></div>');
    hideExportButtons();
}

function showError(message) {
    $('#reportContent').html('<div class="text-center text-danger" style="padding: 50px;"><i class="fa fa-exclamation-triangle fa-3x"></i><p style="margin-top: 20px;">' + message + '</p></div>');
    hideExportButtons();
}

function showExportButtons() {
    $('#exportExcelBtn, #printReportBtn').show();
}

function hideExportButtons() {
    $('#exportExcelBtn, #printReportBtn').hide();
}

function exportToExcel() {
    // Simple CSV export
    var csv = [];
    var table = document.getElementById('reportTable');
    
    if (table) {
        var rows = table.querySelectorAll('tr');
        
        for (var i = 0; i < rows.length; i++) {
            var row = [], cols = rows[i].querySelectorAll('td, th');
            
            for (var j = 0; j < cols.length; j++) {
                var cellText = cols[j].innerText.replace(/"/g, '""');
                row.push('"' + cellText + '"');
            }
            
            csv.push(row.join(','));
        }
        
        var csvFile = new Blob([csv.join('\n')], {type: 'text/csv'});
        var downloadLink = document.createElement('a');
        downloadLink.download = 'inventory_report_' + new Date().toISOString().split('T')[0] + '.csv';
        downloadLink.href = window.URL.createObjectURL(csvFile);
        downloadLink.style.display = 'none';
        document.body.appendChild(downloadLink);
        downloadLink.click();
        document.body.removeChild(downloadLink);
    }
}

function printReport() {
    var printContent = document.getElementById('reportContent').innerHTML;
    var originalContent = document.body.innerHTML;
    
    document.body.innerHTML = '<html><head><title>Inventory Report</title></head><body>' + printContent + '</body></html>';
    window.print();
    document.body.innerHTML = originalContent;
    location.reload();
}
</script>

<style>
.report-header {
    margin-bottom: 20px;
    padding-bottom: 10px;
    border-bottom: 2px solid #f4f4f4;
}

.report-header h3 {
    margin: 0;
    color: #444;
}

.info-box {
    display: block;
    min-height: 90px;
    background: #fff;
    width: 100%;
    box-shadow: 0 1px 1px rgba(0,0,0,0.1);
    border-radius: 2px;
    margin-bottom: 15px;
}

.info-box-icon {
    border-top-left-radius: 2px;
    border-top-right-radius: 0;
    border-bottom-right-radius: 0;
    border-bottom-left-radius: 2px;
    display: block;
    float: left;
    height: 90px;
    width: 90px;
    text-align: center;
    font-size: 45px;
    line-height: 90px;
    background: rgba(0,0,0,0.2);
}

.info-box-content {
    padding: 5px 10px;
    margin-left: 90px;
}

.info-box-number {
    display: block;
    font-weight: bold;
    font-size: 18px;
}

.info-box-text {
    display: block;
    font-size: 14px;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

.bg-aqua {
    background-color: #00c0ef !important;
    color: #fff;
}

.bg-green {
    background-color: #00a65a !important;
    color: #fff;
}

.bg-yellow {
    background-color: #f39c12 !important;
    color: #fff;
}

.bg-red {
    background-color: #dd4b39 !important;
    color: #fff;
}

.description-block {
    display: block;
    margin: 10px 0;
    text-align: center;
}

.description-header {
    font-size: 16px;
    margin: 0 0 5px 0;
    padding: 0;
    font-weight: 600;
    color: #444;
}

.description-text {
    text-transform: uppercase;
    font-size: 13px;
}

.border-right {
    border-right: 1px solid #f4f4f4;
}

@media print {
    .box-tools, .btn, .modal, .sidebar, .main-header, .main-footer {
        display: none !important;
    }
    
    .content-wrapper {
        margin: 0 !important;
        padding: 0 !important;
    }
}
</style>
