<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-cubes"></i> <?php echo $this->lang->line('inventory_dashboard'); ?>
            <small><?php echo $this->lang->line('control_panel'); ?></small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> <?php echo $this->lang->line('dashboard'); ?></a></li>
            <li class="active"><?php echo $this->lang->line('inventory_dashboard'); ?></li>
        </ol>
    </section>

    <section class="content">
        <!-- Info boxes -->
        <div class="row">
            <div class="col-lg-3 col-xs-6">
                <div class="info-box">
                    <span class="info-box-icon bg-aqua"><i class="fa fa-cubes"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Total Items</span>
                        <span class="info-box-number"><?php echo $total_items; ?></span>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="info-box">
                    <span class="info-box-icon bg-green"><i class="fa fa-tags"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Categories</span>
                        <span class="info-box-number"><?php echo $total_categories; ?></span>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="info-box">
                    <span class="info-box-icon bg-yellow"><i class="fa fa-truck"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Suppliers</span>
                        <span class="info-box-number"><?php echo $total_suppliers; ?></span>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="info-box">
                    <span class="info-box-icon bg-red"><i class="fa fa-exclamation-triangle"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Low Stock Items</span>
                        <span class="info-box-number"><?php echo count($low_stock_items); ?></span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Stock Value and Alerts Row -->
        <div class="row">
            <div class="col-lg-6">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-dollar"></i> Stock Valuation</h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="info-box bg-light-blue">
                                    <span class="info-box-icon"><i class="fa fa-money"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Total Stock Value</span>
                                        <span class="info-box-number"><?php echo $sch_setting->currency_symbol . ' ' . number_format($total_stock_value, 2); ?></span>
                                        <div class="progress">
                                            <div class="progress-bar" style="width: 100%"></div>
                                        </div>
                                        <span class="progress-description">Current inventory valuation</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-6">
                <div class="box box-warning">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-bell"></i> Quick Stats</h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="description-block border-right">
                                    <span class="description-percentage text-yellow"><i class="fa fa-caret-left"></i> <?php echo $pending_requisitions; ?></span>
                                    <h5 class="description-header">Pending Requisitions</h5>
                                    <span class="description-text">REQUESTS</span>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="description-block">
                                    <span class="description-percentage text-red"><i class="fa fa-caret-up"></i> <?php echo $stock_alerts; ?></span>
                                    <h5 class="description-header">Active Alerts</h5>
                                    <span class="description-text">NOTIFICATIONS</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Low Stock Items and Recent Movements -->
        <div class="row">
            <div class="col-lg-6">
                <div class="box box-danger">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-exclamation-triangle"></i> Low Stock Items</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                        </div>
                    </div>
                    <div class="box-body">
                        <?php if (!empty($low_stock_items)) { ?>
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Item Code</th>
                                            <th>Item Name</th>
                                            <th>Current Stock</th>
                                            <th>Min Stock</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($low_stock_items as $item) { ?>
                                            <tr>
                                                <td><?php echo $item->item_code; ?></td>
                                                <td><?php echo $item->name; ?></td>
                                                <td><span class="label label-danger"><?php echo $item->current_stock; ?></span></td>
                                                <td><?php echo $item->minimum_stock; ?></td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php } else { ?>
                            <p class="text-muted">No low stock items found.</p>
                        <?php } ?>
                    </div>
                    <div class="box-footer">
                        <a href="<?php echo base_url('admin/inventory/alerts'); ?>" class="btn btn-sm btn-danger">View All Alerts</a>
                    </div>
                </div>
            </div>

            <div class="col-lg-6">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-history"></i> Recent Stock Movements</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                        </div>
                    </div>
                    <div class="box-body">
                        <?php if (!empty($recent_movements)) { ?>
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th>Item</th>
                                            <th>Type</th>
                                            <th>Qty</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($recent_movements as $movement) { ?>
                                            <tr>
                                                <td><?php echo date('M d', strtotime($movement->movement_date)); ?></td>
                                                <td><?php echo $movement->item_name; ?></td>
                                                <td>
                                                    <?php
                                                    $class = '';
                                                    switch ($movement->movement_type) {
                                                        case 'IN':
                                                            $class = 'label-success';
                                                            break;
                                                        case 'OUT':
                                                            $class = 'label-danger';
                                                            break;
                                                        case 'ADJUSTMENT':
                                                            $class = 'label-warning';
                                                            break;
                                                        case 'TRANSFER':
                                                            $class = 'label-info';
                                                            break;
                                                    }
                                                    ?>
                                                    <span class="label <?php echo $class; ?>"><?php echo $movement->movement_type; ?></span>
                                                </td>
                                                <td><?php echo $movement->quantity; ?></td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php } else { ?>
                            <p class="text-muted">No recent movements found.</p>
                        <?php } ?>
                    </div>
                    <div class="box-footer">
                        <a href="<?php echo base_url('admin/inventory/stock_movements'); ?>" class="btn btn-sm btn-info">View All Movements</a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="row">
            <div class="col-lg-12">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-bolt"></i> Quick Actions</h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-3">
                                <a href="<?php echo base_url('admin/inventory/items'); ?>" class="btn btn-app">
                                    <i class="fa fa-cubes"></i> Manage Items
                                </a>
                            </div>
                            <div class="col-md-3">
                                <a href="<?php echo base_url('admin/inventory/stock_movements'); ?>" class="btn btn-app">
                                    <i class="fa fa-exchange"></i> Stock Movement
                                </a>
                            </div>
                            <div class="col-md-3">
                                <a href="<?php echo base_url('admin/inventory/requisitions'); ?>" class="btn btn-app">
                                    <i class="fa fa-file-text"></i> Requisitions
                                </a>
                            </div>
                            <div class="col-md-3">
                                <a href="<?php echo base_url('admin/inventory/reports'); ?>" class="btn btn-app">
                                    <i class="fa fa-bar-chart"></i> Reports
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<style>
.info-box {
    display: block;
    min-height: 90px;
    background: #fff;
    width: 100%;
    box-shadow: 0 1px 1px rgba(0,0,0,0.1);
    border-radius: 2px;
    margin-bottom: 15px;
}

.info-box-icon {
    border-top-left-radius: 2px;
    border-top-right-radius: 0;
    border-bottom-right-radius: 0;
    border-bottom-left-radius: 2px;
    display: block;
    float: left;
    height: 90px;
    width: 90px;
    text-align: center;
    font-size: 45px;
    line-height: 90px;
    background: rgba(0,0,0,0.2);
}

.info-box-content {
    padding: 5px 10px;
    margin-left: 90px;
}

.info-box-number {
    display: block;
    font-weight: bold;
    font-size: 18px;
}

.info-box-text {
    display: block;
    font-size: 14px;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

.bg-aqua {
    background-color: #00c0ef !important;
}

.bg-green {
    background-color: #00a65a !important;
}

.bg-yellow {
    background-color: #f39c12 !important;
}

.bg-red {
    background-color: #dd4b39 !important;
}

.bg-light-blue {
    background-color: #3c8dbc !important;
    color: #fff;
}

.description-block {
    display: block;
    margin: 10px 0;
    text-align: center;
}

.description-header {
    font-size: 16px;
    margin: 0 0 5px 0;
    padding: 0;
    font-weight: 600;
    color: #444;
}

.description-text {
    text-transform: uppercase;
    font-size: 13px;
}

.border-right {
    border-right: 1px solid #f4f4f4;
}

.btn-app {
    border-radius: 3px;
    position: relative;
    padding: 15px 5px;
    margin: 0 0 10px 10px;
    min-width: 80px;
    height: 60px;
    text-align: center;
    color: #666;
    border: 1px solid #ddd;
    background-color: #f4f4f4;
    font-size: 12px;
}

.btn-app:hover {
    background: #f4f4f4;
    color: #444;
    border-color: #aaa;
}

.btn-app > .fa {
    font-size: 20px;
    display: block;
}
</style>
