<?php
$currency_symbol = $this->customlib->getSchoolCurrencyFormat();
?>
<div class="content-wrapper">
    <section class="content-header">
        <h1><i class="fa fa-id-card"></i> <?php echo $this->lang->line('student_id_card'); ?></h1>
    </section>
    <!-- Main content -->
    <section class="content">
        <?php if ($this->session->flashdata('msg')) {?>
            <?php 
                echo $this->session->flashdata('msg');
                $this->session->unset_userdata('msg');
            ?>
        <?php }?>
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-search"></i> <?php echo $this->lang->line('select_criteria'); ?></h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <form role="form" action="<?php echo site_url('admin/idcardgenerate/search') ?>" method="post" id="searchForm">
                                <?php echo $this->customlib->getCSRF(); ?>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label><?php echo $this->lang->line('class'); ?></label><small class="req"> *</small>
                                        <select autofocus="" id="class_id" name="class_id" class="form-control" required>
                                            <option value=""><?php echo $this->lang->line('select'); ?></option>
                                            <?php
                                            foreach ($classlist as $class) {
                                                ?>
                                                <option value="<?php echo $class['id'] ?>" <?php if (set_value('class_id') == $class['id']) {
                                                    echo "selected=selected";
                                                } else if (isset($class_id) && $class_id == $class['id']) {
                                                    echo "selected=selected";
                                                } ?>><?php echo $class['class'] ?></option>
                                                <?php
                                            }
                                            ?>
                                        </select>
                                        <span class="text-danger"><?php echo form_error('class_id'); ?></span>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label><?php echo $this->lang->line('section'); ?></label>
                                        <select id="section_id" name="section_id" class="form-control">
                                            <option value=""><?php echo $this->lang->line('select'); ?></option>
                                            <?php
                                            if (isset($section_id) && $section_id != '') {
                                                echo getSectionByClasses($classlist, $class_id, $section_id);
                                            }
                                            ?>
                                        </select>
                                        <span class="text-danger"><?php echo form_error('section_id'); ?></span>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label><?php echo $this->lang->line('id_card'); ?></label><small class="req"> *</small>
                                        <select name="idcard_id" id="idcard_id" class="form-control" required>
                                            <option value=""><?php echo $this->lang->line('select'); ?></option>
                                            <?php
                                            if (isset($idcardlist)) {
                                                foreach ($idcardlist as $list) {
                                                    ?>
                                                    <option value="<?php echo $list->id ?>" <?php if (isset($idcard_id) && $idcard_id == $list->id) {
                                                        echo "selected=selected";
                                                    } ?>><?php echo $list->idcard_name ?></option>
                                                    <?php
                                                }
                                            }
                                            ?>
                                        </select>
                                        <span class="text-danger"><?php echo form_error('idcard_id'); ?></span>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <button type="submit" name="search" value="search_filter" class="btn btn-primary btn-sm pull-right checkbox-toggle" id="searchButton"><i class="fa fa-search"></i> <?php echo $this->lang->line('search'); ?></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <?php
                    if (isset($resultlist)) {
                        ?>
                        <div id="student-list-container">
                            <div class="" id="duefee">
                                <div class="box-header ptbnull"></div>
                                <div class="box-header ptbnull">
                                    <h3 class="box-title titlefix"><i class="fa fa-users"></i> <?php echo $this->lang->line('student_list'); ?></h3>
                                    <a href="javascript:void(0)" onclick="submitSelectedStudents()" class="btn btn-info btn-sm pull-right" title="generate multiple ID cards"><?php echo $this->lang->line('generate'); ?></a>
                                </div>
                                <div class="box-body table-responsive overflow-visible">
                                    <div class="download_label"><?php echo $this->lang->line('student_list'); ?></div>
                                    <div class="tab-pane active table-responsive no-padding" id="tab_1">
                                        <div class="row">
                                            <div class="col-md-12 text-right" style="margin-bottom: 10px;">
                                                <button type="button" class="btn btn-primary" onclick="return submitSelectedStudents();">
                                                     <i class="fa fa-id-card"></i> <?php echo $this->lang->line('generate_selected'); ?>
                                                 </button>
                                            </div>
                                        </div>
                                        <table class="table table-striped table-bordered table-hover example" cellspacing="0" width="100%">
                                            <thead>
                                                <tr>
                                                    <th><input type="checkbox" id="select_all" /></th>
                                                    <th><?php echo $this->lang->line('admission_no'); ?></th>
                                                    <th><?php echo $this->lang->line('student_name'); ?></th>
                                                    <th><?php echo $this->lang->line('class'); ?></th>
                                                    <th><?php echo $this->lang->line('father_name'); ?></th>
                                                    <th><?php echo $this->lang->line('date_of_birth'); ?></th>
                                                    <th><?php echo $this->lang->line('gender'); ?></th>
                                                    <th><?php echo $this->lang->line('category'); ?></th>
                                                    <th class=""><?php echo $this->lang->line('mobile_number'); ?></th>
                                                    <th class="text-right"><?php echo $this->lang->line('generate_id_card'); ?></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                if (empty($resultlist)) {
                                                    ?>

                                                    <?php
                                                } else {
                                                    $count = 1;
                                                    foreach ($resultlist as $student) {
                                                        ?>
                                                        <tr>
                                                            <td class="text-center"><input type="checkbox" class="checkbox center-block" name="check[]" data-student_id="<?php echo $student->id ?>" value="<?php echo $student->id ?>">
                                                                <input type="hidden" name="class_id" value="<?php echo isset($student->class_id) ? $student->class_id : $class_id ?>">
                                                                <input type="hidden" name="idcard_id" value="<?php echo $idcardResult[0]->id ?>" id="idcard_id">
                                                            </td>
                                                            <td><?php echo $student->admission_no; ?></td>
                                                            <td>
                                                                <a href="<?php echo base_url(); ?>student/view/<?php echo $student->id; ?>"><?php echo $this->customlib->getFullName($student->firstname, $student->middlename, $student->lastname, $sch_setting->middlename, $sch_setting->lastname); ?>
                                                                </a>
                                                            </td>
                                                            <td><?php echo $student->class . (isset($student->section) ? "(" . $student->section . ")" : "") ?></td>
                                                            <td><?php echo $student->father_name; ?></td>
                                                            <td><?php echo $student->dob; ?></td>
                                                            <td><?php echo $this->lang->line(strtolower($student->gender)); ?></td>
                                                            <td><?php echo $student->category; ?></td>
                                                            <td><?php echo $student->mobileno; ?></td>
                                                            <td class="text-right">
                                                                <a href="javascript:void(0);" class="btn btn-danger btn-sm generate-single-idcard" data-student-id="<?php echo $student->id ?>" data-idcard-id="<?php echo $idcard_id ?>" onclick="return generateSingleIdCard(<?php echo $student->id ?>, <?php echo $idcard_id ?>);">
                                                                    <i class="fa fa-id-card"></i> <?php echo $this->lang->line('generate'); ?>
                                                                </a>
                                                                <br>
                                                                <!-- Direct link fallback -->
                                                                <a href="<?php echo site_url("admin/idcardgenerate/generate/{$student->id}/{$idcard_id}"); ?>" target="_blank" class="btn btn-info btn-xs" style="margin-top: 5px;">
                                                                    <i class="fa fa-external-link"></i> Direct Link
                                                                </a>
                                                            </td>
                                                        </tr>
                                                        <?php
                                                        $count++;
                                                    }
                                                }
                                                ?>
                                            </tbody>
                                        </table>
                                        <div class="row">
                                            <div class="col-md-12 text-right" style="margin-top: 10px;">
                                                <button type="button" class="btn btn-primary" onclick="return submitSelectedStudents();">
                                                     <i class="fa fa-id-card"></i> <?php echo $this->lang->line('generate_selected'); ?>
                                                 </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php
                    }
                    ?>
                </div>
            </div>
        </div>
    </section>
</div>
<script type="text/javascript">
    function getSectionByClass(class_id, section_id) {
        if (class_id != "" && section_id != "") {
            $('#section_id').html("");
            var base_url = '<?php echo base_url() ?>';
            var div_data = '<option value=""><?php echo $this->lang->line('select'); ?></option>';
            $.ajax({
                type: "GET",
                url: base_url + "sections/getByClass",
                data: {'class_id': class_id},
                dataType: "json",
                success: function (data) {
                    $.each(data, function (i, obj)
                    {
                        var sel = "";
                        if (section_id == obj.section_id) {
                            sel = "selected";
                        }
                        div_data += "<option value=" + obj.section_id + " " + sel + ">" + obj.section + "</option>";
                    });
                    $('#section_id').append(div_data);
                }
            });
        }
    }
    
    // Function to submit selected students and open ID card in new window
    function submitSelectedStudents() {
        var selectedStudents = [];
        var classId = '<?php echo isset($class_id) ? $class_id : ""; ?>';
        var idcardId = '<?php echo isset($idcard_id) ? $idcard_id : ""; ?>';
        
        console.log('Submit Selected Students function called');
        console.log('Class ID:', classId);
        console.log('ID Card ID:', idcardId);
        
        // Get all checked students
        $("input[name='check[]']:checked").each(function() {
            selectedStudents.push($(this).val());
        });
        
        console.log('Selected Students:', selectedStudents);
        
        if (selectedStudents.length === 0) {
            alert('<?php echo $this->lang->line("please_select_student"); ?>');
            return false;
        }
        
        // Create a form dynamically
        var form = document.createElement('form');
        form.setAttribute('method', 'post');
        form.setAttribute('action', '<?php echo site_url("admin/idcardgenerate/generatemultiple") ?>');
        form.setAttribute('target', '_blank'); // Open in new tab/window
        
        // Add CSRF token
        var csrfInput = document.createElement('input');
        csrfInput.setAttribute('type', 'hidden');
        csrfInput.setAttribute('name', '<?php echo $this->security->get_csrf_token_name(); ?>');
        csrfInput.setAttribute('value', '<?php echo $this->security->get_csrf_hash(); ?>');
        form.appendChild(csrfInput);
        
        // Add class_id
        var classInput = document.createElement('input');
        classInput.setAttribute('type', 'hidden');
        classInput.setAttribute('name', 'class_id');
        classInput.setAttribute('value', classId);
        form.appendChild(classInput);
        
        // Add idcard_id
        var idcardInput = document.createElement('input');
        idcardInput.setAttribute('type', 'hidden');
        idcardInput.setAttribute('name', 'idcard_id');
        idcardInput.setAttribute('value', idcardId);
        form.appendChild(idcardInput);
        
        // Add selected students
        for (var i = 0; i < selectedStudents.length; i++) {
            var studentInput = document.createElement('input');
            studentInput.setAttribute('type', 'hidden');
            studentInput.setAttribute('name', 'student_ids[]');
            studentInput.setAttribute('value', selectedStudents[i]);
            form.appendChild(studentInput);
        }
        
        // Submit the form
        document.body.appendChild(form);
        console.log('Form created and about to submit');
        form.submit();
        document.body.removeChild(form);
        
        return true;
    }
    
    // Function to generate multiple ID cards (old method - not used)
    function generateMultipleIdCards() {
        var array_to_print = [];
        var classId = $("input[name='class_id']").val();
        var idcardId = $("input[name='idcard_id']").val();
        
        console.log('Generating multiple ID cards');
        console.log('Class ID:', classId);
        console.log('ID Card ID:', idcardId);
        
        // Show loading indicator
        var $button = $('.printSelected');
        var originalButtonText = $button.html();
        $button.html('<i class="fa fa-spinner fa-spin"></i> ' + originalButtonText);
        $button.prop('disabled', true);
        
        // Get all checked students
        $.each($("input[name='check[]']:checked"), function () {
            array_to_print.push($(this).val());
        });
        
        if (array_to_print.length == 0) {
            alert("<?php echo $this->lang->line('no_student_selected'); ?>");
            // Reset button
            $button.html(originalButtonText);
            $button.prop('disabled', false);
            return;
        }
        
        // Make AJAX request
        $.ajax({
            url: '<?php echo site_url("admin/idcardgenerate/generatemultiple") ?>',
            type: 'post',
            data: {
                'check': array_to_print,
                'class_id': classId,
                'idcard_id': idcardId
            },
            success: function (response) {
                // Reset button
                $button.html(originalButtonText);
                $button.prop('disabled', false);
                
                if (response.trim() === '') {
                    console.error('Empty response received');
                    alert('Error: Empty response received from server');
                    return;
                }
                
                try {
                    Popup(response);
                } catch (e) {
                    console.error('Error in Popup function:', e);
                    alert('Error displaying ID cards: ' + e.message);
                }
            },
            error: function(xhr, status, error) {
                // Reset button
                $button.html(originalButtonText);
                $button.prop('disabled', false);
                
                console.error('AJAX Error:', status, error);
                alert('Error generating ID cards. Please check console for details.');
            }
        });
    }
    
    // Function to generate a single ID card
    function generateSingleIdCard(studentId, idcardId) {
        console.log('Generating single ID card for student:', studentId, 'with template:', idcardId);
        
        if (!studentId || !idcardId) {
            console.error('Missing student ID or ID card template ID');
            alert('Error: Missing student ID or ID card template ID');
            return;
        }
        
        // Show loading indicator
        var button = $('.generate-single-idcard[data-student-id="' + studentId + '"]');
        button.html('<i class="fa fa-spinner fa-spin"></i>');
        
        $.ajax({
            url: '<?php echo site_url("admin/idcardgenerate/generate") ?>/' + studentId + '/' + idcardId,
            type: 'get',
            success: function(response) {
                // Reset button
                button.html('<i class="fa fa-id-card"></i>');
                
                if (response.trim() === '') {
                    console.error('Empty response received');
                    alert('Error: Empty response received from server');
                    return;
                }
                
                try {
                    Popup(response);
                } catch (e) {
                    console.error('Error in Popup function:', e);
                    alert('Error displaying ID card: ' + e.message);
                }
            },
            error: function(xhr, status, error) {
                // Reset button
                button.html('<i class="fa fa-id-card"></i>');
                console.error('AJAX Error:', status, error);
                alert('Error generating ID card. Please check console for details.');
            }
        });
    }
    
    $(document).ready(function () {
        var class_id = $('#class_id').val();
        var section_id = '<?php echo isset($section_id) ? $section_id : "" ?>';
        getSectionByClass(class_id, section_id);
        
        $(document).on('change', '#class_id', function (e) {
            $('#section_id').html("");
            var class_id = $(this).val();
            var base_url = '<?php echo base_url() ?>';
            var div_data = '<option value=""><?php echo $this->lang->line('select'); ?></option>';
            $.ajax({
                type: "GET",
                url: base_url + "sections/getByClass",
                data: {'class_id': class_id},
                dataType: "json",
                success: function (data) {
                    $.each(data, function (i, obj)
                    {
                        div_data += "<option value=" + obj.section_id + ">" + obj.section + "</option>";
                    });
                    $('#section_id').append(div_data);
                }
            });
        });
        
        $('#select_all').on('click', function () {
            if (this.checked) {
                $('.checkbox').each(function () {
                    this.checked = true;
                });
            } else {
                $('.checkbox').each(function () {
                    this.checked = false;
                });
            }
        });
        
        $('.checkbox').on('click', function () {
            if ($('.checkbox:checked').length == $('.checkbox').length) {
                $('#select_all').prop('checked', true);
            } else {
                $('#select_all').prop('checked', false);
            }
        });
        
        // Add search form validation
        $('#searchForm').on('submit', function(e) {
            console.log('Search form submitted');
            var classId = $('#class_id').val();
            var idcardId = $('#idcard_id').val();
            
            if (!classId) {
                alert('Please select a class');
                e.preventDefault();
                return false;
            }
            
            if (!idcardId) {
                alert('Please select an ID card template');
                e.preventDefault();
                return false;
            }
            
            // Show loading indicator
            $('#searchButton').html('<i class="fa fa-spinner fa-spin"></i> Searching...');
            return true;
        });
        
        // Handle single ID card generation
        $(document).on('click', '.generate-single-idcard', function() {
            var studentId = $(this).data('student-id');
            var idcardId = $(this).data('idcard-id');
            
            console.log('Generating single ID card for student:', studentId, 'with template:', idcardId);
            
            if (!studentId || !idcardId) {
                console.error('Missing student ID or ID card template ID');
                alert('Error: Missing student ID or ID card template ID');
                return;
            }
            
            // Show loading indicator
            $(this).html('<i class="fa fa-spinner fa-spin"></i>');
            var button = $(this);
            
            $.ajax({
                url: '<?php echo site_url("admin/idcardgenerate/generate") ?>/' + studentId + '/' + idcardId,
                type: 'get',
                success: function(response) {
                    // Reset button
                    button.html('<i class="fa fa-id-card"></i>');
                    
                    if (response.trim() === '') {
                        console.error('Empty response received');
                        alert('Error: Empty response received from server');
                        return;
                    }
                    
                    try {
                        Popup(response);
                    } catch (e) {
                        console.error('Error in Popup function:', e);
                        alert('Error displaying ID card. Please check console for details.');
                    }
                },
                error: function(xhr, status, error) {
                    // Reset button
                    button.html('<i class="fa fa-id-card"></i>');
                    console.error('AJAX Error:', status, error);
                    alert('Error generating ID card. Please check console for details.');
                }
            });
        })
        });
    });
    
    function Popup(data) {
        try {
            console.log('Popup function called with data length:', data.length);
            
            // Create a new window for the ID card
            var idCardWindow = window.open('', '_blank', 'width=800,height=600');
            if (!idCardWindow) {
                alert('Please allow popups for this website to view the ID card');
                return false;
            }
            
            // Write the data to the new window
            idCardWindow.document.open();
            idCardWindow.document.write(data);
            idCardWindow.document.close();
            
            // Add print button functionality
            idCardWindow.onload = function() {
                var printButton = idCardWindow.document.querySelector('.print-button');
                if (printButton) {
                    printButton.onclick = function() {
                        idCardWindow.print();
                    };
                }
            };
            
            return true;
        } catch (e) {
            console.error('Error in Popup function:', e);
            alert('Error displaying ID card: ' + e.message);
            return false;
        }
    }
    
    function generateSingleIdCard(studentId, idcardId) {
        console.log('Generating single ID card for student:', studentId, 'with template:', idcardId);
        
        if (!studentId || !idcardId) {
            console.error('Missing student ID or ID card template ID');
            alert('Error: Missing student ID or ID card template ID');
            return false;
        }
        
        // Show loading indicator
        var button = $('.generate-single-idcard[data-student-id="' + studentId + '"]');
        console.log('Button found:', button.length > 0);
        
        if (button.length > 0) {
            var originalButtonHtml = button.html();
            button.addClass('disabled');
            button.html('<i class="fa fa-spinner fa-spin"></i> Loading...');
        }
        
        // Direct navigation to the ID card generation URL
        var url = '<?php echo site_url("admin/idcardgenerate/generate") ?>/' + studentId + '/' + idcardId;
        console.log('Navigating to URL:', url);
        
        // Open in a new window/tab
        var idCardWindow = window.open(url, '_blank');
        
        if (!idCardWindow) {
            alert('Popup blocked! Please allow popups for this site to generate ID cards.');
            if (button.length > 0) {
                button.removeClass('disabled');
                button.html(originalButtonHtml);
            }
            return false;
        }
        
        // Reset button after a short delay
        if (button.length > 0) {
            setTimeout(function() {
                button.removeClass('disabled');
                button.html(originalButtonHtml);
            }, 2000);
        }
        
        return false;
    }
    
    function submitSelectedStudents() {
        console.log('submitSelectedStudents called');
        
        // Get selected student IDs
        var selectedStudents = [];
        $('.checkbox:checked').each(function() {
            selectedStudents.push($(this).val());
        });

        if (selectedStudents.length === 0) {
            alert('Please select at least one student');
            return false;
        }

        var classId = $("input[name='class_id']").val();
        var idcardId = $("input[name='idcard_id']").val();

        if (!classId || !idcardId) {
            alert('Please make sure class and ID card template are selected');
            return false;
        }

        // Submit the form with selected students
        var form = $('<form>', {
            'action': '<?php echo site_url('admin/idcardgenerate/multiple'); ?>',
            'method': 'post',
            'target': '_blank'
        });

        // Add CSRF token
        form.append($('<input>', {
            'type': 'hidden',
            'name': '<?php echo $this->security->get_csrf_token_name(); ?>',
            'value': '<?php echo $this->security->get_csrf_hash(); ?>'
        }));

        // Add selected students
        $.each(selectedStudents, function(i, studentId) {
            form.append($('<input>', {
                'type': 'hidden',
                'name': 'student_id[]',
                'value': studentId
            }));
        });

        // Add class and ID card info
        form.append($('<input>', {
            'type': 'hidden',
            'name': 'class_id',
            'value': classId
        }));

        form.append($('<input>', {
            'type': 'hidden',
            'name': 'idcard_id',
            'value': idcardId
        }));


        // Add form to body and submit
        $('body').append(form);
        form.submit();
        form.remove();

        return false;
        $('.checkbox:checked').each(function() {
            selectedStudents.push($(this).val());
        });
        
        console.log('Selected students:', selectedStudents);
        
        if (selectedStudents.length === 0) {
            alert('Please select at least one student');
            return false;
        }
        
        var classId = $('#class_id').val();
        var idcardId = $('#idcard_id').val();
        
        if (!classId || !idcardId) {
            alert('Please select class and ID card template');
            return false;
        }
        
        console.log('Class ID:', classId, 'ID Card ID:', idcardId);
        
        // Show loading indicator on the button that was clicked
        var $button = $(event.currentTarget);
        var originalButtonText = $button.html();
        $button.html('<i class="fa fa-spinner fa-spin"></i> Processing...');
        $button.prop('disabled', true);
        
        // Create a form dynamically
        var form = document.createElement('form');
        form.method = 'POST';
        form.action = '<?php echo site_url("admin/idcardgenerate/generatemultiple"); ?>';
        form.target = '_blank'; // Open in new tab
        
        // Add CSRF token
        var csrfToken = document.createElement('input');
        csrfToken.type = 'hidden';
        csrfToken.name = '<?php echo $this->security->get_csrf_token_name(); ?>';
        csrfToken.value = '<?php echo $this->security->get_csrf_hash(); ?>';
        form.appendChild(csrfToken);
        
        // Add class_id
        var classIdInput = document.createElement('input');
        classIdInput.type = 'hidden';
        classIdInput.name = 'class_id';
        classIdInput.value = classId;
        form.appendChild(classIdInput);
        
        // Add idcard_id
        var idcardIdInput = document.createElement('input');
        idcardIdInput.type = 'hidden';
        idcardIdInput.name = 'idcard_id';
        idcardIdInput.value = idcardId;
        form.appendChild(idcardIdInput);
        
        // Add student_ids
        for (var i = 0; i < selectedStudents.length; i++) {
            var studentIdInput = document.createElement('input');
            studentIdInput.type = 'hidden';
            studentIdInput.name = 'student_ids[]';
            studentIdInput.value = selectedStudents[i];
            form.appendChild(studentIdInput);
        }
        
        // Append form to body
        document.body.appendChild(form);
        console.log('Form created, submitting...');
        
        try {
            // Submit the form
            form.submit();
            console.log('Form submitted successfully');
            
            // Check if popup was blocked
            setTimeout(function() {
                alert('If no new window opened, please check your popup blocker settings and try again.');
            }, 1000);
        } catch (e) {
            console.error('Error submitting form:', e);
            alert('Error generating ID cards: ' + e.message);
        }
        
        // Remove form from DOM after submission
        setTimeout(function() {
            if (document.body.contains(form)) {
                document.body.removeChild(form);
            }
            // Reset button
            $button.html(originalButtonText);
            $button.prop('disabled', false);
        }, 2000);
        
        return false;
    }
</script>

<script type="text/javascript">
// Fix for buttons not responding
$(document).ready(function() {
    // Select/Deselect all checkboxes
    $('#select_all').on('click', function() {
        var isChecked = $(this).prop('checked');
        $('.checkbox').prop('checked', isChecked);
        updateSelectAllCheckbox();
    });

    // Update "Select All" checkbox state when individual checkboxes are clicked
    $(document).on('change', '.checkbox', function() {
        updateSelectAllCheckbox();
    });

    // Function to update "Select All" checkbox state
    function updateSelectAllCheckbox() {
        var allChecked = $('.checkbox').length === $('.checkbox:checked').length;
        $('#select_all').prop('checked', allChecked);
    }
    // Direct click handler for single ID card generation
    $(document).on('click', '.generate-single-idcard', function(e) {
        e.preventDefault();
        var studentId = $(this).data('student-id');
        var idcardId = $(this).data('idcard-id');
        console.log('Direct click handler - Generate single ID card for:', studentId);
        
        // Show loading state
        var $button = $(this);
        var originalHtml = $button.html();
        $button.html('<i class="fa fa-spinner fa-spin"></i> Loading...');
        
        // Open in a new window directly
        var url = '<?php echo site_url("admin/idcardgenerate/generate") ?>/' + studentId + '/' + idcardId;
        window.open(url, '_blank');
        
        // Reset button after delay
        setTimeout(function() {
            $button.html(originalHtml);
        }, 2000);
        
        return false;
    });
    
    // Direct click handler for generate selected buttons
    $(document).on('click', 'button[onclick*="submitSelectedStudents"]', function(e) {
        e.preventDefault();
        console.log('Direct click handler - Generate selected');
        
        // Get selected student IDs
        var selectedStudents = [];
        $('.checkbox:checked').each(function() {
            selectedStudents.push($(this).val());
        });
        
        if (selectedStudents.length === 0) {
            alert('Please select at least one student');
            return false;
        }
        
        var classId = $('#class_id').val();
        var idcardId = $('#idcard_id').val();
        
        if (!classId || !idcardId) {
            alert('Please select class and ID card template');
            return false;
        }
        
        // Show loading state
        var $button = $(this);
        var originalHtml = $button.html();
        $button.html('<i class="fa fa-spinner fa-spin"></i> Processing...');
        
        // Create a form dynamically
        var form = document.createElement('form');
        form.method = 'POST';
        form.action = '<?php echo site_url("admin/idcardgenerate/generatemultiple"); ?>';
        form.target = '_blank'; // Open in new tab
        
        // Add CSRF token
        var csrfToken = document.createElement('input');
        csrfToken.type = 'hidden';
        csrfToken.name = '<?php echo $this->security->get_csrf_token_name(); ?>';
        csrfToken.value = '<?php echo $this->security->get_csrf_hash(); ?>';
        form.appendChild(csrfToken);
        
        // Add class_id
        var classIdInput = document.createElement('input');
        classIdInput.type = 'hidden';
        classIdInput.name = 'class_id';
        classIdInput.value = classId;
        form.appendChild(classIdInput);
        
        // Add idcard_id
        var idcardIdInput = document.createElement('input');
        idcardIdInput.type = 'hidden';
        idcardIdInput.name = 'idcard_id';
        idcardIdInput.value = idcardId;
        form.appendChild(idcardIdInput);
        
        // Add student_ids
        for (var i = 0; i < selectedStudents.length; i++) {
            var studentIdInput = document.createElement('input');
            studentIdInput.type = 'hidden';
            studentIdInput.name = 'student_ids[]';
            studentIdInput.value = selectedStudents[i];
            form.appendChild(studentIdInput);
        }
        
        // Append form to body and submit
        document.body.appendChild(form);
        form.submit();
        
        // Remove form from DOM after submission
        setTimeout(function() {
            if (document.body.contains(form)) {
                document.body.removeChild(form);
            }
            $button.html(originalHtml);
        }, 2000);
        
        return false;
    });
});
</script>

<?php

function getSectionByClasses($classes, $class_id, $section_id) {
    $CI = &get_instance();
    $CI->load->model('section_model');
    
    $sections = $CI->section_model->getClassBySection($class_id);
    $options = '';
    foreach ($sections as $section) {
        $selected = ($section['section_id'] == $section_id) ? 'selected' : '';
        $options .= "<option value='" . $section['section_id'] . "' " . $selected . ">" . $section['section'] . "</option>";
    }
    return $options;
}
?>
