<!-- Load face-api.js library first -->
<script src="<?php echo base_url(); ?>backend/faceattendance/face-api.min.js"></script>
<link rel="stylesheet" href="<?php echo base_url(); ?>backend/faceattendance/face-api.css">

<script type="text/javascript">
    var base_url = "<?php echo base_url(); ?>";
</script>

<style>
.settings-card {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 20px;
    box-shadow: 0 20px 40px rgba(0,0,0,0.1);
    border: none;
    overflow: hidden;
    margin-bottom: 20px;
}

.settings-header {
    background: rgba(255,255,255,0.1);
    backdrop-filter: blur(10px);
    border: none;
    padding: 20px;
    text-align: center;
}

.settings-title {
    color: white;
    font-size: 24px;
    font-weight: 600;
    margin: 0;
    text-shadow: 0 2px 4px rgba(0,0,0,0.3);
}

.settings-body {
    background: white;
    padding: 30px;
    border-radius: 0 0 20px 20px;
}

.form-group-modern {
    margin-bottom: 20px;
}

.form-label-modern {
    font-weight: 600;
    color: #333;
    margin-bottom: 8px;
    font-size: 14px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    display: block;
}

.form-control-modern {
    border: 2px solid #e1e5e9;
    border-radius: 10px;
    padding: 12px 15px;
    font-size: 14px;
    transition: all 0.3s ease;
    background: #f8f9fa;
    width: 100%;
}

.form-control-modern:focus {
    border-color: #667eea;
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    background: white;
    outline: none;
}

.btn-modern {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border: none;
    border-radius: 10px;
    padding: 12px 25px;
    color: white;
    font-weight: 600;
    font-size: 14px;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 0.3px;
    margin-right: 10px;
}

.btn-modern:hover {
    transform: translateY(-2px);
    box-shadow: 0 10px 30px rgba(102, 126, 234, 0.4);
    color: white;
}

.btn-success-modern {
    background: linear-gradient(135deg, #56ab2f 0%, #a8e6cf 100%);
}

.btn-success-modern:hover {
    box-shadow: 0 10px 30px rgba(86, 171, 47, 0.4);
}

.btn-danger-modern {
    background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
}

.btn-danger-modern:hover {
    box-shadow: 0 10px 30px rgba(220, 53, 69, 0.4);
}

.settings-section {
    background: #f8f9fa;
    border-radius: 15px;
    padding: 20px;
    margin-bottom: 20px;
    border: 2px solid #e1e5e9;
}

.section-title {
    color: #667eea;
    font-size: 18px;
    font-weight: 600;
    margin-bottom: 15px;
    text-align: center;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.time-input-group {
    display: flex;
    align-items: center;
    gap: 10px;
}

.time-input-group label {
    min-width: 60px;
    font-weight: 500;
    color: #666;
}

.range-display {
    background: #667eea;
    color: white;
    padding: 8px 15px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 500;
    text-align: center;
    margin-top: 5px;
}

.status-message {
    border-radius: 12px;
    padding: 15px;
    margin-top: 20px;
    font-weight: 500;
    text-align: center;
    font-size: 14px;
    display: none;
}

.checkbox-modern {
    position: relative;
    display: inline-block;
    width: 60px;
    height: 34px;
}

.checkbox-modern input {
    opacity: 0;
    width: 0;
    height: 0;
}

.slider {
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: #ccc;
    transition: .4s;
    border-radius: 34px;
}

.slider:before {
    position: absolute;
    content: "";
    height: 26px;
    width: 26px;
    left: 4px;
    bottom: 4px;
    background-color: white;
    transition: .4s;
    border-radius: 50%;
}

input:checked + .slider {
    background-color: #667eea;
}

input:checked + .slider:before {
    transform: translateX(26px);
}

.info-box {
    background: linear-gradient(135deg, #e3f2fd 0%, #bbdefb 100%);
    border: 2px solid #2196f3;
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 20px;
    color: #1976d2;
    font-size: 14px;
}

.info-box i {
    margin-right: 8px;
    font-size: 16px;
}
</style>

<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-cog"></i> Camera Settings
            <small>Configure face recognition and time settings</small>
        </h1>
    </section>
    
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="settings-card">
                    <div class="settings-header">
                        <h3 class="settings-title">
                            <i class="fa fa-camera" style="margin-right: 10px;"></i>
                            Face Attendance Settings
                        </h3>
                    </div>
                    
                    <div class="settings-body">
                        <div class="info-box">
                            <i class="fa fa-info-circle"></i>
                            Configure camera preferences, time windows, and face recognition settings for the attendance system.
                        </div>
                        
                        <form id="settings-form">
                            <div class="row">
                                <!-- Camera Settings -->
                                <div class="col-md-6">
                                    <div class="settings-section">
                                        <h4 class="section-title">
                                            <i class="fa fa-video-camera"></i> Camera Configuration
                                        </h4>
                                        
                                        <div class="form-group-modern">
                                            <label class="form-label-modern">Camera Preference</label>
                                            <select class="form-control-modern" id="camera_preference" name="camera_preference">
                                                <option value="user_choice">User Choice (Manual Selection)</option>
                                                <option value="front">Front Camera</option>
                                                <option value="back">Back Camera</option>
                                                <option value="environment">Environment Camera</option>
                                            </select>
                                        </div>
                                        
                                        <div class="form-group-modern">
                                            <label class="form-label-modern">Camera Resolution</label>
                                            <select class="form-control-modern" id="camera_resolution" name="camera_resolution">
                                                <option value="auto">Auto (Recommended)</option>
                                                <option value="720p">720p (HD)</option>
                                                <option value="1080p">1080p (Full HD)</option>
                                                <option value="480p">480p (Standard)</option>
                                            </select>
                                        </div>
                                        
                                        <div class="form-group-modern">
                                            <label class="form-label-modern">Face Match Threshold</label>
                                            <input type="range" class="form-control-modern" id="face_match_threshold" name="face_match_threshold" 
                                                   min="0.3" max="0.9" step="0.1" value="0.6">
                                            <div class="range-display" id="threshold-display">0.6 (Balanced)</div>
                                            <small style="color: #666; font-size: 12px;">Lower = More lenient, Higher = More strict</small>
                                        </div>
                                        
                                        <div class="form-group-modern">
                                            <label class="form-label-modern">Auto Capture Delay (seconds)</label>
                                            <input type="range" class="form-control-modern" id="auto_capture_delay" name="auto_capture_delay" 
                                                   min="1" max="10" step="1" value="3">
                                            <div class="range-display" id="delay-display">3 seconds</div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Time Settings -->
                                <div class="col-md-6">
                                    <div class="settings-section">
                                        <h4 class="section-title">
                                            <i class="fa fa-clock-o"></i> Time Windows
                                        </h4>
                                        
                                        <div class="form-group-modern">
                                            <label class="form-label-modern">Check-in Time Range</label>
                                            <div class="time-input-group">
                                                <label>From:</label>
                                                <input type="time" class="form-control-modern" id="checkin_start_time" name="checkin_start_time" value="08:00">
                                                <label>To:</label>
                                                <input type="time" class="form-control-modern" id="checkin_end_time" name="checkin_end_time" value="10:00">
                                            </div>
                                            <div class="range-display" id="checkin-display">08:00 AM - 10:00 AM</div>
                                        </div>
                                        
                                        <div class="form-group-modern">
                                            <label class="form-label-modern">Check-out Time Range</label>
                                            <div class="time-input-group">
                                                <label>From:</label>
                                                <input type="time" class="form-control-modern" id="checkout_start_time" name="checkout_start_time" value="15:00">
                                                <label>To:</label>
                                                <input type="time" class="form-control-modern" id="checkout_end_time" name="checkout_end_time" value="18:00">
                                            </div>
                                            <div class="range-display" id="checkout-display">03:00 PM - 06:00 PM</div>
                                        </div>
                                    </div>
                                    
                                    <div class="settings-section">
                                        <h4 class="section-title">
                                            <i class="fa fa-bell"></i> Notifications
                                        </h4>
                                        
                                        <div class="form-group-modern">
                                            <label class="form-label-modern">SMS Notifications</label>
                                            <div style="display: flex; align-items: center; gap: 15px;">
                                                <label class="checkbox-modern">
                                                    <input type="checkbox" id="sms_notifications" name="sms_notifications" checked>
                                                    <span class="slider"></span>
                                                </label>
                                                <span style="color: #666; font-size: 14px;">Send SMS notifications when attendance is marked</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Action Buttons -->
                            <div class="row">
                                <div class="col-md-12" style="text-align: center; margin-top: 20px;">
                                    <button type="submit" class="btn-modern btn-success-modern">
                                        <i class="fa fa-save"></i> Save Settings
                                    </button>
                                    <button type="button" class="btn-modern" id="reset-btn">
                                        <i class="fa fa-refresh"></i> Reset to Default
                                    </button>
                                    <button type="button" class="btn-modern btn-danger-modern" onclick="window.history.back()">
                                        <i class="fa fa-arrow-left"></i> Back
                                    </button>
                                </div>
                            </div>
                        </form>
                        
                        <div id="status-message" class="status-message"></div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script>
$(document).ready(function() {
    // Load current settings
    loadSettings();
    
    // Update threshold display
    $('#face_match_threshold').on('input', function() {
        var value = parseFloat($(this).val());
        var text = value.toFixed(1);
        if (value <= 0.4) text += ' (Very Lenient)';
        else if (value <= 0.5) text += ' (Lenient)';
        else if (value <= 0.7) text += ' (Balanced)';
        else if (value <= 0.8) text += ' (Strict)';
        else text += ' (Very Strict)';
        $('#threshold-display').text(text);
    });
    
    // Update delay display
    $('#auto_capture_delay').on('input', function() {
        var value = $(this).val();
        $('#delay-display').text(value + ' seconds');
    });
    
    // Update time displays
    function updateTimeDisplays() {
        var checkinStart = $('#checkin_start_time').val();
        var checkinEnd = $('#checkin_end_time').val();
        var checkoutStart = $('#checkout_start_time').val();
        var checkoutEnd = $('#checkout_end_time').val();
        
        $('#checkin-display').text(formatTime(checkinStart) + ' - ' + formatTime(checkinEnd));
        $('#checkout-display').text(formatTime(checkoutStart) + ' - ' + formatTime(checkoutEnd));
    }
    
    $('#checkin_start_time, #checkin_end_time, #checkout_start_time, #checkout_end_time').on('change', updateTimeDisplays);
    
    // Format time for display
    function formatTime(time) {
        var parts = time.split(':');
        var hour = parseInt(parts[0]);
        var minute = parts[1];
        var ampm = hour >= 12 ? 'PM' : 'AM';
        hour = hour % 12;
        hour = hour ? hour : 12;
        return hour + ':' + minute + ' ' + ampm;
    }
    
    // Load settings from server
    function loadSettings() {
        $.ajax({
            url: base_url + 'admin/faceattendance/settings/getSettingsJson',
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                if (response.status && response.settings) {
                    var settings = response.settings;
                    
                    $('#camera_preference').val(settings.camera_preference);
                    $('#face_match_threshold').val(settings.face_match_threshold).trigger('input');
                    $('#auto_capture_delay').val(settings.auto_capture_delay).trigger('input');
                    $('#checkin_start_time').val(settings.checkin_start_time);
                    $('#checkin_end_time').val(settings.checkin_end_time);
                    $('#checkout_start_time').val(settings.checkout_start_time);
                    $('#checkout_end_time').val(settings.checkout_end_time);
                    $('#sms_notifications').prop('checked', settings.sms_notifications == 1);
                    $('#camera_resolution').val(settings.camera_resolution);
                    
                    updateTimeDisplays();
                }
            },
            error: function() {
                showMessage('Error loading settings', 'error');
            }
        });
    }
    
    // Save settings
    $('#settings-form').on('submit', function(e) {
        e.preventDefault();
        
        var formData = {
            camera_preference: $('#camera_preference').val(),
            face_match_threshold: $('#face_match_threshold').val(),
            auto_capture_delay: $('#auto_capture_delay').val(),
            checkin_start_time: $('#checkin_start_time').val(),
            checkin_end_time: $('#checkin_end_time').val(),
            checkout_start_time: $('#checkout_start_time').val(),
            checkout_end_time: $('#checkout_end_time').val(),
            sms_notifications: $('#sms_notifications').is(':checked') ? 1 : 0,
            camera_resolution: $('#camera_resolution').val()
        };
        
        $.ajax({
            url: base_url + 'admin/faceattendance/settings/saveSettings',
            type: 'POST',
            data: formData,
            dataType: 'json',
            beforeSend: function() {
                showMessage('Saving settings...', 'info');
            },
            success: function(response) {
                if (response.status) {
                    showMessage(response.msg, 'success');
                } else {
                    showMessage(response.msg, 'error');
                }
            },
            error: function() {
                showMessage('Error saving settings. Please try again.', 'error');
            }
        });
    });
    
    // Reset settings
    $('#reset-btn').on('click', function() {
        if (confirm('Are you sure you want to reset all settings to default values?')) {
            $.ajax({
                url: base_url + 'admin/faceattendance/settings/resetSettings',
                type: 'POST',
                dataType: 'json',
                beforeSend: function() {
                    showMessage('Resetting settings...', 'info');
                },
                success: function(response) {
                    if (response.status) {
                        showMessage(response.msg, 'success');
                        setTimeout(function() {
                            location.reload();
                        }, 1500);
                    } else {
                        showMessage(response.msg, 'error');
                    }
                },
                error: function() {
                    showMessage('Error resetting settings. Please try again.', 'error');
                }
            });
        }
    });
    
    // Show status message
    function showMessage(message, type) {
        var $statusMsg = $('#status-message');
        
        $statusMsg.removeClass('alert-success alert-danger alert-info alert-warning')
                  .addClass('alert-' + (type === 'error' ? 'danger' : type))
                  .html('<i class="fa fa-' + getIcon(type) + '"></i> ' + message)
                  .show();
        
        if (type === 'success') {
            setTimeout(function() {
                $statusMsg.fadeOut();
            }, 3000);
        }
    }
    
    function getIcon(type) {
        switch(type) {
            case 'success': return 'check-circle';
            case 'error': return 'exclamation-triangle';
            case 'info': return 'info-circle';
            default: return 'info-circle';
        }
    }
});
</script>
