<!-- Load face-api.js library first -->
<script src="<?php echo base_url(); ?>backend/faceattendance/face-api.min.js"></script>
<script src="<?php echo base_url(); ?>backend/faceattendance/thank-you.js"></script>
<script src="<?php echo base_url(); ?>backend/faceattendance/camera-settings.js"></script>
<link rel="stylesheet" href="<?php echo base_url(); ?>backend/faceattendance/face-api.css">

<script type="text/javascript">
    var base_url = "<?php echo base_url(); ?>";
</script>

<style>
/* Modern Attractive Design */
.content-wrapper {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    min-height: 100vh;
}

.modern-header {
    background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
    color: white;
    padding: 30px 0;
    text-align: center;
    box-shadow: 0 4px 20px rgba(0,0,0,0.1);
    margin-bottom: 30px;
}

.modern-header h1 {
    font-size: 2.5em;
    font-weight: 700;
    text-shadow: 2px 2px 4px rgba(0,0,0,0.3);
    margin: 0;
}

.modern-header .subtitle {
    font-size: 1.2em;
    opacity: 0.9;
    margin-top: 10px;
}

.modern-box {
    background: rgba(255,255,255,0.95);
    border-radius: 20px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.2);
    border: none;
    overflow: hidden;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    margin-bottom: 20px;
}

.modern-box:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 40px rgba(0,0,0,0.3);
}

.modern-box-header {
    background: linear-gradient(135deg, #ff6b6b, #feca57);
    color: white;
    padding: 20px;
    border: none;
}

.modern-box-header h3 {
    margin: 0;
    font-size: 1.4em;
    font-weight: 600;
}

.modern-box-body {
    padding: 25px;
}

.modern-camera-container {
    position: relative;
    width: 100%;
    height: 350px;
    border-radius: 15px;
    overflow: hidden;
    background: linear-gradient(45deg, #000, #333);
    margin-bottom: 20px;
    box-shadow: 0 8px 25px rgba(0,0,0,0.3);
}

.modern-btn {
    background: linear-gradient(135deg, #667eea, #764ba2);
    border: none;
    border-radius: 25px;
    padding: 12px 30px;
    color: white;
    font-weight: 600;
    transition: all 0.3s ease;
    box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
}

.modern-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(102, 126, 234, 0.6);
    color: white;
}

.modern-btn-success {
    background: linear-gradient(135deg, #56ab2f, #a8e6cf);
}

.modern-btn-danger {
    background: linear-gradient(135deg, #ff416c, #ff4b2b);
}

.modern-btn-warning {
    background: linear-gradient(135deg, #f093fb, #f5576c);
}

.modern-form-control {
    border-radius: 15px;
    border: 2px solid #e0e0e0;
    padding: 12px 20px;
    transition: all 0.3s ease;
}

.modern-form-control:focus {
    border-color: #667eea;
    box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
}

.modern-alert {
    border-radius: 15px;
    border: none;
    padding: 15px 20px;
    font-weight: 500;
}

.pulse-animation {
    animation: pulse 2s infinite;
}

/* Additional Modern Styles */
.modern-camera-controls {
    position: absolute;
    top: 15px;
    right: 15px;
    z-index: 1000;
}

.modern-status-indicator {
    background: linear-gradient(135deg, #17a2b8, #138496);
    color: white;
    padding: 15px;
    border-radius: 15px;
    text-align: center;
    margin-bottom: 20px;
    font-weight: 500;
    box-shadow: 0 4px 15px rgba(23, 162, 184, 0.3);
}

/* Enhanced Camera Status Styles */
#camera-status {
    background: linear-gradient(135deg, #28a745, #20c997) !important;
    color: white !important;
    padding: 15px !important;
    border-radius: 15px !important;
    text-align: center !important;
    margin: 15px 0 !important;
    font-weight: 600 !important;
    font-size: 16px !important;
    box-shadow: 0 4px 15px rgba(40, 167, 69, 0.4) !important;
    border: none !important;
}

#camera-status.alert-info {
    background: linear-gradient(135deg, #17a2b8, #138496) !important;
    color: white !important;
}

#camera-status.alert-success {
    background: linear-gradient(135deg, #28a745, #20c997) !important;
    color: white !important;
}

#camera-status.alert-warning {
    background: linear-gradient(135deg, #ffc107, #e0a800) !important;
    color: #212529 !important;
}

#camera-status.alert-danger {
    background: linear-gradient(135deg, #dc3545, #c82333) !important;
    color: white !important;
}

.modern-controls-container {
    text-align: center;
    margin-top: 20px;
}

.modern-controls-container .modern-btn {
    margin: 0 10px;
    min-width: 150px;
}

.modern-attendance-list {
    max-height: 400px;
    overflow-y: auto;
    padding: 10px;
}

.modern-empty-state {
    text-align: center;
    padding: 40px;
    color: #999;
}

.modern-empty-state i {
    margin-bottom: 15px;
    color: #ddd;
}

.modern-instructions {
    display: grid;
    gap: 15px;
    margin-bottom: 25px;
}

.instruction-item {
    display: flex;
    align-items: center;
    padding: 15px;
    background: linear-gradient(135deg, #f8f9fa, #e9ecef);
    border-radius: 15px;
    border-left: 4px solid #667eea;
    transition: transform 0.3s ease;
}

.instruction-item:hover {
    transform: translateX(5px);
}

.instruction-item i {
    color: #667eea;
    margin-right: 15px;
    font-size: 18px;
    width: 25px;
}

.instruction-item span {
    font-weight: 500;
}

.modern-info-box {
    background: linear-gradient(135deg, #28a745, #20c997);
    color: white;
    padding: 20px;
    border-radius: 15px;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-wrap: wrap;
    gap: 10px;
    box-shadow: 0 4px 15px rgba(40, 167, 69, 0.3);
}

.modern-info-box i {
    font-size: 20px;
}

/* Responsive Design */
@media (max-width: 768px) {
    .modern-box-body {
        padding: 15px;
    }
    
    .modern-camera-container {
        height: 250px;
    }
    
    .modern-controls-container .modern-btn {
        margin: 5px;
        min-width: 120px;
        display: block;
        width: 100%;
    }
    
    .instruction-item {
        flex-direction: column;
        text-align: center;
    }
    
    .instruction-item i {
        margin-bottom: 10px;
        margin-right: 0;
    }
}

@keyframes pulse {
    0% { transform: scale(1); }
    50% { transform: scale(1.05); }
    100% { transform: scale(1); }
}

.floating-icon {
    animation: float 3s ease-in-out infinite;
}

@keyframes float {
    0%, 100% { transform: translateY(0px); }
    50% { transform: translateY(-10px); }
}
</style>

<div class="content-wrapper">
    
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-search"></i> Attendance System</h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="modern-box">
                                    <div class="modern-box-header">
                                        <h3><i class="fa fa-camera"></i> AI Face Recognition</h3>
                                        <div style="float: right;">
                                            <a href="<?php echo site_url('admin/faceattendance/attendance/checkout'); ?>" class="modern-btn modern-btn-danger" style="padding: 8px 15px; font-size: 12px;"><i class="fa fa-sign-out"></i> Checkout</a>
                                        </div>
                                        <div style="clear: both;"></div>
                                    </div>
                                    <div class="modern-box-body">
                                        <div class="modern-camera-container">
                                            <video id="camera" style="width: 100%; height: 100%; object-fit: cover;" autoplay muted></video>
                                            <canvas id="face-overlay" style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; pointer-events: none;"></canvas>
                                            
                                            <!-- Fullscreen Controls -->
                                            <div id="camera-controls" class="modern-camera-controls">
                                                <button id="fullscreen-btn" class="modern-btn modern-btn-primary" title="Fullscreen">
                                                    <i class="fa fa-expand"></i>
                                                </button>
                                            </div>
                                            
                                            <!-- Exit Fullscreen Controls (Hidden by default) -->
                                            <div id="fullscreen-controls" class="modern-camera-controls" style="display: none;">
                                                <button id="exit-fullscreen-btn" class="modern-btn modern-btn-danger" title="Exit Fullscreen">
                                                    <i class="fa fa-compress"></i>
                                                </button>
                                            </div>
                                        </div>
                                        
                                        <!-- Camera Status -->
                                        <div id="camera-status" class="modern-status-indicator">
                                            <i class="fa fa-info-circle"></i> Click "Start Camera" to begin AI face recognition
                                        </div>
                                        
                                        <!-- Camera Controls -->
                                        <div class="modern-controls-container">
                                            <button id="start-camera-btn" class="modern-btn modern-btn-success pulse-animation" onclick="startCamera()">
                                                <i class="fa fa-video-camera"></i> Start AI Camera
                                            </button>
                                            <button id="stop-camera-btn" class="modern-btn modern-btn-danger" onclick="stopCamera()" style="display: none;">
                                                <i class="fa fa-stop"></i> Stop Camera
                                            </button>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="modern-box pulse-animation">
                                    <div class="modern-box-header">
                                        <h3><i class="fa fa-id-card"></i> Mark Attendance by ID</h3>
                                    </div>
                                    <div class="modern-box-body">
                                        <div class="form-group">
                                            <label for="user-type">Select User Type:</label>
                                            <select id="user-type" class="modern-form-control">
                                                <option value="student">👨‍🎓 Student</option>
                                                <option value="staff">👨‍🏫 Staff</option>
                                            </select>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="user-id">Enter ID:</label>
                                            <input type="text" id="user-id" class="modern-form-control" placeholder="🆔 Enter student/staff ID">
                                        </div>
                                        
                                        <button id="mark-attendance-btn" class="modern-btn btn-block pulse-animation">
                                            <i class="fa fa-check-circle"></i> Mark Attendance
                                        </button>
                                        
                                        <div id="manual-status" class="alert alert-info" style="margin-top: 15px; text-align: center;">
                                            Enter user ID and click "Mark Attendance"
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="modern-box">
                                    <div class="modern-box-header">
                                        <h3><i class="fa fa-clock-o"></i> Recent Attendance</h3>
                                    </div>
                                    <div class="modern-box-body">
                                        <div id="recent-attendance" class="modern-attendance-list">
                                            <div class="modern-empty-state">
                                                <i class="fa fa-users fa-3x"></i>
                                                <p>No recent attendance records</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row" style="margin-top: 20px;">
                            <div class="col-md-12">
                                <div class="modern-box">
                                    <div class="modern-box-header">
                                        <h3><i class="fa fa-info-circle"></i> Quick Instructions</h3>
                                    </div>
                                    <div class="modern-box-body">
                                        <div class="modern-instructions">
                                            <div class="instruction-item">
                                                <i class="fa fa-user"></i>
                                                <span>Select user type (Student or Staff)</span>
                                            </div>
                                            <div class="instruction-item">
                                                <i class="fa fa-id-card"></i>
                                                <span>Enter the ID number</span>
                                            </div>
                                            <div class="instruction-item">
                                                <i class="fa fa-check"></i>
                                                <span>Click "Mark Attendance" button</span>
                                            </div>
                                            <div class="instruction-item">
                                                <i class="fa fa-camera"></i>
                                                <span>Or use AI camera for face recognition</span>
                                            </div>
                                        </div>
                                        
                                        <div class="modern-info-box">
                                            <i class="fa fa-bar-chart"></i> 
                                            <span>View detailed attendance reports:</span>
                                            <a href="<?php echo site_url('admin/faceattendance/attendance/getAttendanceReport'); ?>" class="modern-btn modern-btn-primary" style="margin-left: 15px;">
                                                <i class="fa fa-bar-chart"></i> View Reports
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script>
// Initialize face detection models
async function initFaceDetection() {
    try {
        // Define model path
        const modelPath = '<?php echo base_url(); ?>backend/faceattendance/models';
        console.log('Loading face-api.js models from:', modelPath);
        
        // Load required face-api.js models
        await faceapi.nets.tinyFaceDetector.loadFromUri(modelPath);
        console.log('TinyFaceDetector model loaded');
        
        await faceapi.nets.faceLandmark68Net.loadFromUri(modelPath);
        console.log('FaceLandmark68Net model loaded');
        
        await faceapi.nets.faceRecognitionNet.loadFromUri(modelPath);
        console.log('FaceRecognitionNet model loaded');
        
        console.log('All face-api.js models loaded successfully');
        return true;
    } catch (error) {
        console.error('Error loading face-api.js models:', error);
        $('#camera-status').removeClass('alert-info alert-success alert-warning').addClass('alert-danger')
            .text('Error loading face detection models: ' + error.message);
        return false;
    }
}

// Thank You Message Function
function showThankYouMessage(userName, userType) {
    // Create the notification container if it doesn't exist
    let notificationContainer = document.getElementById('attendance-notification');
    
    if (!notificationContainer) {
        notificationContainer = document.createElement('div');
        notificationContainer.id = 'attendance-notification';
        notificationContainer.style.cssText = `
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            background-color: rgba(0, 0, 0, 0.8);
            color: white;
            padding: 30px;
            border-radius: 10px;
            text-align: center;
            z-index: 9999;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.5);
            display: none;
            font-family: Arial, sans-serif;
            min-width: 300px;
        `;
        document.body.appendChild(notificationContainer);
    }
    
    // Set the message based on user type
    const greeting = userType === 'student' ? 'Hello, Student' : 'Hello, Staff Member';
    const message = `
        <h2 style="margin-top: 0; color: #4CAF50;">${greeting}</h2>
        <h1 style="font-size: 24px; margin: 15px 0;">${userName}</h1>
        <p style="font-size: 18px; margin-bottom: 20px;">Your attendance has been marked successfully!</p>
        <p style="font-size: 16px;">Thank you for using the face recognition system.</p>
        <div style="width: 100px; height: 100px; margin: 20px auto; background-color: #4CAF50; border-radius: 50%; display: flex; justify-content: center; align-items: center;">
            <div style="color: white; font-size: 50px;">✓</div>
        </div>
    `;
    
    // Set the message and show the notification
    notificationContainer.innerHTML = message;
    notificationContainer.style.display = 'block';
    
    // Hide the notification after 3 seconds
    setTimeout(() => {
        notificationContainer.style.display = 'none';
    }, 3000);
}

$(document).ready(function() {
    // Initialize camera settings
    if (typeof CameraSettings !== 'undefined') {
        window.cameraSettings = new CameraSettings();
        console.log('Camera settings initialized');
    } else {
        console.warn('CameraSettings class not found - camera-settings.js may not be loaded');
    }
    
    // Initialize face detection
    initFaceDetection().then(success => {
        if (success) {
            console.log('Face detection initialized successfully');
        } else {
            console.error('Failed to initialize face detection');
        }
    });
    
    // Local storage for attendance records
    let attendanceRecords = JSON.parse(localStorage.getItem('attendanceRecords')) || [];
    
    // Display existing records
    displayAttendanceRecords();
    
    // Mark attendance button click handler
    $('#mark-attendance-btn').on('click', function() {
        const userId = $('#user-id').val().trim();
        const userType = $('#user-type').val();
        
        if (!userId) {
            $('#manual-status').removeClass('alert-info alert-success alert-warning').addClass('alert-danger').text('Please enter a valid ID');
            return;
        }
        
        // Show loading message
        $('#manual-status').removeClass('alert-success alert-warning alert-danger').addClass('alert-info').text('Processing attendance for ' + userType + ' ID: ' + userId);
        
        // Get user name (for display purposes)
        let userName = 'User ' + userId;
        
        // Call the attendance API
        $.ajax({
            url: base_url + 'admin/faceattendance/attendance/simpleMarkAttendance',
            type: 'POST',
            data: {
                id: userId,
                type: userType
            },
            dataType: 'json',
            success: function(response) {
                console.log('Attendance API response:', response);
                
                if (response.status) {
                    // Get user name if available in response
                    if (response.name) {
                        userName = response.name;
                    }
                    
                    if (response.already_marked) {
                        $('#manual-status').removeClass('alert-info').addClass('alert-warning').text(response.msg);
                    } else {
                        $('#manual-status').removeClass('alert-info').addClass('alert-success').text(response.msg);
                        
                        // Create new attendance record
                        const today = new Date().toLocaleDateString();
                        const record = {
                            userId: userId,
                            userName: userName,
                            userType: userType,
                            date: today,
                            time: new Date().toLocaleTimeString(),
                            method: 'manual'
                        };
                        
                        // Add to records
                        attendanceRecords.unshift(record);
                        
                        // Save to local storage
                        localStorage.setItem('attendanceRecords', JSON.stringify(attendanceRecords));
                        
                        // Update display
                        displayAttendanceRecords();
                    }
                } else {
                    $('#manual-status').removeClass('alert-info').addClass('alert-danger').text(response.msg);
                    
                    // Check if it's a time validation error and show popup
                    if (response.msg && (response.msg.includes('Check-in time') || response.msg.includes('time has'))) {
                        showTimeAlert(response.msg);
                    }
                }
            },
            error: function(xhr, status, error) {
                // Fallback to local storage if API fails
                console.error('Error:', error);
                
                // Check if attendance already marked for today
                const today = new Date().toLocaleDateString();
                const alreadyMarked = attendanceRecords.some(record => 
                    record.userId === userId && 
                    record.userType === userType && 
                    record.date === today
                );
                
                if (alreadyMarked) {
                    $('#manual-status').removeClass('alert-info alert-success alert-danger').addClass('alert-warning').text('Attendance already marked for today');
                } else {
                    // Create new attendance record
                    const record = {
                        userId: userId,
                        userName: userName,
                        userType: userType,
                        date: today,
                        time: new Date().toLocaleTimeString(),
                        method: 'manual'
                    };
                    
                    // Add to records
                    attendanceRecords.unshift(record);
                    
                    // Save to local storage
                    localStorage.setItem('attendanceRecords', JSON.stringify(attendanceRecords));
                    
                    // Update display
                    displayAttendanceRecords();
                    
                    // Show success message
                    $('#manual-status').removeClass('alert-info alert-warning alert-danger').addClass('alert-success').text('Attendance marked successfully');
                }
            }
        });
    });
    
    // Camera functionality
    let stream = null;
    let isFullscreen = false;
    
    // Fullscreen functionality
    function enterFullscreen() {
        const container = document.querySelector('.modern-camera-container');
        
        if (container.requestFullscreen) {
            container.requestFullscreen();
        } else if (container.webkitRequestFullscreen) {
            container.webkitRequestFullscreen();
        } else if (container.mozRequestFullScreen) {
            container.mozRequestFullScreen();
        } else if (container.msRequestFullscreen) {
            container.msRequestFullscreen();
        }
        
        // Apply fullscreen styles
        container.style.position = 'fixed';
        container.style.top = '0';
        container.style.left = '0';
        container.style.width = '100vw';
        container.style.height = '100vh';
        container.style.zIndex = '9999';
        container.style.border = 'none';
        container.style.borderRadius = '0';
        container.style.margin = '0';
        
        // Show exit button
        $('#fullscreen-controls').show();
        $('#camera-controls').hide();
        
        isFullscreen = true;
        console.log('Entered fullscreen mode');
    }
    
    function exitFullscreen() {
        if (document.exitFullscreen) {
            document.exitFullscreen();
        } else if (document.webkitExitFullscreen) {
            document.webkitExitFullscreen();
        } else if (document.mozCancelFullScreen) {
            document.mozCancelFullScreen();
        } else if (document.msExitFullscreen) {
            document.msExitFullscreen();
        }
        
        // Reset styles
        const container = document.querySelector('.modern-camera-container');
        container.style.position = 'relative';
        container.style.top = 'auto';
        container.style.left = 'auto';
        container.style.width = '100%';
        container.style.height = '300px';
        container.style.zIndex = 'auto';
        container.style.border = '3px solid #3c8dbc';
        container.style.borderRadius = '5px';
        container.style.margin = '0 0 15px 0';
        
        // Hide exit button
        $('#fullscreen-controls').hide();
        $('#camera-controls').show();
        
        isFullscreen = false;
        console.log('Exited fullscreen mode');
    }
    
    // Fullscreen event listeners
    $('#fullscreen-btn').on('click', function() {
        enterFullscreen();
    });
    
    $('#exit-fullscreen-btn').on('click', function() {
        exitFullscreen();
    });
    
    // Handle fullscreen change events
    document.addEventListener('fullscreenchange', function() {
        if (!document.fullscreenElement && isFullscreen) {
            exitFullscreen();
        }
    });
    
    document.addEventListener('webkitfullscreenchange', function() {
        if (!document.webkitFullscreenElement && isFullscreen) {
            exitFullscreen();
        }
    });
    
    document.addEventListener('mozfullscreenchange', function() {
        if (!document.mozFullScreenElement && isFullscreen) {
            exitFullscreen();
        }
    });
    
    document.addEventListener('msfullscreenchange', function() {
        if (!document.msFullscreenElement && isFullscreen) {
            exitFullscreen();
        }
    });
    
    // Keyboard shortcut for fullscreen (F key or Escape)
    document.addEventListener('keydown', function(e) {
        if (e.key === 'f' || e.key === 'F') {
            if (!isFullscreen) {
                enterFullscreen();
            }
        } else if (e.key === 'Escape' && isFullscreen) {
            exitFullscreen();
        }
    });
    
    // Start camera button
    $('#start-camera-btn').on('click', function() {
        startCamera();
        $(this).hide();
        $('#stop-camera-btn').show();
    });
    
    // Stop camera button
    $('#stop-camera-btn').on('click', function() {
        stopCamera();
        $(this).hide();
        $('#start-camera-btn').show();
    });
    
    // Start camera function with settings integration
    async function startCamera() {
        const video = document.getElementById('camera');
        
        $('#camera-status').removeClass('alert-success alert-danger alert-warning').addClass('alert-info').text('Starting camera with configured settings...');
        
        try {
            // Wait for camera settings to load
            if (window.cameraSettings) {
                await window.cameraSettings.waitForSettings();
                
                // Use camera settings to start camera
                const result = await window.cameraSettings.startCamera(video);
                
                if (result.success) {
                    stream = result.stream;
                    
                    // Wait for video to be ready
                    video.onloadedmetadata = function() {
                        video.play().then(() => {
                            $('#camera-status').removeClass('alert-info alert-danger alert-warning').addClass('alert-success')
                                .text('Camera started successfully with configured settings');
                            
                            // Start face detection after camera is ready
                            setTimeout(simulateFaceDetection, 500);
                        }).catch(error => {
                            console.error('Error playing video:', error);
                            $('#camera-status').removeClass('alert-info alert-success alert-warning').addClass('alert-danger')
                                .text('Error playing video: ' + error.message);
                        });
                    };
                } else {
                    throw new Error(result.error || 'Failed to start camera');
                }
            } else {
                // Fallback to basic camera if settings not available
                console.warn('Camera settings not available, using basic camera');
                const constraints = { video: true };
                const mediaStream = await navigator.mediaDevices.getUserMedia(constraints);
                stream = mediaStream;
                video.srcObject = mediaStream;
                await video.play();
                
                $('#camera-status').removeClass('alert-info alert-danger alert-warning').addClass('alert-success')
                    .text('Camera started successfully (basic mode)');
                
                setTimeout(simulateFaceDetection, 500);
            }
        } catch (error) {
            console.error('Error starting camera:', error);
            $('#camera-status').removeClass('alert-info alert-success alert-warning').addClass('alert-danger')
                .text('Error accessing camera: ' + error.message);
        }
    }
    
    // Stop camera function
    function stopCamera() {
        if (stream) {
            stream.getTracks().forEach(track => track.stop());
            document.getElementById('camera').srcObject = null;
            $('#camera-status').removeClass('alert-success alert-danger alert-warning').addClass('alert-info').text('Camera stopped');
        }
        
        // Also stop camera through settings if available
        if (window.cameraSettings) {
            window.cameraSettings.stopCamera();
        }
    }
    
    // Global variables for face recognition
    let labeledFaceDescriptors = [];
    let faceMatcher = null;
    
    // Load face data from server
    async function loadFaceData() {
        try {
            $('#camera-status').removeClass('alert-danger alert-warning alert-success').addClass('alert-info').text('Loading registered face data...');
            
            // Fetch face data from the server
            const response = await fetch(base_url + 'admin/faceattendance/attendance/getFaceData');
            const data = await response.json();
            
            if (!data.status || !data.faceData || data.faceData.length === 0) {
                $('#camera-status').removeClass('alert-info alert-success alert-warning').addClass('alert-danger')
                    .text('No registered faces found in the database. Please register faces first.');
                return false;
            }
            
            // Process face data
            const faceDescriptors = [];
            
            for (const faceData of data.faceData) {
                try {
                    // Parse face descriptor from string to Float32Array
                    const descriptorArray = JSON.parse(faceData.faceDescriptor);
                    const descriptor = new Float32Array(descriptorArray);
                    
                    // Create labeled face descriptor
                    const labeledDescriptor = new faceapi.LabeledFaceDescriptors(
                        faceData.id + '|' + faceData.type + '|' + faceData.name, 
                        [descriptor]
                    );
                    
                    faceDescriptors.push(labeledDescriptor);
                } catch (error) {
                    console.error('Error processing face descriptor:', error);
                }
            }
            
            // Create face matcher
            labeledFaceDescriptors = faceDescriptors;
            faceMatcher = new faceapi.FaceMatcher(labeledFaceDescriptors, 0.4); // 0.4 is more strict threshold for better accuracy
            
            $('#camera-status').removeClass('alert-info alert-danger alert-warning').addClass('alert-success')
                .text('Loaded ' + labeledFaceDescriptors.length + ' registered faces');
                
            return true;
        } catch (error) {
            console.error('Error loading face data:', error);
            $('#camera-status').removeClass('alert-info alert-success alert-warning').addClass('alert-danger')
                .text('Error loading face data: ' + error.message);
            return false;
        }
    }
    
    // Real face detection with registered faces only
    async function simulateFaceDetection() {
        if (!stream) return; // Camera stopped
        
        // If face data not loaded yet, load it
        if (!faceMatcher) {
            const success = await loadFaceData();
            if (!success) {
                setTimeout(simulateFaceDetection, 5000); // Try again after 5 seconds
                return;
            }
        }
        
        $('#camera-status').removeClass('alert-danger alert-warning alert-success').addClass('alert-info').text('Scanning for registered faces...');
        
        try {
            const video = document.getElementById('camera');
            const canvas = document.getElementById('face-overlay');
            const ctx = canvas.getContext('2d');
            
            // Set canvas dimensions to match video
            canvas.width = video.videoWidth;
            canvas.height = video.videoHeight;
            
            // Clear previous drawings
            ctx.clearRect(0, 0, canvas.width, canvas.height);
            
            // Detect all faces in the frame with balanced settings for speed and accuracy
            const detections = await faceapi.detectAllFaces(video, new faceapi.TinyFaceDetectorOptions({
                inputSize: 512,        // Balanced input size for good speed and accuracy
                scoreThreshold: 0.7    // Balanced threshold to prevent false detections
            }))
                .withFaceLandmarks()
                .withFaceDescriptors();
            
            if (detections.length === 0) {
                $('#camera-status').removeClass('alert-info alert-success alert-warning').addClass('alert-danger')
                    .text('No faces detected. Please position your face in front of the camera.');
                setTimeout(simulateFaceDetection, 500);
                return;
            }
            
            // Advanced face detection visualization
            detections.forEach((detection, index) => {
                const box = detection.detection.box;
                const confidence = detection.detection.score;
                
                // Scale coordinates to canvas size
                const scaleX = canvas.width / video.videoWidth;
                const scaleY = canvas.height / video.videoHeight;
                
                const x = box.x * scaleX;
                const y = box.y * scaleY;
                const width = box.width * scaleX;
                const height = box.height * scaleY;
                
                // Animated pulse effect
                const time = Date.now() / 1000;
                const pulseIntensity = Math.sin(time * 3 + index) * 0.3 + 0.7;
                
                // Draw outer success glow - exact face size
                ctx.shadowColor = '#00FF00';
                ctx.shadowBlur = 15 * pulseIntensity;
                ctx.strokeStyle = `rgba(0, 255, 0, ${pulseIntensity})`;
                ctx.lineWidth = 3;
                ctx.strokeRect(x, y, width, height);
                
                // Draw main detection box
                ctx.shadowBlur = 0;
                ctx.strokeStyle = '#00FF00';
                ctx.lineWidth = 2;
                ctx.strokeRect(x, y, width, height);
                
                // Draw corner brackets
                const cornerLength = 20;
                ctx.lineWidth = 3;
                // Top-left corner
                ctx.beginPath();
                ctx.moveTo(x, y + cornerLength);
                ctx.lineTo(x, y);
                ctx.lineTo(x + cornerLength, y);
                ctx.stroke();
                
                // Top-right corner
                ctx.beginPath();
                ctx.moveTo(x + width - cornerLength, y);
                ctx.lineTo(x + width, y);
                ctx.lineTo(x + width, y + cornerLength);
                ctx.stroke();
                
                // Bottom-left corner
                ctx.beginPath();
                ctx.moveTo(x, y + height - cornerLength);
                ctx.lineTo(x, y + height);
                ctx.lineTo(x + cornerLength, y + height);
                ctx.stroke();
                
                // Bottom-right corner
                ctx.beginPath();
                ctx.moveTo(x + width - cornerLength, y + height);
                ctx.lineTo(x + width, y + height);
                ctx.lineTo(x + width, y + height - cornerLength);
                ctx.stroke();
                
                // Draw confidence score background
                const confidenceText = `${Math.round(confidence * 100)}%`;
                ctx.font = 'bold 14px Arial';
                const textWidth = ctx.measureText(confidenceText).width;
                
                ctx.fillStyle = 'rgba(0, 255, 0, 0.8)';
                ctx.fillRect(x, y - 25, textWidth + 10, 20);
                
                // Draw confidence score text
                ctx.fillStyle = '#000000';
                ctx.fillText(confidenceText, x + 5, y - 10);
                
                // Draw face detection label
                ctx.fillStyle = '#00FF00';
                ctx.font = 'bold 16px Arial';
                ctx.fillText('👤 FACE DETECTED', x, y + height + 20);
                
                // Draw face landmarks if available
                if (detection.landmarks) {
                    const landmarks = detection.landmarks;
                    ctx.fillStyle = '#00FFFF';
                    
                    // Draw key facial points
                    const keyPoints = [
                        ...landmarks.getLeftEye(),
                        ...landmarks.getRightEye(),
                        ...landmarks.getNose(),
                        ...landmarks.getMouth()
                    ];
                    
                    keyPoints.forEach(point => {
                        const px = point.x * scaleX;
                        const py = point.y * scaleY;
                        
                        ctx.beginPath();
                        ctx.arc(px, py, 2, 0, 2 * Math.PI);
                        ctx.fill();
                    });
                }
            });
            
            // Try to match each detected face with registered faces
            let matchFound = false;
            
            for (let i = 0; i < detections.length; i++) {
                const detection = detections[i];
                const match = faceMatcher.findBestMatch(detection.descriptor);
                const box = detection.detection.box;
                
                // Scale coordinates to canvas size
                const scaleX = canvas.width / video.videoWidth;
                const scaleY = canvas.height / video.videoHeight;
                
                const x = box.x * scaleX;
                const y = box.y * scaleY;
                const width = box.width * scaleX;
                const height = box.height * scaleY;
                
                // If it's not unknown and confidence is good, we have a match
                if (match.label !== 'unknown' && match.distance < 0.5) {
                    matchFound = true;
                    
                    // Parse the label to get id, type and name
                    const [userId, userType, userName] = match.label.split('|');
                    const confidence = (1 - match.distance) * 100;
                    
                    // Advanced recognition visualization
                    const time = Date.now() / 1000;
                    const pulseIntensity = Math.sin(time * 4) * 0.2 + 0.8;
                    
                    // Draw outer success glow
                    ctx.shadowColor = '#00FF00';
                    ctx.shadowBlur = 25 * pulseIntensity;
                    ctx.strokeStyle = `rgba(0, 255, 0, ${pulseIntensity})`;
                    ctx.lineWidth = 6;
                    ctx.strokeRect(x, y, width, height);
                    
                    // Draw main recognition box with gradient effect - exact face size
                    ctx.shadowBlur = 0;
                    const gradient = ctx.createLinearGradient(x, y, x + width, y + height);
                    gradient.addColorStop(0, '#00FF00');
                    gradient.addColorStop(1, '#00CC00');
                    ctx.strokeStyle = gradient;
                    ctx.lineWidth = 3;
                    ctx.strokeRect(x, y, width, height);
                    
                    // Draw advanced corner brackets with animation
                    const cornerLength = 25;
                    const animOffset = Math.sin(time * 5) * 3;
                    ctx.lineWidth = 4;
                    ctx.strokeStyle = '#00FFFF';
                    
                    // Animated corner brackets
                    // Top-left
                    ctx.beginPath();
                    ctx.moveTo(x, y + cornerLength + animOffset);
                    ctx.lineTo(x, y);
                    ctx.lineTo(x + cornerLength + animOffset, y);
                    ctx.stroke();
                    
                    // Top-right
                    ctx.beginPath();
                    ctx.moveTo(x + width - cornerLength - animOffset, y);
                    ctx.lineTo(x + width, y);
                    ctx.lineTo(x + width, y + cornerLength + animOffset);
                    ctx.stroke();
                    
                    // Bottom-left
                    ctx.beginPath();
                    ctx.moveTo(x, y + height - cornerLength - animOffset);
                    ctx.lineTo(x, y + height);
                    ctx.lineTo(x + cornerLength + animOffset, y + height);
                    ctx.stroke();
                    
                    // Bottom-right
                    ctx.beginPath();
                    ctx.moveTo(x + width - cornerLength - animOffset, y + height);
                    ctx.lineTo(x + width, y + height);
                    ctx.lineTo(x + width, y + height - cornerLength - animOffset);
                    ctx.stroke();
                    
                    // Draw user info background with gradient
                    const bgGradient = ctx.createLinearGradient(x, y - 60, x, y - 10);
                    bgGradient.addColorStop(0, 'rgba(0, 255, 0, 0.9)');
                    bgGradient.addColorStop(1, 'rgba(0, 200, 0, 0.7)');
                    ctx.fillStyle = bgGradient;
                    ctx.fillRect(x - 5, y - 60, width + 10, 50);
                    
                    // Draw border for info box
                    ctx.strokeStyle = '#00FF00';
                    ctx.lineWidth = 2;
                    ctx.strokeRect(x - 5, y - 60, width + 10, 50);
                    
                    // Draw success icon
                    ctx.fillStyle = '#FFFFFF';
                    ctx.font = 'bold 20px Arial';
                    ctx.fillText('✓', x + 5, y - 35);
                    
                    // Draw user name with shadow effect
                    ctx.shadowColor = '#000000';
                    ctx.shadowBlur = 2;
                    ctx.fillStyle = '#FFFFFF';
                    ctx.font = 'bold 16px Arial';
                    ctx.fillText(userName, x + 30, y - 35);
                    
                    // Draw user type and ID
                    ctx.shadowBlur = 1;
                    ctx.font = 'bold 12px Arial';
                    ctx.fillText(`${userType.toUpperCase()} ID: ${userId}`, x + 5, y - 18);
                    
                    // Draw confidence score
                    ctx.fillText(`Match: ${Math.round(confidence)}%`, x + 5, y - 5);
                    
                    // Reset shadow
                    ctx.shadowBlur = 0;
                    ctx.shadowColor = 'transparent';
                    
                    // Draw recognition status below
                    ctx.fillStyle = '#00FF00';
                    ctx.font = 'bold 18px Arial';
                    ctx.fillText('🎯 RECOGNIZED & VERIFIED', x, y + height + 25);
                    
                    $('#camera-status').removeClass('alert-info alert-danger alert-warning').addClass('alert-success')
                        .html(`<strong>Registered face detected!</strong><br>ID: ${userId}<br>Name: ${userName}<br>Type: ${userType}`);
                    
                    
                    // Mark attendance via AJAX - use simpleMarkAttendance instead of markAttendance
                    $.ajax({
                        url: base_url + 'admin/faceattendance/attendance/simpleMarkAttendance',
                        type: 'POST',
                        data: {
                            id: userId,
                            type: userType
                        },
                        dataType: 'json',
                        success: function(response) {
                            console.log('Attendance response:', response); // Debug log
                            
                            // Check if already marked attendance today in local records
                            const today = new Date().toLocaleDateString();
                            const alreadyMarked = attendanceRecords.some(r => 
                                r.userId === userId && 
                                r.date === today
                            );
                            
                            if (response.status) {
                                if (response.already_marked) {
                                    // Already marked attendance
                                    $('#camera-status').removeClass('alert-info alert-danger alert-warning').addClass('alert-success')
                                        .html(`<strong>Attendance already marked!</strong><br>ID: ${userId}<br>Name: ${userName}<br>Type: ${userType}`);
                                } else {
                                    // Successfully marked attendance
                                    $('#camera-status').removeClass('alert-info alert-danger alert-warning').addClass('alert-success')
                                        .html(`<strong>Attendance marked successfully!</strong><br>ID: ${userId}<br>Name: ${userName}<br>Type: ${userType}`);
                                    
                                    // Add to recent attendance with face recognition method
                                    if (!alreadyMarked) {
                                        updateRecentAttendance(userId, userType, 'face recognition');
                                    }
                                }
                            } else {
                                // Failed to mark attendance - show error message
                                $('#camera-status').removeClass('alert-info alert-success alert-warning').addClass('alert-danger')
                                    .html(`<strong>Failed to mark attendance!</strong><br>${response.msg || 'Unknown error occurred'}`);
                                
                                // Check if it's a time validation error and show popup
                                if (response.msg && (response.msg.includes('Check-in time') || response.msg.includes('time has'))) {
                                    showTimeAlert(response.msg);
                                }
                            }
                        },
                        error: function(xhr, status, error) {
                            console.error('AJAX Error:', error);
                            $('#camera-status').removeClass('alert-info alert-success alert-warning').addClass('alert-danger')
                                .html(`<strong>Network Error!</strong><br>Failed to connect to server: ${error}`);
                        }
                    });
                    
                    break; // Stop after first match
                }
            }
            
            if (!matchFound) {
                // No registered face detected
                $('#camera-status').removeClass('alert-info alert-success alert-warning').addClass('alert-danger')
                    .text('Face detected, but not recognized. Only registered faces can mark attendance.');
            }
            
            // Continue detection after a delay
            setTimeout(simulateFaceDetection, 1000);
        } catch (error) {
            console.error('Error in face detection:', error);
            $('#camera-status').removeClass('alert-info alert-success alert-warning').addClass('alert-danger')
                .text('Error in face detection: ' + error.message);
            setTimeout(simulateFaceDetection, 5000);
        }
    }
    
    // Function to update recent attendance display
    function updateRecentAttendance(userId, userType, method = 'ID entry') {
        const now = new Date();
        const timeString = now.toLocaleTimeString();
        const dateString = now.toLocaleDateString();
        
        // Fetch user name from server
        $.ajax({
            url: '<?php echo site_url("admin/faceattendance/attendance/getUserName"); ?>',
            type: 'POST',
            data: {
                id: userId,
                type: userType
            },
            dataType: 'json',
            success: function(response) {
                let userName = 'Unknown';
                if (response.status && response.name) {
                    userName = response.name;
                }
                
                const record = {
                    userId: userId,
                    userType: userType,
                    userName: userName,
                    date: dateString,
                    time: timeString,
                    method: method
                };
                
                // Add to records
                attendanceRecords.unshift(record);
                
                // Keep only the last 10 records
                if (attendanceRecords.length > 10) {
                    attendanceRecords = attendanceRecords.slice(0, 10);
                }
                
                // Save to local storage
                localStorage.setItem('attendanceRecords', JSON.stringify(attendanceRecords));
                
                // Update display
                displayAttendanceRecords();
            },
            error: function() {
                // If error, still add record but without name
                const record = {
                    userId: userId,
                    userType: userType,
                    userName: 'Unknown',
                    date: dateString,
                    time: timeString,
                    method: method
                };
                
                // Add to records
                attendanceRecords.unshift(record);
                
                // Keep only the last 10 records
                if (attendanceRecords.length > 10) {
                    attendanceRecords = attendanceRecords.slice(0, 10);
                }
                
                // Save to local storage
                localStorage.setItem('attendanceRecords', JSON.stringify(attendanceRecords));
                
                // Update display
                displayAttendanceRecords();
            }
        });
    }
    
    // Display attendance records
    function displayAttendanceRecords() {
        if (attendanceRecords.length === 0) {
            $('#recent-attendance').html('<p>No recent attendance records to display.</p>');
            return;
        }
        
        let html = '';
        
        // Display up to 5 most recent records
        const recordsToShow = attendanceRecords.slice(0, 5);
        
        recordsToShow.forEach(record => {
            // Get name from record or use placeholder
            const name = record.userName || 'Unknown';
            
            html += `
                <div style="border-bottom: 1px solid #eee; padding-bottom: 10px; margin-bottom: 10px;">
                    <p><strong>${record.userType.charAt(0).toUpperCase() + record.userType.slice(1)}:</strong> ${name}</p>
                    <p><strong>ID:</strong> ${record.userId}</p>
                    <p><strong>Date:</strong> ${record.date}</p>
                    <p><strong>Time:</strong> ${record.time}</p>
                    <p><strong>Method:</strong> ${record.method}</p>
                    <p><strong>Status:</strong> <span style="color: green;">Marked</span></p>
                </div>
            `;
        });
        
        $('#recent-attendance').html(html);
    }
    
    // Function to show time alert popup
    function showTimeAlert(message) {
        // Create modal HTML if it doesn't exist
        if ($('#timeAlertModal').length === 0) {
            const modalHtml = `
                <div class="modal fade" id="timeAlertModal" tabindex="-1" role="dialog" aria-labelledby="timeAlertModalLabel" aria-hidden="true">
                    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                        <div class="modal-content" style="border-radius: 15px; box-shadow: 0 10px 30px rgba(0,0,0,0.3); border: none;">
                            <div class="modal-header" style="background: linear-gradient(135deg, #ff6b35, #f7931e); color: white; border-radius: 15px 15px 0 0; padding: 25px; border: none;">
                                <h3 class="modal-title" id="timeAlertModalLabel" style="font-size: 28px; font-weight: bold; margin: 0;">
                                    <i class="fa fa-clock-o" style="font-size: 32px; margin-right: 15px; animation: pulse 2s infinite;"></i> 
                                    Check-in Time Alert
                                </h3>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="color: white; opacity: 0.8; font-size: 32px;">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body" style="padding: 30px; background: #f8f9fa; border-radius: 0 0 15px 15px;">
                                <div class="alert" style="background: linear-gradient(135deg, #fff3cd, #ffeaa7); border: 2px solid #ffc107; border-radius: 12px; padding: 25px; margin-bottom: 25px;">
                                    <div style="text-align: center; margin-bottom: 15px;">
                                        <i class="fa fa-exclamation-triangle" style="font-size: 48px; color: #e17055; animation: bounce 1s infinite;"></i>
                                    </div>
                                    <div id="timeAlertMessage" style="font-size: 20px; font-weight: 600; color: #2d3436; text-align: center; line-height: 1.4;"></div>
                                </div>
                                <div style="text-align: center; margin-bottom: 20px;">
                                    <p style="font-size: 16px; color: #636e72; margin: 0;">
                                        Please check the current time and try again during the allowed check-in window.
                                    </p>
                                </div>
                                <div class="text-center" style="background: #e8f4fd; padding: 15px; border-radius: 10px; border-left: 4px solid #0984e3; margin-bottom: 0;">
                                    <div style="font-size: 18px; color: #2d3436; font-weight: 500;">
                                        <i class="fa fa-clock-o" style="color: #0984e3; margin-right: 8px; animation: tick 1s infinite;"></i> 
                                        Auto-closing in <span id="countdown" style="font-size: 22px; font-weight: bold; color: #e17055;">5</span> seconds...
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <style>
                    @keyframes pulse {
                        0% { transform: scale(1); }
                        50% { transform: scale(1.1); }
                        100% { transform: scale(1); }
                    }
                    @keyframes bounce {
                        0%, 20%, 50%, 80%, 100% { transform: translateY(0); }
                        40% { transform: translateY(-10px); }
                        60% { transform: translateY(-5px); }
                    }
                    @keyframes tick {
                        0% { transform: rotate(0deg); }
                        25% { transform: rotate(-10deg); }
                        75% { transform: rotate(10deg); }
                        100% { transform: rotate(0deg); }
                    }
                    #timeAlertModal .modal-dialog {
                        margin: 30px auto;
                    }
                    #timeAlertModal .btn:hover {
                        transform: translateY(-2px);
                        box-shadow: 0 6px 20px rgba(116, 185, 255, 0.6);
                    }
                </style>
            `;
            $('body').append(modalHtml);
        }
        
        // Set the message and show the modal
        $('#timeAlertMessage').text(message);
        $('#timeAlertModal').modal('show');
        
        // Auto-close countdown
        let countdown = 5;
        $('#countdown').text(countdown);
        
        const countdownInterval = setInterval(function() {
            countdown--;
            $('#countdown').text(countdown);
            
            if (countdown <= 0) {
                clearInterval(countdownInterval);
                $('#timeAlertModal').modal('hide');
            }
        }, 1000);
        
        // Clear interval if modal is manually closed
        $('#timeAlertModal').on('hidden.bs.modal', function() {
            clearInterval(countdownInterval);
        });
        
        // Play beep sound if available
        if (typeof playBeep === 'function') {
            playBeep();
        }
        
        console.log('Time Alert:', message);
    }
    
    // Allow Enter key to submit
    $('#user-id').on('keypress', function(e) {
        if (e.which === 13) {
            $('#mark-attendance-btn').click();
        }
    });
});
</script>
