<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-map-o"></i> <?php echo $this->lang->line('examinations'); ?> <small><?php echo $this->lang->line('student_fee1'); ?></small>  </h1>
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-search"></i> <?php echo $this->lang->line('select_criteria'); ?></h3>
                    </div>
                    <div class="box-body">
                        <form role="form" action="<?php echo site_url('admin/examresult/printmultiexamreport') ?>" method="post" class="row">
                            <?php echo $this->customlib->getCSRF(); ?>
                            <div class="col-sm-6 col-lg-4 col-md-4">
                                <div class="form-group">
                                    <label><?php echo $this->lang->line('exam_group'); ?></label><small class="req"> *</small>
                                    <select autofocus="" id="exam_group_id" name="exam_group_ids[]" class="form-control select2" multiple>
                                        <option value=""><?php echo $this->lang->line('select'); ?></option>
                                        <?php
                                        foreach ($examgrouplist as $ex_group_key => $ex_group_value) {
                                            ?>
                                            <option value="<?php echo $ex_group_value->id ?>" <?php
                                            if (set_value('exam_group_id') == $ex_group_value->id) {
                                                echo "selected=selected";
                                            }
                                            ?>><?php echo $ex_group_value->name; ?></option>
                                                    <?php
                                                }
                                                ?>
                                    </select>
                                    <span class="text-danger"><?php echo form_error('exam_group_ids[]'); ?></span>
                                </div>  
                            </div><!--./col-md-3-->
                            <div class="col-sm-6 col-lg-4 col-md-4">
                                <div class="form-group">   
                                    <label><?php echo $this->lang->line('exam'); ?></label><small class="req"> *</small>
                                    <select id="exam_id" name="exam_ids[]" class="form-control select2" multiple>
                                        <option value=""><?php echo $this->lang->line('select'); ?></option>
                                    </select>
                                    <span class="text-danger"><?php echo form_error('exam_ids[]'); ?></span>
                                </div>  
                            </div><!--./col-md-3-->
                            <div class="col-sm-6 col-lg-4 col-md-4">
                                <div class="form-group">  
                                    <label><?php echo $this->lang->line('session'); ?></label><small class="req"> *</small>
                                    <select id="session_id" name="session_id" class="form-control" >
                                        <option value=""><?php echo $this->lang->line('select'); ?></option>
                                        <?php
                                        foreach ($sessionlist as $session) {
                                            ?>
                                            <option value="<?php echo $session['id'] ?>" <?php
                                            if (set_value('session_id') == $session['id']) {
                                                echo "selected=selected";
                                            }
                                            ?>><?php echo $session['session'] ?></option>
                                                    <?php
                                                }
                                                ?>
                                    </select>
                                    <span class="text-danger"><?php echo form_error('session_id'); ?></span>
                                </div>  
                            </div>
                            <div class="col-sm-6 col-lg-4 col-md-4">
                                <div class="form-group">   
                                    <label><?php echo $this->lang->line('class'); ?></label><small class="req"> *</small>
                                    <select id="class_id" name="class_id" class="form-control" >
                                        <option value=""><?php echo $this->lang->line('select'); ?></option>
                                        <?php
                                        foreach ($classlist as $class) {
                                            ?>
                                            <option value="<?php echo $class['id'] ?>" <?php
                                            if (set_value('class_id') == $class['id']) {
                                                echo "selected=selected";
                                            }
                                            ?>><?php echo $class['class'] ?></option>
                                                    <?php
                                                }
                                                ?>
                                    </select>
                                    <span class="text-danger"><?php echo form_error('class_id'); ?></span>
                                </div>  
                            </div>
                            <div class="col-sm-6 col-lg-4 col-md-4">
                                <div class="form-group"> 
                                    <label for="exampleInputEmail1"><?php echo $this->lang->line('section'); ?></label><small class="req"> *</small>
                                    <select id="section_id" name="section_id" class="form-control" >
                                        <option value=""><?php echo $this->lang->line('select'); ?></option>
                                    </select>
                                    <span class="text-danger"><?php echo form_error('section_id'); ?></span>
                                </div>
                            </div>
                            <div class="col-sm-6 col-lg-4 col-md-4">
                                <div class="form-group">
                                    <label for="exampleInputEmail1"><?php echo $this->lang->line('marksheet_template'); ?></label><small class="req"> *</small>
                                    <select id="marksheet" name="marksheet" class="form-control" >
                                        <option value=""><?php echo $this->lang->line('select'); ?></option>
                                        <?php
                                        foreach ($marksheetlist as $marksheet) {
                                            ?>
                                            <option value="<?php echo $marksheet->id ?>" <?php
                                            if (set_value('marksheet') == $marksheet->id) {
                                                echo "selected=selected";
                                            }
                                            ?>><?php echo $marksheet->template; ?></option>
                                                    <?php
                                                }
                                                ?>
                                    </select>
                                    <span class="text-danger"><?php echo form_error('marksheet'); ?></span>
                                </div>
                            </div>
                            <div class="col-sm-6 col-lg-4 col-md-4">
                                <div class="form-group">
                                    <label for="use_new_style"><?php echo $this->lang->line('use_new_style'); ?></label>
                                    <div class="checkbox">
                                        <label>
                                            <input type="checkbox" name="use_new_style" id="use_new_style" value="1" <?php if (set_value('use_new_style') == 1) echo "checked"; ?>>
                                            <?php echo $this->lang->line('use_new_style'); ?>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <div class="form-group">
                                    <button type="submit" name="search" value="search_filter" class="btn btn-primary btn-sm pull-right checkbox-toggle"><i class="fa fa-search"></i> <?php echo $this->lang->line('search'); ?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="aa"></div>
                    <?php
                    if (isset($studentList)) {
                        ?>
                        <form id="printMultiMarksheet" action="<?php echo site_url('admin/examresult/printmultiexamreport') ?>" method="post">
                            <input type="hidden" name="marksheet_template" value="<?php echo $marksheet_template; ?>">
                            <input type="hidden" name="use_new_style" value="<?php echo isset($_POST['use_new_style']) ? 1 : 0; ?>">
                            <?php foreach ($exams as $exam_data) { ?>
                                <input type="hidden" name="exam_group_ids[]" value="<?php echo $exam_data['exam_group_id']; ?>">
                                <input type="hidden" name="exam_ids[]" value="<?php echo $exam_data['exam_id']; ?>">
                            <?php } ?>
                            <div class="box-header ptbnull"></div>
                            <div class="box-header with-border">
                                <h3 class="box-title"><i class="fa fa-users"></i> <?php echo $this->lang->line('student_list'); ?></h3>
                                <div class="box-tools pull-right">
                                </div>
                            </div>
                            <div class="box-body">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="table-responsive">
                                            <table class="table table-striped table-bordered table-hover example">
                                                <thead>
                                                    <tr>
                                                        <th>
                                                            <input type="checkbox" id="select_all" />
                                                        </th>
                                                        <th><?php echo $this->lang->line('admission_no'); ?></th>
                                                        <th><?php echo $this->lang->line('student_name'); ?></th>
                                                        <th><?php echo $this->lang->line('father_name'); ?></th>
                                                        <th><?php echo $this->lang->line('date_of_birth'); ?></th>
                                                        <th><?php echo $this->lang->line('category'); ?></th>
                                                        <th><?php echo $this->lang->line('gender'); ?></th>
                                                        <th class="text-right"><?php echo $this->lang->line('action'); ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php
                                                    if (empty($studentList)) {
                                                        ?>
                                                        <tr>
                                                            <td colspan="8" class="text-danger text-center"><?php echo $this->lang->line('no_record_found'); ?></td>
                                                        </tr>
                                                        <?php
                                                    } else {
                                                        $count = 1;
                                                        foreach ($studentList as $student_key => $student_value) {
                                                            ?>
                                                            <tr>
                                                                <td>
                                                                    <input type="checkbox" class="checkbox center-block" name="student_id" data-student_id="<?php echo $student_value->student_id; ?>" value="<?php echo $student_value->student_id; ?>" />
                                                                </td>
                                                                <td><?php echo $student_value->admission_no; ?></td>
                                                                <td>
                                                                    <a href="<?php echo base_url(); ?>student/view/<?php echo $student_value->student_id; ?>">
                                                                        <?php echo $this->customlib->getFullName($student_value->firstname, $student_value->middlename, $student_value->lastname, $sch_setting->middlename, $sch_setting->lastname); ?>
                                                                    </a>
                                                                </td>
                                                                <td><?php echo $student_value->father_name; ?></td>
                                                                <td><?php
                                                                    if (!empty($student_value->dob) && $student_value->dob != '0000-00-00') {
                                                                        echo date($this->customlib->getSchoolDateFormat(), $this->customlib->dateyyyymmddTodateformat($student_value->dob));
                                                                    }
                                                                    ?></td>
                                                                <td><?php echo $student_value->category; ?></td>
                                                                <td><?php echo $student_value->gender; ?></td>
                                                                <td class="pull-right">
                                                                    <button type="button" class="btn btn-default btn-xs printSelected" data-student_id="<?php echo $student_value->student_id; ?>" title="<?php echo $this->lang->line('print'); ?>"><i class="fa fa-print"></i></button>
                                                                </td>
                                                            </tr>
                                                            <?php
                                                            $count++;
                                                        }
                                                    }
                                                    ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="box-footer">
                                <button type="button" class="btn btn-info pull-right" id="printSelectedButton" data-loading-text="<i class='fa fa-spinner fa-spin '></i> Please Wait"> <?php echo $this->lang->line('print_selected'); ?></button>
                            </div>
                        </form>
                    <?php } ?>
                </div>
            </div>
        </div>
    </section>
</div>

<script type="text/javascript">
    $(document).ready(function () {
        $('.select2').select2();
        
        // Handle Print Selected button click
        $(document).on('click', '#printSelectedButton', function(e) {
            var selectedStudents = $('input[name="student_id"]:checked');
            if (selectedStudents.length === 0) {
                alert('<?php echo $this->lang->line("please_select_at_least_one_student"); ?>');
                return false;
            }
            
            // Get the first selected student
            var studentId = selectedStudents.first().val();
            
            // Add hidden input for student_id
            $('<input>').attr({
                type: 'hidden',
                name: 'student_id',
                value: studentId
            }).appendTo('form');
            
            // Submit the form
            $('form').submit();
        });
        
        $(document).on('change', '#exam_group_id', function (e) {
            var exam_group_id = $(this).val();
            if(exam_group_id && exam_group_id.length > 0) {
                // Clear previous options
                $('#exam_id').html("");
                var base_url = '<?php echo base_url() ?>';
                var div_data = '<option value=""><?php echo $this->lang->line('select'); ?></option>';
                
                // For each selected exam group, fetch exams
                $.each(exam_group_id, function(index, group_id) {
                    $.ajax({
                        type: "POST",
                        url: base_url + "admin/examgroup/getExamsByExamGroup",
                        data: {'exam_group_id': group_id},
                        dataType: "json",
                        success: function (response) {
                            if(response.status == 1) {
                                var data = response.result;
                                $.each(data, function (i, obj) {
                                    div_data += "<option value=" + obj.id + ">" + obj.exam + "</option>";
                                });
                                $('#exam_id').html(div_data);
                            }
                        }
                    });
                });
            }
        });

        $(document).on('change', '#class_id', function (e) {
            $('#section_id').html("");
            var class_id = $(this).val();
            getSectionByClass(class_id);
        });

        // Select all checkboxes
        $(document).on('click', '#select_all', function () {
            $('.checkbox').prop('checked', this.checked);
        });

        $(document).on('click', '.checkbox', function () {
            if ($('.checkbox:checked').length == $('.checkbox').length) {
                $('#select_all').prop('checked', true);
            } else {
                $('#select_all').prop('checked', false);
            }
        });

        // Print individual student report
        $(document).on('click', '.printSelected', function () {
            var $this = $(this);
            var student_id = $this.data('student_id');
            $('input.checkbox').prop('checked', false);
            $('input.checkbox[value="' + student_id + '"]').prop('checked', true);
            $('#printSelectedButton').click();
        });

        // Print selected students report
        $(document).on('submit', 'form#printMultiMarksheet', function (e) {
            e.preventDefault();
            var form = $(this);
            var checked = $('input.checkbox:checked').length;
            
            if (checked === 0) {
                alert('<?php echo $this->lang->line("please_select_student"); ?>');
                return false;
            }
            
            if (checked > 1) {
                alert('<?php echo $this->lang->line("please_select_one_student_only"); ?>');
                return false;
            }
            
            var student_id = $('input.checkbox:checked').val();
            form.append('<input type="hidden" name="student_id" value="' + student_id + '">');
            
            var formData = form.serializeArray();
            $.ajax({
                url: form.attr('action'),
                type: 'POST',
                data: formData,
                dataType: 'json',
                beforeSend: function () {
                    $('#printSelectedButton').button('loading');
                },
                success: function (response) {
                    if (response.status === 0) {
                        var message = "";
                        $.each(response.error, function (index, value) {
                            message += value;
                        });
                        errorMsg(message);
                    } else {
                        var base_url = '<?php echo base_url() ?>';
                        printDiv(response.page);
                    }
                    $('#printSelectedButton').button('reset');
                },
                error: function (xhr) {
                    alert("Error occurred! Please try again");
                    $('#printSelectedButton').button('reset');
                },
                complete: function () {
                    $('#printSelectedButton').button('reset');
                }
            });
        });
    });

    function getSectionByClass(class_id) {
        if (class_id != "") {
            $('#section_id').html("");
            var base_url = '<?php echo base_url() ?>';
            var div_data = '<option value=""><?php echo $this->lang->line('select'); ?></option>';
            $.ajax({
                type: "GET",
                url: base_url + "sections/getByClass",
                data: {'class_id': class_id},
                dataType: "json",
                success: function (data) {
                    $.each(data, function (i, obj)
                    {
                        div_data += "<option value=" + obj.section_id + ">" + obj.section + "</option>";
                    });
                    $('#section_id').append(div_data);
                }
            });
        }
    }

    function getExamsByExamGroup(exam_group_id) {
        if (exam_group_id != "") {
            $('#exam_id').html("");
            var base_url = '<?php echo base_url() ?>';
            var div_data = '<option value=""><?php echo $this->lang->line('select'); ?></option>';
            $.ajax({
                type: "POST",
                url: base_url + "admin/examgroup/getExamsByExamGroup",
                data: {'exam_group_id': exam_group_id},
                dataType: "json",
                success: function (response) {
                    if(response.status == 1) {
                        var data = response.result;
                        $.each(data, function (i, obj)
                        {
                            div_data += "<option value=" + obj.id + ">" + obj.exam + "</option>";
                        });
                        $('#exam_id').append(div_data);
                    } else {
                        console.log("Error fetching exams");
                    }
                }
            });
        }
    }

    function printDiv(printable) {
        var printWindow = window.open('', '', 'height=600,width=800');
        printWindow.document.write(printable);
        printWindow.document.close();
        printWindow.focus();
        printWindow.print();
        printWindow.close();
    }
</script>
