<?php
$currency_symbol = $this->customlib->getSchoolCurrencyFormat();
?>
<div class="content-wrapper">
    <section class="content-header">
        <h1><i class="fa fa-certificate"></i> <?php echo $this->lang->line('certificate log'); ?> <?php echo $this->lang->line('logs'); ?></h1>
    </section>
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-search"></i> <?php echo $this->lang->line('search_certificate_logs'); ?></h3>
                    </div>
                    <div class="box-body">
                        <form role="form" action="<?php echo site_url('admin/certificatelogs/search') ?>" method="post" class="">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?php echo $this->lang->line('certificate'); ?></label>
                                        <select class="form-control" name="certificate_id">
                                            <option value=""><?php echo $this->lang->line('select'); ?></option>
                                            <?php foreach ($certificates as $certificate) { ?>
                                                <option value="<?php echo $certificate->id; ?>" <?php if (isset($search_params['certificate_id']) && $search_params['certificate_id'] == $certificate->id) echo 'selected'; ?>><?php echo $certificate->certificate_name; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?php echo $this->lang->line('class'); ?></label>
                                        <select class="form-control" name="class_id" id="class_id">
                                            <option value=""><?php echo $this->lang->line('select'); ?></option>
                                            <?php foreach ($classlist as $class) { ?>
                                                <option value="<?php echo $class['id']; ?>" <?php if (isset($search_params['class_id']) && $search_params['class_id'] == $class['id']) echo 'selected'; ?>><?php echo $class['class']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?php echo $this->lang->line('section'); ?></label>
                                        <select class="form-control" name="section_id" id="section_id">
                                            <option value=""><?php echo $this->lang->line('select'); ?></option>
                                            <?php if (isset($search_params['section_id'])) { 
                                                $sections = $this->section_model->getClassBySection($search_params['class_id']);
                                                foreach ($sections as $section) { ?>
                                                    <option value="<?php echo $section['section_id']; ?>" <?php if ($search_params['section_id'] == $section['section_id']) echo 'selected'; ?>><?php echo $section['section']; ?></option>
                                            <?php } } ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?php echo $this->lang->line('admission_no'); ?></label>
                                        <input type="text" name="admission_no" class="form-control" value="<?php echo isset($search_params['admission_no']) ? $search_params['admission_no'] : ''; ?>">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?php echo $this->lang->line('student'); ?> <?php echo $this->lang->line('name'); ?></label>
                                        <input type="text" name="student_name" class="form-control" value="<?php echo isset($search_params['student_name']) ? $search_params['student_name'] : ''; ?>">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?php echo $this->lang->line('date_from'); ?></label>
                                        <input type="date" name="date_from" class="form-control date" value="<?php echo isset($search_params['date_from']) ? $search_params['date_from'] : ''; ?>">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?php echo $this->lang->line('date_to'); ?></label>
                                        <input type="date" name="date_to" class="form-control date" value="<?php echo isset($search_params['date_to']) ? $search_params['date_to'] : ''; ?>">
                                    </div>
                                </div>
                                <div class="col-md-8">
                                    <div class="form-group">
                                        <label>&nbsp;</label>
                                        <button type="submit" name="search" value="search_filter" class="btn btn-primary btn-sm pull-right checkbox-toggle"><i class="fa fa-search"></i> <?php echo $this->lang->line('search'); ?></button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-list"></i> <?php echo $this->lang->line('certificate_logs_list'); ?></h3>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive mailbox-messages">
                            <div class="download_label"><?php echo $this->lang->line('certificate_logs_list'); ?></div>
                            <table class="table table-striped table-bordered table-hover example">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('certificate'); ?> <?php echo $this->lang->line('name'); ?></th>
                                        <th><?php echo $this->lang->line('student'); ?> <?php echo $this->lang->line('name'); ?></th>
                                        <th><?php echo $this->lang->line('admission_no'); ?></th>
                                        <th><?php echo $this->lang->line('class'); ?></th>
                                        <th><?php echo $this->lang->line('section'); ?></th>
                                        <th><?php echo $this->lang->line('generated_by'); ?></th>
                                        <th><?php echo $this->lang->line('generated_date'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    if (!empty($logs)) {
                                        foreach ($logs as $log) {
                                            ?>
                                            <tr>
                                                <td><?php echo $log['certificate_name']; ?></td>
                                                <td><?php echo $log['student_name']; ?></td>
                                                <td><?php echo $log['admission_no']; ?></td>
                                                <td><?php 
                                                    // Try to get class name from class_id
                                                    $class_name = '';
                                                    if (!empty($log['class_id'])) {
                                                        // Get class directly from the database
                                                        $this->db->select('class');
                                                        $this->db->from('classes');
                                                        $this->db->where('id', $log['class_id']);
                                                        $class_query = $this->db->get();
                                                        $class_result = $class_query->row_array();
                                                        
                                                        if (!empty($class_result)) {
                                                            $class_name = $class_result['class'];
                                                        }
                                                    }
                                                    echo $class_name;
                                                ?></td>
                                                <td><?php 
                                                    // Try to get section name from section_id
                                                    $section_name = '';
                                                    if (!empty($log['section_id'])) {
                                                        // Get section directly from the database
                                                        $this->db->select('section');
                                                        $this->db->from('sections');
                                                        $this->db->where('id', $log['section_id']);
                                                        $section_query = $this->db->get();
                                                        $section_result = $section_query->row_array();
                                                        
                                                        if (!empty($section_result)) {
                                                            $section_name = $section_result['section'];
                                                        }
                                                    }
                                                    echo $section_name;
                                                ?></td>
                                                <td><?php 
                                                    // Try to get staff name from generated_by
                                                    $staff_name = '';
                                                    if (!empty($log['generated_by'])) {
                                                        $staff = $this->staff_model->get($log['generated_by']);
                                                        if (!empty($staff)) {
                                                            $staff_name = $staff['name'] . ' ' . $staff['surname'];
                                                        }
                                                    }
                                                    echo $staff_name;
                                                ?></td>
                                                <td>
                                                    <?php 
                                                    if (!empty($log['created_at'])) {
                                                        echo date($this->customlib->getSchoolDateFormat() . ' H:i:s', strtotime($log['created_at']));
                                                    }
                                                    ?>
                                                </td>
                                            </tr>
                                            <?php
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="pagination">
                                        <?php echo $pagination; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script type="text/javascript">
    $(document).ready(function () {
        // Initialize datepicker
        $('.date').datepicker({
            format: "yyyy-mm-dd",
            autoclose: true,
            todayHighlight: true
        });
        
        // Get sections when class is selected
        $('#class_id').change(function () {
            var class_id = $(this).val();
            getSectionByClass(class_id, 0);
        });
        
        function getSectionByClass(class_id, section_id) {
            if (class_id != "") {
                $('#section_id').html("");
                var base_url = '<?php echo base_url() ?>';
                var div_data = '<option value=""><?php echo $this->lang->line('select'); ?></option>';
                
                $.ajax({
                    type: "POST",
                    url: base_url + "admin/certificatelogs/getSectionByClass",
                    data: {'class_id': class_id},
                    dataType: "json",
                    success: function (data) {
                        $.each(data, function (i, obj) {
                            var sel = "";
                            if (section_id == obj.section_id) {
                                sel = "selected";
                            }
                            div_data += "<option value=" + obj.section_id + " " + sel + ">" + obj.section + "</option>";
                        });
                        $('#section_id').append(div_data);
                    }
                });
            }
        }
    });
</script>
