<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-calculator"></i> <?php echo $this->lang->line('accounts'); ?> <small><?php echo $this->lang->line('dashboard'); ?></small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url() ?>admin/dashboard"><i class="fa fa-dashboard"></i> <?php echo $this->lang->line('dashboard'); ?></a></li>
            <li class="active"><?php echo $this->lang->line('accounts'); ?></li>
        </ol>
    </section>

    <section class="content">
        <div class="row">
            <!-- Financial Summary Cards -->
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3><?php echo $currency_symbol . amountFormat($financial_summary['total_income']); ?></h3>
                        <p>Total Income</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-arrow-up"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/income/incomesearch" class="small-box-footer">
                        More info <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-red">
                    <div class="inner">
                        <h3><?php echo $currency_symbol . amountFormat($financial_summary['total_expense']); ?></h3>
                        <p>Total Expenses</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-arrow-down"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/expense/expensesearch" class="small-box-footer">
                        More info <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="small-box <?php echo ($financial_summary['total_profit'] >= 0) ? 'bg-blue' : 'bg-yellow'; ?>">
                    <div class="inner">
                        <h3><?php echo $currency_symbol . amountFormat($financial_summary['total_profit']); ?></h3>
                        <p><?php echo ($financial_summary['total_profit'] >= 0) ? 'Net Profit' : 'Net Loss'; ?></p>
                    </div>
                    <div class="icon">
                        <i class="fa <?php echo ($financial_summary['total_profit'] >= 0) ? 'fa-line-chart' : 'fa-exclamation-triangle'; ?>"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/accounts/reports" class="small-box-footer">
                        More info <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-aqua">
                    <div class="inner">
                        <h3><?php echo count($accounts_list); ?></h3>
                        <p>Total Accounts</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-bank"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/accounts/account_numbers" class="small-box-footer">
                        More info <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Monthly Summary -->
            <div class="col-md-6">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-calendar"></i> Monthly Summary</h3>
                    </div>
                    <div class="box-body">
                        <table class="table table-striped">
                            <tr>
                                <td><strong>Monthly Income:</strong></td>
                                <td class="text-right text-green">
                                    <strong><?php echo $currency_symbol . amountFormat($financial_summary['monthly_income']); ?></strong>
                                </td>
                            </tr>
                            <tr>
                                <td><strong>Monthly Expenses:</strong></td>
                                <td class="text-right text-red">
                                    <strong><?php echo $currency_symbol . amountFormat($financial_summary['monthly_expense']); ?></strong>
                                </td>
                            </tr>
                            <tr class="<?php echo ($financial_summary['monthly_profit'] >= 0) ? 'success' : 'warning'; ?>">
                                <td><strong>Monthly <?php echo ($financial_summary['monthly_profit'] >= 0) ? 'Profit' : 'Loss'; ?>:</strong></td>
                                <td class="text-right">
                                    <strong><?php echo $currency_symbol . amountFormat($financial_summary['monthly_profit']); ?></strong>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Yearly Summary -->
            <div class="col-md-6">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-calendar-o"></i> Yearly Summary</h3>
                    </div>
                    <div class="box-body">
                        <table class="table table-striped">
                            <tr>
                                <td><strong>Yearly Income:</strong></td>
                                <td class="text-right text-green">
                                    <strong><?php echo $currency_symbol . amountFormat($financial_summary['yearly_income']); ?></strong>
                                </td>
                            </tr>
                            <tr>
                                <td><strong>Yearly Expenses:</strong></td>
                                <td class="text-right text-red">
                                    <strong><?php echo $currency_symbol . amountFormat($financial_summary['yearly_expense']); ?></strong>
                                </td>
                            </tr>
                            <tr class="<?php echo ($financial_summary['yearly_profit'] >= 0) ? 'success' : 'warning'; ?>">
                                <td><strong>Yearly <?php echo ($financial_summary['yearly_profit'] >= 0) ? 'Profit' : 'Loss'; ?>:</strong></td>
                                <td class="text-right">
                                    <strong><?php echo $currency_symbol . amountFormat($financial_summary['yearly_profit']); ?></strong>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Account Numbers List -->
            <div class="col-md-12">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-list"></i> Account Numbers</h3>
                        <div class="box-tools pull-right">
                            <a href="<?php echo base_url(); ?>admin/accounts/account_numbers" class="btn btn-primary btn-sm">
                                <i class="fa fa-plus"></i> Manage Accounts
                            </a>
                        </div>
                    </div>
                    <div class="box-body">
                        <?php if (!empty($accounts_list)) { ?>
                            <div class="table-responsive">
                                <table class="table table-striped table-hover">
                                    <thead>
                                        <tr>
                                            <th>Account Number</th>
                                            <th>Account Name</th>
                                            <th>Type</th>
                                            <th>Opening Balance</th>
                                            <th>Description</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($accounts_list as $account) { ?>
                                            <tr>
                                                <td><strong><?php echo $account['account_number']; ?></strong></td>
                                                <td><?php echo $account['account_name']; ?></td>
                                                <td>
                                                    <span class="label label-<?php 
                                                        echo ($account['account_type'] == 'asset') ? 'success' : 
                                                             (($account['account_type'] == 'liability') ? 'danger' : 
                                                              (($account['account_type'] == 'equity') ? 'info' : 
                                                               (($account['account_type'] == 'revenue') ? 'primary' : 'warning'))); 
                                                    ?>">
                                                        <?php echo ucfirst($account['account_type']); ?>
                                                    </span>
                                                </td>
                                                <td class="text-right">
                                                    <?php echo $currency_symbol . amountFormat($account['opening_balance']); ?>
                                                </td>
                                                <td><?php echo $account['description']; ?></td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php } else { ?>
                            <div class="alert alert-info">
                                <i class="fa fa-info-circle"></i> No accounts found. 
                                <a href="<?php echo base_url(); ?>admin/accounts/account_numbers">Click here to add accounts</a>.
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Quick Actions -->
            <div class="col-md-12">
                <div class="box box-default">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-flash"></i> Quick Actions</h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-3">
                                <a href="<?php echo base_url(); ?>admin/accounts/reports" class="btn btn-block btn-primary">
                                    <i class="fa fa-bar-chart"></i><br>Financial Reports
                                </a>
                            </div>
                            <div class="col-md-3">
                                <a href="<?php echo base_url(); ?>admin/accounts/balance_sheet" class="btn btn-block btn-success">
                                    <i class="fa fa-balance-scale"></i><br>Balance Sheet
                                </a>
                            </div>
                            <div class="col-md-3">
                                <a href="<?php echo base_url(); ?>admin/income/index" class="btn btn-block btn-info">
                                    <i class="fa fa-plus-circle"></i><br>Add Income
                                </a>
                            </div>
                            <div class="col-md-3">
                                <a href="<?php echo base_url(); ?>admin/expense/index" class="btn btn-block btn-warning">
                                    <i class="fa fa-minus-circle"></i><br>Add Expense
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script>
$(document).ready(function() {
    // Add any JavaScript for dashboard functionality
    console.log('Accounts Dashboard Loaded');
});
</script>
