<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Verifycertificate_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database(); // Add database library
        $this->load->model('setting_model');
        
        // Get the current session from the settings
        $setting = $this->setting_model->get();
        if (isset($setting[0]['session_id'])) {
            $this->current_session = $setting[0]['session_id'];
        } else {
            $this->current_session = null;
        }
    }

    /**
     * Verify a certificate by its unique reference number
     * 
     * @param string $ref_no Certificate reference number
     * @return array|bool Returns certificate data if found, false otherwise
     */
    public function verifyCertificate($ref_no)
    {
        $this->db->select('student_certificates.*, certificates.certificate_name, certificates.certificate_text, 
                          certificates.left_header, certificates.center_header, certificates.right_header,
                          certificates.left_footer, certificates.center_footer, certificates.right_footer,
                          certificates.background_image, students.firstname, students.lastname, students.guardian_name,
                          students.dob, students.gender, students.mobileno, students.email,
                          classes.class, sections.section');
        $this->db->from('student_certificates');
        $this->db->join('certificates', 'certificates.id = student_certificates.certificate_id', 'left');
        $this->db->join('students', 'students.id = student_certificates.student_id', 'left');
        $this->db->join('student_session', 'student_session.student_id = students.id', 'left');
        $this->db->join('classes', 'classes.id = student_session.class_id', 'left');
        $this->db->join('sections', 'sections.id = student_session.section_id', 'left');
        $this->db->where('student_certificates.certificate_ref_no', $ref_no);
        
        // Only filter by session if we have a current session
        if ($this->current_session !== null) {
            $this->db->where('student_session.session_id', $this->current_session);
        }
        
        $query = $this->db->get();
        
        if ($query->num_rows() > 0) {
            return $query->row_array();
        }
        
        // If no results with session filter, try without session filter as fallback
        if ($this->current_session !== null) {
            $this->db->select('student_certificates.*, certificates.certificate_name, certificates.certificate_text, 
                              certificates.left_header, certificates.center_header, certificates.right_header,
                              certificates.left_footer, certificates.center_footer, certificates.right_footer,
                              certificates.background_image, students.firstname, students.lastname, students.guardian_name,
                              students.dob, students.gender, students.mobileno, students.email,
                              classes.class, sections.section');
            $this->db->from('student_certificates');
            $this->db->join('certificates', 'certificates.id = student_certificates.certificate_id', 'left');
            $this->db->join('students', 'students.id = student_certificates.student_id', 'left');
            $this->db->join('student_session', 'student_session.student_id = students.id', 'left');
            $this->db->join('classes', 'classes.id = student_session.class_id', 'left');
            $this->db->join('sections', 'sections.id = student_session.section_id', 'left');
            $this->db->where('student_certificates.certificate_ref_no', $ref_no);
            $query = $this->db->get();
            
            if ($query->num_rows() > 0) {
                return $query->row_array();
            }
        }
        
        return false;
    }
    
    /**
     * Verify a student by admission number
     * 
     * @param string $admission_no Student admission number
     * @return array|bool Returns student data if found, false otherwise
     */
    public function verifyByAdmissionNo($admission_no)
    {
        return $this->verifyByAdmissionNoAndName($admission_no, '');
    }
    
    /**
     * Verify a student by admission number and name
     * 
     * @param string $admission_no Student admission number
     * @param string $student_name Student name (optional)
     * @return array|bool Returns student data if found, false otherwise
     */
    public function verifyByAdmissionNoAndName($admission_no, $student_name = '')
    {
        $this->db->select('students.*, students.firstname, students.lastname, students.admission_no, 
                          classes.class, sections.section, students.guardian_name, students.dob, 
                          students.gender, students.mobileno, students.email, students.father_name, 
                          students.mother_name, students.admission_date, students.category_id, 
                          students.religion, students.cast, students.rte, students.current_address, 
                          students.permanent_address, students.previous_school, students.bank_account_no, 
                          students.bank_name, students.ifsc_code, students.guardian_occupation, 
                          students.guardian_phone, students.guardian_address, students.is_active, 
                          students.created_at, students.updated_at, students.father_phone, 
                          students.blood_group, students.school_house_id, students.height, students.weight, 
                          students.measurement_date, students.app_key, students.parent_app_key, 
                          students.disable_at, students.image');
        $this->db->from('students');
        $this->db->join('student_session', 'student_session.student_id = students.id', 'left');
        $this->db->join('classes', 'classes.id = student_session.class_id', 'left');
        $this->db->join('sections', 'sections.id = student_session.section_id', 'left');
        $this->db->where('students.admission_no', $admission_no);
        
        // Add student name filter if provided
        if (!empty($student_name)) {
            $this->db->group_start();
            $this->db->like('students.firstname', $student_name);
            $this->db->or_like('students.lastname', $student_name);
            $this->db->or_like("CONCAT(students.firstname, ' ', students.lastname)", $student_name);
            $this->db->group_end();
        }
        
        // Only filter by session if we have a current session
        if ($this->current_session !== null) {
            $this->db->where('student_session.session_id', $this->current_session);
        }
        
        $this->db->where('students.is_active', 'yes');
        $query = $this->db->get();
        
        if ($query->num_rows() > 0) {
            return $query->row_array();
        }
        
        // If no results with session filter, try without session filter as fallback
        if ($this->current_session !== null) {
            $this->db->select('students.*, students.firstname, students.lastname, students.admission_no, 
                              classes.class, sections.section, students.guardian_name, students.dob, 
                              students.gender, students.mobileno, students.email, students.father_name, 
                              students.mother_name, students.admission_date, students.category_id, 
                              students.religion, students.cast, students.rte, students.current_address, 
                              students.permanent_address, students.previous_school, students.bank_account_no, 
                              students.bank_name, students.ifsc_code, students.guardian_occupation, 
                              students.guardian_phone, students.guardian_address, students.is_active, 
                              students.created_at, students.updated_at, students.father_phone, 
                              students.blood_group, students.school_house_id, students.height, students.weight, 
                              students.measurement_date, students.app_key, students.parent_app_key, 
                              students.disable_at');
            $this->db->from('students');
            $this->db->join('student_session', 'student_session.student_id = students.id', 'left');
            $this->db->join('classes', 'classes.id = student_session.class_id', 'left');
            $this->db->join('sections', 'sections.id = student_session.section_id', 'left');
            $this->db->where('students.admission_no', $admission_no);
            
            // Add student name filter if provided
            if (!empty($student_name)) {
                $this->db->group_start();
                $this->db->like('students.firstname', $student_name);
                $this->db->or_like('students.lastname', $student_name);
                $this->db->or_like("CONCAT(students.firstname, ' ', students.lastname)", $student_name);
                $this->db->group_end();
            }
            
            $this->db->where('students.is_active', 'yes');
            $query = $this->db->get();
            
            if ($query->num_rows() > 0) {
                return $query->row_array();
            }
        }
        
        return false;
    }
    
    /**
     * Get school settings
     * 
     * @return array School settings
     */
    public function getSchoolSettings()
    {
        try {
            return $this->setting_model->get();
        } catch (Exception $e) {
            // Return default settings if there's an error
            return array(
                array(
                    'name' => 'School Name',
                    'address' => 'School Address',
                    'phone' => '',
                    'email' => 'school@example.com',
                    'image' => 'logo.png'
                )
            );
        }
    }
}
