<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Idcardgenerate extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library('media_storage');
        $this->load->library('Customlib');
        $this->load->model('idcard_model');
        $this->load->model('student_model');
        $this->load->model('class_model');
        $this->load->model('section_model');
        $this->load->model('setting_model');
    }

    public function index()
    {
        if (!$this->rbac->hasPrivilege('student_id_card', 'can_view')) {
            access_denied();
        }

        $this->session->set_userdata('top_menu', 'Certificate');
        $this->session->set_userdata('sub_menu', 'admin/idcardgenerate');

        $idcardlist = $this->idcard_model->idcardList();
        $data['idcardlist'] = $idcardlist;
        $class = $this->class_model->get();
        $data['classlist'] = $class;
        
        $this->load->view('layout/header');
        $this->load->view('admin/idcard/generateidcard', $data);
        $this->load->view('layout/footer');
    }

    public function search()
    {
        $this->session->set_userdata('top_menu', 'Certificate');
        $this->session->set_userdata('sub_menu', 'admin/idcardgenerate');
        
        $class_id = $this->input->post('class_id');
        $section_id = $this->input->post('section_id');
        $idcard_id = $this->input->post('idcard_id');
        
        // Debug information
        error_log('Search Method Called');
        error_log('Class ID: ' . $class_id);
        error_log('Section ID: ' . $section_id);
        error_log('ID Card ID: ' . $idcard_id);
        
        $data['class_id'] = $class_id;
        $data['section_id'] = $section_id;
        $data['idcard_id'] = $idcard_id;
        
        $class = $this->class_model->get();
        $data['classlist'] = $class;
        
        $idcardlist = $this->idcard_model->idcardList();
        $data['idcardlist'] = $idcardlist;
        
        // Check if all required fields are provided
        if (empty($class_id)) {
            $this->session->set_flashdata('msg', '<div class="alert alert-danger">Please select a class</div>');
            redirect('admin/idcardgenerate');
            return;
        }
        
        if (empty($idcard_id)) {
            $this->session->set_flashdata('msg', '<div class="alert alert-danger">Please select an ID card template</div>');
            redirect('admin/idcardgenerate');
            return;
        }
        
        // Get ID card template
        $idcardResult = $this->idcard_model->get($idcard_id);
        $data['idcardResult'] = $idcardResult;
        
        // Get students based on class and section (if provided)
        try {
            // Use the same method as working generateidcard controller
            $resultlist = $this->student_model->searchByClassSection($class_id, $section_id);
            
            // Convert array to objects for consistency
            if (!empty($resultlist)) {
                foreach ($resultlist as $key => $value) {
                    $resultlist[$key] = (object) $value;
                }
            }
            
            // Debug: Log the result count
            error_log('Found ' . count($resultlist) . ' students');
            
            // Remove complex image handling - generateidcard doesn't handle images in controller
            // Images are handled directly in the view/template when generating ID cards
            
            // Get section info if section_id is provided
            if (!empty($section_id)) {
                $section = $this->section_model->getClassNameBySection($class_id, $section_id);
                $data['section'] = $section;
            }
            
            // Log the SQL query for debugging
            error_log('SQL Query: ' . $this->db->last_query());
            
            // Format student data for display
            if (!empty($resultlist)) {
                foreach ($resultlist as $key => $value) {
                    $resultlist[$key]->dob = $this->customlib->dateformat($value->dob);
                }
            }
            
        } catch (Exception $e) {
            error_log('Error in database query: ' . $e->getMessage());
            $this->session->set_flashdata('msg', '<div class="alert alert-danger">Database error: ' . $e->getMessage() . '</div>');
            $resultlist = array();
        }
        
        // Debug student list
        error_log('Number of students found: ' . (is_array($resultlist) ? count($resultlist) : 'None'));
        
        $data['resultlist'] = $resultlist;
        $data['sch_setting'] = $this->setting_model->getSetting();
        
        if (empty($resultlist)) {
            $this->session->set_flashdata('msg', '<div class="alert alert-info">No students found for the selected criteria</div>');
        }
        
        $this->load->view('layout/header');
        $this->load->view('admin/idcard/generateidcard', $data);
        $this->load->view('layout/footer');
    }

    public function generate($student_id = null, $idcard_id = null)
    {
        try {
            // Debug input parameters
            error_log('Generate method called with student_id: ' . $student_id . ', idcard_id: ' . $idcard_id);
            
            // Validate inputs
            if (empty($idcard_id)) {
                error_log('ID Card template not selected');
                $this->session->set_flashdata('msg', '<div class="alert alert-danger">ID Card template not selected</div>');
                redirect('admin/idcardgenerate');
                return;
            }
            
            if (empty($student_id)) {
                error_log('No student selected');
                $this->session->set_flashdata('msg', '<div class="alert alert-danger">No student selected</div>');
                redirect('admin/idcardgenerate');
                return;
            }
            
            // Get ID card template
            $idcardResult = $this->idcard_model->get($idcard_id);
            
            if (empty($idcardResult)) {
                $this->session->set_flashdata('msg', '<div class="alert alert-danger">ID Card template not found</div>');
                redirect('admin/idcardgenerate');
                return;
            }
            
            // Convert the ID card template array to object for consistency
            $idcard = (object) $idcardResult[0];
            
            // Log ID card template data for debugging
            error_log('ID Card Template: ' . json_encode($idcard));
            
            // Get student data directly from database with detailed information
            $this->db->select('students.*, classes.class, sections.section, student_session.id as student_session_id');
            $this->db->from('students');
            $this->db->join('student_session', 'student_session.student_id = students.id');
            $this->db->join('classes', 'student_session.class_id = classes.id');
            $this->db->join('sections', 'student_session.section_id = sections.id');
            $this->db->where('students.id', $student_id);
            $this->db->where('students.is_active', 'yes');
            $query = $this->db->get();
            $student = $query->row();
            
            // Log the SQL query for debugging
            error_log('SQL Query: ' . $this->db->last_query());
            
            if (empty($student)) {
                $this->session->set_flashdata('msg', '<div class="alert alert-danger">Student not found</div>');
                redirect('admin/idcardgenerate');
                return;
            }
            
            // Log student data for debugging
            error_log('Student data: ' . json_encode($student));
            
            // Format dates
            $student->dob = $this->customlib->dateformat($student->dob);
            if (isset($student->admission_date)) {
                $student->admission_date = $this->customlib->dateformat($student->admission_date);
            }
            
            // Verify background image path
            $bg_image_path = '';
            if (!empty($idcard->background_image)) {
                $bg_image_path = base_url('uploads/idcard/') . $idcard->background_image;
                // Check if file exists
                $file_path = FCPATH . 'uploads/idcard/' . $idcard->background_image;
                if (!file_exists($file_path)) {
                    error_log('Background image file does not exist: ' . $file_path);
                } else {
                    error_log('Background image file exists: ' . $file_path);
                }
            }
            
            // Find student image using media_storage library
            $student_image = '';
            
            if (!empty($student->image)) {
                // Use media_storage to get proper image URL
                $student_image = $this->media_storage->getImageURL($student->image, 'uploads/student_images/');
                error_log("Student image from media_storage: " . $student_image);
            }
            
            // If no image or image doesn't exist, use gender-based default
            if (empty($student_image) || !@getimagesize($student_image)) {
                if (strtolower($student->gender) == 'female') {
                    $student_image = base_url('uploads/student_images/default_female.jpg');
                } else {
                    $student_image = base_url('uploads/student_images/default_male.jpg');
                }
                error_log("Using default image: " . $student_image);
            }
            
            $student->image_url = $student_image;
            
            // Ensure all size values are integers
            $idcard->card_width = isset($idcard->card_width) && is_numeric($idcard->card_width) ? (int)$idcard->card_width : 320;
            $idcard->card_height = isset($idcard->card_height) && is_numeric($idcard->card_height) ? (int)$idcard->card_height : 200;
            $idcard->header_height = isset($idcard->header_height) && is_numeric($idcard->header_height) ? (int)$idcard->header_height : 40;
            $idcard->content_height = isset($idcard->content_height) && is_numeric($idcard->content_height) ? (int)$idcard->content_height : 120;
            $idcard->content_width = isset($idcard->content_width) && is_numeric($idcard->content_width) ? (int)$idcard->content_width : 300;
            $idcard->footer_height = isset($idcard->footer_height) && is_numeric($idcard->footer_height) ? (int)$idcard->footer_height : 40;
            $idcard->enable_image_height = isset($idcard->enable_image_height) && is_numeric($idcard->enable_image_height) ? (int)$idcard->enable_image_height : 80;
            
            // Log the processed size values
            error_log('Processed ID Card Template Size Values (Single Card):');
            error_log('card_width: ' . $idcard->card_width);
            error_log('card_height: ' . $idcard->card_height);
            error_log('header_height: ' . $idcard->header_height);
            error_log('footer_height: ' . $idcard->footer_height);
            error_log('content_height: ' . $idcard->content_height);
            error_log('content_width: ' . $idcard->content_width);
            error_log('enable_image_height: ' . $idcard->enable_image_height);
            
            $data['idcard'] = $idcard;
            $data['student'] = $student;
            $data['sch_setting'] = $this->setting_model->getSetting();
            $data['bg_image_path'] = $bg_image_path;
            $data['student_image'] = $student_image;
            
            // Set headers for direct HTML output
            header('Content-Type: text/html; charset=utf-8');
            $this->load->view('admin/idcard/idcardpreview', $data);
            
        } catch (Exception $e) {
            error_log('Error in generate: ' . $e->getMessage());
            $this->session->set_flashdata('msg', '<div class="alert alert-danger">Error generating ID card: ' . $e->getMessage() . '</div>');
            redirect('admin/idcardgenerate');
        } catch (Error $e) {
            // Catch PHP 7+ errors
            error_log('PHP Error in generate: ' . $e->getMessage());
            $this->session->set_flashdata('msg', '<div class="alert alert-danger">PHP Error: ' . $e->getMessage() . '</div>');
            redirect('admin/idcardgenerate');
        }
    }

    public function generatemultiple()
    {
        // Enable error reporting for debugging
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ALL);
        
        try {
            // Validate form inputs
            $class_id = $this->input->post('class_id');
            $idcard_id = $this->input->post('idcard_id');
            $student_ids = $this->input->post('student_ids');
            
            // Debug information
            error_log('Generate Multiple ID Cards');
            error_log('Class ID: ' . $class_id);
            error_log('ID Card ID: ' . $idcard_id);
            error_log('Student IDs: ' . (is_array($student_ids) ? implode(',', $student_ids) : 'None'));
            
            // Validate required fields
            if (empty($class_id)) {
                $this->session->set_flashdata('msg', '<div class="alert alert-danger">Please select a class</div>');
                redirect('admin/idcardgenerate');
                return;
            }
            
            if (empty($idcard_id)) {
                $this->session->set_flashdata('msg', '<div class="alert alert-danger">Please select an ID card template</div>');
                redirect('admin/idcardgenerate');
                return;
            }
            
            if (empty($student_ids)) {
                $this->session->set_flashdata('msg', '<div class="alert alert-danger">No students selected</div>');
                redirect('admin/idcardgenerate');
                return;
            }
            
            // Get ID card template
            $idcardResult = $this->idcard_model->get($idcard_id);
            if (empty($idcardResult)) {
                $this->session->set_flashdata('msg', '<div class="alert alert-danger">ID Card template not found</div>');
                redirect('admin/idcardgenerate');
                return;
            }
            
            // Log ID card template data for debugging
            error_log('ID Card Template: ' . json_encode($idcardResult[0]));
            
            // Verify background image path
            $bg_image_path = '';
            if (!empty($idcardResult[0]->background_image)) {
                $bg_image_path = base_url('uploads/idcard/') . $idcardResult[0]->background_image;
                // Check if file exists
                $file_path = FCPATH . 'uploads/idcard/' . $idcardResult[0]->background_image;
                if (!file_exists($file_path)) {
                    error_log('Background image file does not exist: ' . $file_path);
                } else {
                    error_log('Background image file exists: ' . $file_path);
                }
            }
            
            // Get student data directly from database with all necessary fields
            $this->db->select('students.*, classes.class, sections.section, student_session.id as student_session_id');
            $this->db->from('students');
            $this->db->join('student_session', 'student_session.student_id = students.id');
            $this->db->join('classes', 'student_session.class_id = classes.id');
            $this->db->join('sections', 'student_session.section_id = sections.id');
            $this->db->where_in('students.id', $student_ids);
            $this->db->where('students.is_active', 'yes');
            $query = $this->db->get();
            $resultlist = $query->result();
            
            // Log the SQL query and results for debugging
            error_log('SQL Query: ' . $this->db->last_query());
            error_log('Number of students found: ' . count($resultlist));
            
            // Preload all student images in a single pass
            $this->db->select('id, image, admission_no');
            $this->db->from('students');
            $this->db->where_in('id', $student_ids);
            $images_query = $this->db->get();
            $student_images = [];
            
            foreach ($images_query->result() as $row) {
                $student_images[$row->id] = [
                    'image' => $row->image,
                    'admission_no' => $row->admission_no
                ];
            }
            
            // Initialize student_image_paths array
            $student_image_paths = [];
            
            // Format student data and prepare image paths
            if (!empty($resultlist)) {
                foreach ($resultlist as $key => $student) {
                    // Format dates
                    $resultlist[$key]->dob = $this->customlib->dateformat($student->dob);
                    if (isset($student->admission_date)) {
                        $resultlist[$key]->admission_date = $this->customlib->dateformat($student->admission_date);
                    }
                    
                    // Handle student image - debug database values
                    $student_image = '';
                    
                    // Debug: Log what's in the database
                    error_log("DEBUG - Student ID: {$student->id}, Image field: '" . ($student->image ?? 'NULL') . "'");
                    
                    if (!empty($student->image)) {
                        $image_path = $student->image;
                        
                        // Check if it's already a full path or just filename
                        if (strpos($image_path, 'uploads/') === 0) {
                            // Full path stored in database
                            $student_image = base_url($image_path);
                            $local_path = FCPATH . $image_path;
                        } else {
                            // Just filename stored
                            $student_image = base_url('uploads/student_images/' . $image_path);
                            $local_path = FCPATH . 'uploads/student_images/' . $image_path;
                        }
                        
                        // Verify file exists
                        if (!file_exists($local_path)) {
                            $student_image = '';
                        }
                    } else {
                        error_log("DEBUG - Student image field is empty");
                    }
                    
                    // If no image found, use gender-based default
                    if (empty($student_image)) {
                        if (strtolower($student->gender) == 'female') {
                            $student_image = base_url('uploads/student_images/default_female.jpg');
                        } else {
                            $student_image = base_url('uploads/student_images/default_male.jpg');
                        }
                    }
                    
                    $resultlist[$key]->image_url = $student_image;
                }
            }
            
            if (empty($resultlist)) {
                $this->session->set_flashdata('msg', '<div class="alert alert-danger">No valid students found</div>');
                redirect('admin/idcardgenerate');
                return;
            }
            
            $idcard = (object) $idcardResult[0];
            
            // Ensure all size values are integers
            $idcard->card_width = isset($idcard->card_width) && is_numeric($idcard->card_width) ? (int)$idcard->card_width : 320;
            $idcard->card_height = isset($idcard->card_height) && is_numeric($idcard->card_height) ? (int)$idcard->card_height : 200;
            $idcard->header_height = isset($idcard->header_height) && is_numeric($idcard->header_height) ? (int)$idcard->header_height : 40;
            $idcard->content_height = isset($idcard->content_height) && is_numeric($idcard->content_height) ? (int)$idcard->content_height : 120;
            $idcard->content_width = isset($idcard->content_width) && is_numeric($idcard->content_width) ? (int)$idcard->content_width : 300;
            $idcard->footer_height = isset($idcard->footer_height) && is_numeric($idcard->footer_height) ? (int)$idcard->footer_height : 40;
            $idcard->enable_image_height = isset($idcard->enable_image_height) && is_numeric($idcard->enable_image_height) ? (int)$idcard->enable_image_height : 80;
            
            // Log the processed size values
            error_log('Processed ID Card Template Size Values:');
            error_log('card_width: ' . $idcard->card_width);
            error_log('card_height: ' . $idcard->card_height);
            error_log('header_height: ' . $idcard->header_height);
            error_log('footer_height: ' . $idcard->footer_height);
            error_log('content_height: ' . $idcard->content_height);
            error_log('content_width: ' . $idcard->content_width);
            error_log('enable_image_height: ' . $idcard->enable_image_height);
            
            $data['idcard'] = $idcard;
            $data['resultlist'] = $resultlist;
            $data['sch_setting'] = $this->setting_model->getSetting();
            $data['bg_image_path'] = $bg_image_path;
            $data['student_image_paths'] = $student_image_paths;
            
            // Explicitly set size values in the data array to ensure they're available in the view
            $data['card_width'] = $idcard->card_width;
            $data['card_height'] = $idcard->card_height;
            $data['header_height'] = $idcard->header_height;
            $data['content_height'] = $idcard->content_height;
            $data['content_width'] = $idcard->content_width;
            $data['footer_height'] = $idcard->footer_height;
            $data['enable_image_height'] = $idcard->enable_image_height;
            
            // Log the data being sent to the view
            error_log('Data being sent to idcardpreviewmultiple view:');
            error_log('card_width: ' . $data['card_width']);
            error_log('card_height: ' . $data['card_height']);
            error_log('header_height: ' . $data['header_height']);
            error_log('content_height: ' . $data['content_height']);
            error_log('content_width: ' . $data['content_width']);
            error_log('footer_height: ' . $data['footer_height']);
            error_log('enable_image_height: ' . $data['enable_image_height']);
            
            // Set headers for direct HTML output
            header('Content-Type: text/html; charset=utf-8');
            $this->load->view('admin/idcard/idcardpreviewmultiple', $data);
            
        } catch (Error $e) {
            // Catch PHP 7+ errors
            error_log('PHP Error in generatemultiple: ' . $e->getMessage());
            $this->session->set_flashdata('msg', '<div class="alert alert-danger">PHP Error: ' . $e->getMessage() . '</div>');
            redirect('admin/idcardgenerate');
        }
    }
}
