<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Idcard extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();

        $this->load->library('media_storage');
        $this->load->library('Customlib');
        $this->load->model('idcard_model');
        $this->load->dbforge();
        
        // Check if id_card table exists, create if it doesn't
        $this->check_id_card_table();
        
        // Debug: Check if columns exist
        if ($this->db->table_exists('id_card')) {
            $fields = $this->db->field_data('id_card');
            error_log('Database fields in id_card table:');
            foreach ($fields as $field) {
                error_log('- ' . $field->name . ' (' . $field->type . ')' . ($field->primary_key ? ' PRIMARY KEY' : ''));
            }
        } else {
            error_log('id_card table does not exist!');
        }
    }
    
    /**
     * Check if id_card table exists and create it if it doesn't
     * Also checks for required columns and adds them if missing
     */
    private function check_id_card_table()
    {
        error_log('Checking id_card table...');
        
        // Check if the table exists
        if (!$this->db->table_exists('id_card')) {
            error_log('id_card table does not exist, creating it...');
            // Table doesn't exist, create it
            
            $fields = array(
                'id' => array(
                    'type' => 'INT',
                    'constraint' => 11,
                    'unsigned' => TRUE,
                    'auto_increment' => TRUE
                ),
                'idcard_name' => array(
                    'type' => 'VARCHAR',
                    'constraint' => '100',
                    'null' => FALSE,
                ),
                'idcard_text' => array(
                    'type' => 'TEXT',
                    'null' => TRUE,
                ),
                'left_header' => array(
                    'type' => 'VARCHAR',
                    'constraint' => '100',
                    'null' => TRUE,
                ),
                'center_header' => array(
                    'type' => 'VARCHAR',
                    'constraint' => '100',
                    'null' => TRUE,
                ),
                'right_header' => array(
                    'type' => 'VARCHAR',
                    'constraint' => '100',
                    'null' => TRUE,
                ),
                'left_footer' => array(
                    'type' => 'VARCHAR',
                    'constraint' => '100',
                    'null' => TRUE,
                ),
                'center_footer' => array(
                    'type' => 'VARCHAR',
                    'constraint' => '100',
                    'null' => TRUE,
                ),
                'right_footer' => array(
                    'type' => 'VARCHAR',
                    'constraint' => '100',
                    'null' => TRUE,
                ),
                'created_for' => array(
                    'type' => 'INT',
                    'constraint' => 11,
                    'default' => 2,
                ),
                'status' => array(
                    'type' => 'INT',
                    'constraint' => 11,
                    'default' => 1,
                ),
                'background_image' => array(
                    'type' => 'VARCHAR',
                    'constraint' => '255',
                    'null' => TRUE,
                ),
                'header_height' => array(
                    'type' => 'VARCHAR',
                    'constraint' => '50',
                    'null' => TRUE,
                ),
                'content_height' => array(
                    'type' => 'VARCHAR',
                    'constraint' => '50',
                    'null' => TRUE,
                ),
                'footer_height' => array(
                    'type' => 'VARCHAR',
                    'constraint' => '50',
                    'null' => TRUE,
                ),
                'content_width' => array(
                    'type' => 'VARCHAR',
                    'constraint' => '50',
                    'null' => TRUE,
                ),
                'enable_student_image' => array(
                    'type' => 'INT',
                    'constraint' => 1,
                    'default' => 0,
                ),
                'enable_image_height' => array(
                    'type' => 'VARCHAR',
                    'constraint' => '50',
                    'null' => TRUE,
                ),
                'cards_per_page' => array(
                    'type' => 'INT',
                    'constraint' => 11,
                    'default' => 1,
                ),
                'card_width' => array(
                    'type' => 'VARCHAR',
                    'constraint' => '50',
                    'null' => TRUE,
                ),
                'card_height' => array(
                    'type' => 'VARCHAR',
                    'constraint' => '50',
                    'null' => TRUE,
                ),
            );
            
            $this->dbforge->add_field($fields);
            $this->dbforge->add_key('id', TRUE);
            $this->dbforge->create_table('id_card', TRUE);
            
            error_log('Created id_card table');
        } else {
            // Table exists, check if required columns exist
            $fields = array();
            $existing_fields = $this->db->list_fields('id_card');
            
            // Check for each required field and add it if missing
            if (!in_array('idcard_name', $existing_fields)) {
                $fields['idcard_name'] = array('type' => 'VARCHAR', 'constraint' => '100', 'null' => FALSE);
                error_log('Adding missing column: idcard_name');
            }
            
            if (!in_array('idcard_text', $existing_fields)) {
                $fields['idcard_text'] = array('type' => 'TEXT', 'null' => TRUE);
                error_log('Adding missing column: idcard_text');
            }
            
            if (!in_array('created_for', $existing_fields)) {
                $fields['created_for'] = array('type' => 'INT', 'constraint' => 11, 'default' => 2);
                error_log('Adding missing column: created_for');
            }
            
            if (!in_array('status', $existing_fields)) {
                $fields['status'] = array('type' => 'INT', 'constraint' => 11, 'default' => 1);
                error_log('Adding missing column: status');
            }
            
            if (!in_array('header_height', $existing_fields)) {
                $fields['header_height'] = array('type' => 'VARCHAR', 'constraint' => '50', 'null' => TRUE);
                error_log('Adding missing column: header_height');
            }
            
            if (!in_array('content_height', $existing_fields)) {
                $fields['content_height'] = array('type' => 'VARCHAR', 'constraint' => '50', 'null' => TRUE);
                error_log('Adding missing column: content_height');
            }
            
            if (!in_array('footer_height', $existing_fields)) {
                $fields['footer_height'] = array('type' => 'VARCHAR', 'constraint' => '50', 'null' => TRUE);
                error_log('Adding missing column: footer_height');
            }
            
            if (!in_array('content_width', $existing_fields)) {
                $fields['content_width'] = array('type' => 'VARCHAR', 'constraint' => '50', 'null' => TRUE);
                error_log('Adding missing column: content_width');
            }
            
            if (!in_array('enable_student_image', $existing_fields)) {
                $fields['enable_student_image'] = array('type' => 'INT', 'constraint' => 1, 'default' => 0);
                error_log('Adding missing column: enable_student_image');
            }
            
            if (!in_array('enable_image_height', $existing_fields)) {
                $fields['enable_image_height'] = array('type' => 'VARCHAR', 'constraint' => '50', 'null' => TRUE);
                error_log('Adding missing column: enable_image_height');
            }
            
            if (!in_array('cards_per_page', $existing_fields)) {
                $fields['cards_per_page'] = array('type' => 'INT', 'constraint' => 11, 'default' => 1);
                error_log('Adding missing column: cards_per_page');
            }
            
            if (!in_array('background_image', $existing_fields)) {
                $fields['background_image'] = array('type' => 'VARCHAR', 'constraint' => '255', 'null' => TRUE);
                error_log('Adding missing column: background_image');
            }
            
            if (!in_array('left_header', $existing_fields)) {
                $fields['left_header'] = array('type' => 'VARCHAR', 'constraint' => '100', 'null' => TRUE);
                error_log('Adding missing column: left_header');
            }
            
            if (!in_array('center_header', $existing_fields)) {
                $fields['center_header'] = array('type' => 'VARCHAR', 'constraint' => '100', 'null' => TRUE);
                error_log('Adding missing column: center_header');
            }
            
            if (!in_array('right_header', $existing_fields)) {
                $fields['right_header'] = array('type' => 'VARCHAR', 'constraint' => '100', 'null' => TRUE);
                error_log('Adding missing column: right_header');
            }
            
            if (!in_array('left_footer', $existing_fields)) {
                $fields['left_footer'] = array('type' => 'VARCHAR', 'constraint' => '100', 'null' => TRUE);
                error_log('Adding missing column: left_footer');
            }
            
            if (!in_array('center_footer', $existing_fields)) {
                $fields['center_footer'] = array('type' => 'VARCHAR', 'constraint' => '100', 'null' => TRUE);
                error_log('Adding missing column: center_footer');
            }
            
            if (!in_array('right_footer', $existing_fields)) {
                $fields['right_footer'] = array('type' => 'VARCHAR', 'constraint' => '100', 'null' => TRUE);
                error_log('Adding missing column: right_footer');
            }
            
            if (!in_array('card_width', $existing_fields)) {
                $fields['card_width'] = array('type' => 'VARCHAR', 'constraint' => '50', 'null' => TRUE);
                error_log('Adding missing column: card_width');
            }
            
            if (!in_array('card_height', $existing_fields)) {
                $fields['card_height'] = array('type' => 'VARCHAR', 'constraint' => '50', 'null' => TRUE);
                error_log('Adding missing column: card_height');
            }
            
            if (!in_array('image_width', $existing_fields)) {
                $fields['image_width'] = array('type' => 'VARCHAR', 'constraint' => '50', 'null' => TRUE);
                error_log('Adding missing column: image_width');
            }
            
            if (!in_array('image_position', $existing_fields)) {
                $fields['image_position'] = array('type' => 'VARCHAR', 'constraint' => '50', 'null' => TRUE, 'default' => 'top-left');
                error_log('Adding missing column: image_position');
            }
            
            if (!in_array('image_top', $existing_fields)) {
                $fields['image_top'] = array('type' => 'VARCHAR', 'constraint' => '50', 'null' => TRUE, 'default' => '20');
                error_log('Adding missing column: image_top');
            }
            
            if (!in_array('image_side', $existing_fields)) {
                $fields['image_side'] = array('type' => 'VARCHAR', 'constraint' => '50', 'null' => TRUE, 'default' => '20');
                error_log('Adding missing column: image_side');
            }
            
            // Add QR code related columns
            if (!in_array('enable_qr_code', $existing_fields)) {
                $fields['enable_qr_code'] = array('type' => 'INT', 'constraint' => 1, 'default' => 0);
                error_log('Adding missing column: enable_qr_code');
            }
            
            if (!in_array('qr_size', $existing_fields)) {
                $fields['qr_size'] = array('type' => 'VARCHAR', 'constraint' => '50', 'null' => TRUE, 'default' => '100');
                error_log('Adding missing column: qr_size');
            }
            
            if (!in_array('qr_position', $existing_fields)) {
                $fields['qr_position'] = array('type' => 'VARCHAR', 'constraint' => '50', 'null' => TRUE, 'default' => 'top-left');
                error_log('Adding missing column: qr_position');
            }
            
            if (!in_array('qr_top', $existing_fields)) {
                $fields['qr_top'] = array('type' => 'VARCHAR', 'constraint' => '50', 'null' => TRUE, 'default' => '20');
                error_log('Adding missing column: qr_top');
            }
            
            if (!in_array('qr_side', $existing_fields)) {
                $fields['qr_side'] = array('type' => 'VARCHAR', 'constraint' => '50', 'null' => TRUE, 'default' => '20');
                error_log('Adding missing column: qr_side');
            }
            
            // Add any missing fields to the table
            if (!empty($fields)) {
                $this->dbforge->add_column('id_card', $fields);
                error_log('Added missing columns to id_card table');
            }
        }
    }

    public function index()
    {
        if (!$this->rbac->hasPrivilege('student_id_card', 'can_view')) {
            access_denied();
        }

        $this->session->set_userdata('top_menu', 'Certificate');
        $this->session->set_userdata('sub_menu', 'admin/idcard');
        
        // Get all student table fields
        $student_fields = $this->db->list_fields('students');
        $this->data['student_fields'] = array_filter($student_fields, function($field) {
            // Exclude sensitive or unnecessary fields
            $exclude_fields = ['id', 'password', 'sibling_id', 'parent_id', 'is_active', 'created_at', 'updated_at', 'app_key', 'parent_app_key', 'disable_at'];
            return !in_array($field, $exclude_fields);
        });
        
        // Get all custom fields
        $this->load->model('customfield_model');
        $this->data['custom_fields'] = $this->customfield_model->get_custom_fields('students');

        // Simplify validation rules to isolate the issue
        $this->form_validation->set_rules('idcard_name', $this->lang->line('id_card_name'), 'trim|required');
        $this->form_validation->set_rules('idcard_text', $this->lang->line('id_card_text'), 'trim|required');
        // Temporarily disable image validation to test if that's causing issues
        // $this->form_validation->set_rules('background_image', $this->lang->line('image'), 'callback_handle_upload');

        if ($this->form_validation->run() == false) {
            // Check if there were validation errors
            if ($this->input->post()) {
                $error = $this->form_validation->error_array();
                $this->session->set_flashdata('msg', '<div class="alert alert-danger text-left">Validation Error: ' . implode(', ', $error) . '</div>');
            }
            
            $this->data['idcardList'] = $this->idcard_model->idcardList();
            $this->load->view('layout/header');
            $this->load->view('admin/idcard/createidcard', $this->data);
            $this->load->view('layout/footer');
        } else {
            // Simplify the data collection to isolate the issue
            $enableimg = ($this->input->post('is_active_student_img') == 1) ? 1 : 0;
            $imgHeight = ($enableimg == 1) ? $this->input->post('image_height') : 0;
            
            // Check if uploads directory exists and is writable
            $upload_dir = "./uploads/idcard/";
            if (!file_exists($upload_dir)) {
                mkdir($upload_dir, 0777, true);
            }
            
            // Handle file upload with better error checking
            $picture = '';
            if (isset($_FILES["background_image"]) && !empty($_FILES['background_image']['name'])) {
                // Debug file upload information
                error_log('Uploading background image: ' . $_FILES['background_image']['name']);
                error_log('File size: ' . $_FILES['background_image']['size'] . ' bytes');
                error_log('File type: ' . $_FILES['background_image']['type']);
                error_log('Upload directory: ' . $upload_dir);
                
                // Check if directory exists and is writable
                if (!is_dir($upload_dir)) {
                    error_log('Creating upload directory: ' . $upload_dir);
                    mkdir($upload_dir, 0777, true);
                }
                
                if (!is_writable($upload_dir)) {
                    error_log('Upload directory is not writable: ' . $upload_dir);
                    chmod($upload_dir, 0777);
                }
                
                try {
                    // Direct file upload implementation to bypass media_storage library
                    $temp_name = $_FILES['background_image']['tmp_name'];
                    $name = $_FILES['background_image']['name'];
                    $file_name = time() . "-" . uniqid(rand()) . "!" . $name;
                    $destination = FCPATH . 'uploads/idcard/' . $file_name;
                    
                    error_log('Moving uploaded file to: ' . $destination);
                    
                    if (move_uploaded_file($temp_name, $destination)) {
                        error_log('File uploaded successfully: ' . $file_name);
                        $picture = $file_name;
                    } else {
                        error_log('Failed to move uploaded file. PHP error: ' . error_get_last()['message']);
                    }
                } catch (Exception $e) {
                    error_log('File upload error: ' . $e->getMessage());
                    $this->session->set_flashdata('msg', '<div class="alert alert-danger text-left">File upload error: ' . $e->getMessage() . '</div>');
                    redirect('admin/idcard/index', 'refresh');
                    return;
                }
            }

            // Create a minimal data array first to test basic insertion
            $data = array(
                'idcard_name'          => $this->input->post('idcard_name'),
                'idcard_text'          => $this->input->post('idcard_text', false),
                'created_for'          => 2,
                'status'               => 1
            );
            
            // Add optional fields only if they have values
            if (!empty($this->input->post('left_header'))) $data['left_header'] = $this->input->post('left_header');
            if (!empty($this->input->post('center_header'))) $data['center_header'] = $this->input->post('center_header');
            if (!empty($this->input->post('right_header'))) $data['right_header'] = $this->input->post('right_header');
            if (!empty($this->input->post('left_footer'))) $data['left_footer'] = $this->input->post('left_footer');
            if (!empty($this->input->post('right_footer'))) $data['right_footer'] = $this->input->post('right_footer');
            if (!empty($this->input->post('center_footer'))) $data['center_footer'] = $this->input->post('center_footer');
            if (!empty($picture)) $data['background_image'] = $picture;
            if (!empty($this->input->post('header_height'))) $data['header_height'] = $this->input->post('header_height');
            if (!empty($this->input->post('content_height'))) $data['content_height'] = $this->input->post('content_height');
            if (!empty($this->input->post('footer_height'))) $data['footer_height'] = $this->input->post('footer_height');
            if (!empty($this->input->post('content_width'))) $data['content_width'] = $this->input->post('content_width');
            $data['enable_student_image'] = $enableimg;
            $data['enable_image_height'] = $imgHeight;
            if (!empty($this->input->post('cards_per_page'))) $data['cards_per_page'] = $this->input->post('cards_per_page');
if (!empty($this->input->post('card_width'))) $data['card_width'] = $this->input->post('card_width');
            if (!empty($this->input->post('card_height'))) $data['card_height'] = $this->input->post('card_height');
            if (!empty($this->input->post('image_width'))) $data['image_width'] = $this->input->post('image_width');
            if (!empty($this->input->post('image_position'))) $data['image_position'] = $this->input->post('image_position');
            if (!empty($this->input->post('image_top'))) $data['image_top'] = $this->input->post('image_top');
            if (!empty($this->input->post('image_side'))) $data['image_side'] = $this->input->post('image_side');
            
            // Handle QR code settings
            $enableQr = ($this->input->post('enable_qr_code') == 1) ? 1 : 0;
            $data['enable_qr_code'] = $enableQr;
            if ($enableQr == 1) {
                if (!empty($this->input->post('qr_size'))) $data['qr_size'] = $this->input->post('qr_size');
                if (!empty($this->input->post('qr_position'))) $data['qr_position'] = $this->input->post('qr_position');
                if (!empty($this->input->post('qr_top'))) $data['qr_top'] = $this->input->post('qr_top');
                if (!empty($this->input->post('qr_side'))) $data['qr_side'] = $this->input->post('qr_side');
            }

            // Make sure the table exists before trying to insert
            $this->check_id_card_table();
            
            // Enable database error reporting
            $this->db->db_debug = TRUE;
            
            try {
                // Use the model to insert data
                $insert_id = $this->idcard_model->addidcard($data);
                
                if ($insert_id) {
                    // Success - record was inserted
                    $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('success_message') . '</div>');
                } else {
                    // No insert ID but no error thrown
                    $db_error = $this->db->error();
                    error_log('Database error: ' . print_r($db_error, true));
                    $error_msg = 'Error Code: ' . $db_error['code'] . ', Message: ' . $db_error['message'];
                    $this->session->set_flashdata('msg', '<div class="alert alert-danger text-left">Error saving ID card template. Please check the database connection.</div>');
                }
            } catch (Exception $e) {
                // Exception was thrown
                error_log('Exception: ' . $e->getMessage());
                $this->session->set_flashdata('msg', '<div class="alert alert-danger text-left">Exception: ' . $e->getMessage() . '</div>');
            }
            
            redirect('admin/idcard/index', 'refresh');
        }
    }

    public function edit($id)
    {
        if (!$this->rbac->hasPrivilege('student_id_card', 'can_edit')) {
            access_denied();
        }
        
        // Get the ID card data
        $editidcard_array = $this->idcard_model->get($id);
        
        if (empty($editidcard_array)) {
            $this->session->set_flashdata('msg', '<div class="alert alert-danger">ID Card not found</div>');
            redirect('admin/idcard');
        }
        
        // Convert array to object for easier view usage
        $editidcard = (object) $editidcard_array[0];
        
        $data = array(
            'title' => 'Edit ID Card',
            'id' => $id,
            'editidcard' => $editidcard,
            'student_fields' => ['admission_no', 'roll_no', 'firstname', 'lastname', 'dob', 'gender', 'class', 'section', 'father_name', 'mother_name', 'guardian_name', 'present_address', 'permanent_address', 'mobileno', 'email', 'admission_date'],
            'custom_fields' => $this->customfield_model->get_custom_fields('students')
        );

        $this->form_validation->set_rules('idcard_name', $this->lang->line('id_card_name'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('idcard_text', $this->lang->line('id_card_text'), 'trim|required');
        $this->form_validation->set_rules('background_image', $this->lang->line('image'), 'callback_handle_upload');

        if ($this->form_validation->run() == false) {
            $this->load->view('layout/header');
            $this->load->view('admin/idcard/studentidcardedit', $data);
            $this->load->view('layout/footer');
        } else {
            if ($this->input->post('is_active_student_img') == 1) {
                $enableimg = $this->input->post('is_active_student_img');
                $imgHeight = $this->input->post('image_height');
            } else {
                $enableimg = 0;
                $imgHeight = 0;
            }

            $data = array(
                'id'                   => $this->input->post('id'),
                'idcard_name'          => $this->input->post('idcard_name'),
                'idcard_text'          => $this->input->post('idcard_text', false),
                'left_header'          => $this->input->post('left_header'),
                'center_header'        => $this->input->post('center_header'),
                'right_header'         => $this->input->post('right_header'),
                'left_footer'          => $this->input->post('left_footer'),
                'right_footer'         => $this->input->post('right_footer'),
                'center_footer'        => $this->input->post('center_footer'),
                'header_height'        => $this->input->post('header_height'),
                'content_height'       => $this->input->post('content_height'),
                'footer_height'        => $this->input->post('footer_height'),
                'content_width'        => $this->input->post('content_width'),
                'enable_student_image' => $enableimg,
                'enable_image_height'  => $imgHeight,
                'cards_per_page'       => $this->input->post('cards_per_page'),
                'card_width'           => $this->input->post('card_width'),
                'card_height'          => $this->input->post('card_height'),
                'image_width'          => $this->input->post('image_width'),
                'image_position'       => $this->input->post('image_position'),
                'image_top'            => $this->input->post('image_top'),
                'image_side'           => $this->input->post('image_side'),
                'enable_qr_code'       => ($this->input->post('enable_qr_code') == 1) ? 1 : 0,
                'qr_size'              => $this->input->post('qr_size'),
                'qr_position'          => $this->input->post('qr_position'),
                'qr_top'               => $this->input->post('qr_top'),
                'qr_side'              => $this->input->post('qr_side'),
            );

            if (!empty($_FILES['background_image']['name'])) {
                // Debug file upload information
                error_log('Editing ID card - Uploading background image: ' . $_FILES['background_image']['name']);
                error_log('File size: ' . $_FILES['background_image']['size'] . ' bytes');
                error_log('File type: ' . $_FILES['background_image']['type']);
                
                $upload_dir = "./uploads/idcard/";
                
                // Check if directory exists and is writable
                if (!is_dir($upload_dir)) {
                    error_log('Creating upload directory: ' . $upload_dir);
                    mkdir($upload_dir, 0777, true);
                }
                
                if (!is_writable($upload_dir)) {
                    error_log('Upload directory is not writable: ' . $upload_dir);
                    chmod($upload_dir, 0777);
                }
                
                // Direct file upload implementation to bypass media_storage library
                $temp_name = $_FILES['background_image']['tmp_name'];
                $name = $_FILES['background_image']['name'];
                $file_name = time() . "-" . uniqid(rand()) . "!" . $name;
                $destination = FCPATH . 'uploads/idcard/' . $file_name;
                
                error_log('Moving uploaded file to: ' . $destination);
                
                if (move_uploaded_file($temp_name, $destination)) {
                    error_log('File uploaded successfully: ' . $file_name);
                    
                    $data['created_for']      = 2;
                    $data['status']           = 1;
                    $data['background_image'] = $file_name;
                    
                    // Delete old image if exists
                    if ($editidcard[0]->background_image != '') {
                        $old_file_path = FCPATH . 'uploads/idcard/' . $editidcard[0]->background_image;
                        if (file_exists($old_file_path)) {
                            unlink($old_file_path);
                            error_log('Deleted old background image: ' . $old_file_path);
                        }
                    }
                } else {
                    error_log('Failed to move uploaded file. PHP error: ' . error_get_last()['message']);
                    $this->session->set_flashdata('msg', '<div class="alert alert-danger text-left">Failed to upload background image</div>');
                }
            }

            $removebackground_image = $this->input->post('removebackground_image');

            if ($removebackground_image != '') {
                $data['background_image'] = '';
            }

            // Save the ID card (addidcard handles both insert and update)
            $this->idcard_model->addidcard($data);
            
            // Set success message
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('update_message') . '</div>');
            
            // Redirect to the index page
            redirect('admin/idcard');
        }
    } 

    public function delete($id)
    {
        if (!$this->rbac->hasPrivilege('student_id_card', 'can_delete')) {
            access_denied();
        }
        $this->idcard_model->remove($id);
        redirect('admin/idcard/index');
    }

    public function view()
    {
        $id     = $this->input->post('idcardid');
        $output = '';
        $data   = array();

        $idcard = $this->idcard_model->idcardbyid($id);
        
        // Create sample student data for preview
        $sample_data = array(
            'name' => 'John Doe',
            'dob' => '01/01/2010',
            'present_address' => '123 Main Street, City',
            'guardian' => 'Jane Doe',
            'created_at' => date('Y-m-d'),
            'admission_no' => 'ADM001',
            'roll_no' => '101',
            'class' => 'Class X',
            'section' => 'A',
            'gender' => 'Male',
            'admission_date' => date('Y-m-d'),
            'category' => 'General',
            'cast' => 'N/A',
            'father_name' => 'Robert Doe',
            'mother_name' => 'Jane Doe',
            'religion' => 'N/A',
            'email' => 'student@example.com',
            'phone' => '1234567890'
        );
        
        // Replace placeholders in the template text
        if (!empty($idcard->idcard_text)) {
            $text = $idcard->idcard_text;
            foreach ($sample_data as $key => $value) {
                $text = str_replace('[' . $key . ']', $value, $text);
            }
            $idcard->idcard_text = $text;
        }
        
        $data['idcard'] = $idcard;
        $preview = $this->load->view('admin/idcard/preview_idcard', $data, true);
        echo $preview;
    }

    public function getidcards()
    {
        // Check for AJAX request
        if (!$this->input->is_ajax_request()) {
            redirect('admin/idcard');
        }
        
        // Get all ID cards
        $idcards = $this->idcard_model->idcardList();
        
        $data = array();
        foreach ($idcards as $idcard) {
            $actions = '<div class="btn-group">';            
            if ($this->rbac->hasPrivilege('student_id_card', 'can_edit')) {
                $actions .= '<a href="' . site_url('admin/idcard/edit/' . $idcard->id) . '" class="btn btn-default btn-xs" data-toggle="tooltip" title="' . $this->lang->line('edit') . '"><i class="fa fa-pencil"></i></a>';
            }
            if ($this->rbac->hasPrivilege('student_id_card', 'can_delete')) {
                $actions .= '<a href="' . site_url('admin/idcard/delete/' . $idcard->id) . '" class="btn btn-default btn-xs" data-toggle="tooltip" title="' . $this->lang->line('delete') . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-remove"></i></a>';
            }
            $actions .= '<a href="#" class="btn btn-default btn-xs" data-toggle="tooltip" title="' . $this->lang->line('view') . '" onclick="view(' . $idcard->id . ');"><i class="fa fa-reorder"></i></a>';
            $actions .= '</div>';
            
            $data[] = array(
                'name' => $idcard->idcard_name,
                'actions' => $actions
            );
        }
        
        echo json_encode(array('data' => $data));
        exit;
    }
    
    public function handle_upload()
    {
        if (isset($_FILES["background_image"]) && !empty($_FILES['background_image']['name'])) {
            $allowedExts = array('jpg', 'jpeg', 'png', 'gif');
            $temp        = explode(".", $_FILES["background_image"]["name"]);
            $extension   = end($temp);
            $error = "";
            if ($_FILES["background_image"]["error"] > 0) {
                $error .= "Error opening the file<br />";
            }
            if (($_FILES["background_image"]["type"] != "image/gif") && ($_FILES["background_image"]["type"] != "image/jpeg") && ($_FILES["background_image"]["type"] != "image/jpg") && ($_FILES["background_image"]["type"] != "image/png")) {
                $this->form_validation->set_message('handle_upload', $this->lang->line('file_type_not_allowed'));
                return false;
            }
            if (!in_array(strtolower($extension), $allowedExts)) {
                $this->form_validation->set_message('handle_upload', $this->lang->line('file_extension_not_allowed'));
                return false;
            }
            return true;
        } else {
            return true;
        }
    }
}
