<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Generatecertificate extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();

        $this->load->library('Customlib');
        $this->sch_setting_detail = $this->setting_model->getSetting();
            $this->load->library('media_storage');
    }

    public function index()
    {
        if (!$this->rbac->hasPrivilege('generate_certificate', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Certificate');
        $this->session->set_userdata('sub_menu', 'admin/generatecertificate');

        $certificateList         = $this->Certificate_model->getstudentcertificate();
        $data['certificateList'] = $certificateList;
        $class                   = $this->class_model->get();
        $data['classlist']       = $class;
        $this->load->view('layout/header', $data);
        $this->load->view('admin/certificate/generatecertificate', $data);
        $this->load->view('layout/footer', $data);
    }

    public function search()
    {
        $this->session->set_userdata('top_menu', 'Certificate');
        $this->session->set_userdata('sub_menu', 'admin/generatecertificate');

        $class                   = $this->class_model->get();
        $data['classlist']       = $class;
        $certificateList         = $this->Certificate_model->getstudentcertificate();
        $data['certificateList'] = $certificateList;
        $button                  = $this->input->post('search');
        if ($this->input->server('REQUEST_METHOD') == "GET") {
            $this->load->view('layout/header', $data);
            $this->load->view('admin/certificate/generatecertificate', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $class       = $this->input->post('class_id');
            $section     = $this->input->post('section_id');
            $search      = $this->input->post('search');
            $certificate = $this->input->post('certificate_id');
            if (isset($search)) {
                $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');
                $this->form_validation->set_rules('certificate_id', $this->lang->line('certificate'), 'trim|required|xss_clean');
                if ($this->form_validation->run() == false) {

                } else {
                    $data['searchby']          = "filter";
                    $data['class_id']          = $this->input->post('class_id');
                    $data['section_id']        = $this->input->post('section_id');
                    $certificate               = $this->input->post('certificate_id');
                    $certificateResult         = $this->Generatecertificate_model->getcertificatebyid($certificate);
                    $data['certificateResult'] = $certificateResult;
                    $resultlist                = $this->student_model->searchByClassSection($class, $section);
                    $data['resultlist']        = $resultlist;
                    $title                     = $this->classsection_model->getDetailbyClassSection($data['class_id'], $data['section_id']);
                    // $data['title']             = $this->lang->line('std_dtl_for') . ' ' . $title['class'] . "(" . $title['section'] . ")";
                }
            }
            $data['sch_setting'] = $this->sch_setting_detail;
            $this->load->view('layout/header', $data);
            $this->load->view('admin/certificate/generatecertificate', $data);
            $this->load->view('layout/footer', $data);
        }
    }

    public function generate($student, $class, $certificate)
    {
        $certificateResult         = $this->Generatecertificate_model->getcertificatebyid($certificate);
        $data['certificateResult'] = $certificateResult;
        $resultlist                = $this->student_model->searchByClassStudent($class, $student);
        $data['resultlist']        = $resultlist;
        
        // Log individual certificate generation
        if (!empty($resultlist)) {
            $student_data = $resultlist[0];
            $section_id = isset($student_data['section_id']) ? $student_data['section_id'] : null;
            $student_name = $this->customlib->getFullName($student_data['firstname'], $student_data['middlename'], $student_data['lastname'], $this->sch_setting_detail->middlename, $this->sch_setting_detail->lastname);
            
            $log_data = array(
                'certificate_id' => $certificate,
                'student_id' => $student,
                'class_id' => $class,
                'section_id' => $section_id,
                'admission_no' => $student_data['admission_no'],
                'student_name' => $student_name,
                'certificate_name' => $certificateResult[0]->certificate_name,
                'generated_by' => $this->customlib->getStaffID(),
                'created_at' => date('Y-m-d H:i:s')
            );
            
            $this->load->model('certificate_log_model');
            $this->certificate_log_model->add($log_data);
        }

        $this->load->view('admin/certificate/transfercertificate', $data);
    }

    public function generatemultiple()
    {
        $studentid           = $this->input->post('data');
        $student_array       = json_decode($studentid);
        $certificate_id      = $this->input->post('certificate_id');
        $class               = $this->input->post('class_id');
        $data                = array();
        $results             = array();
        $std_arr             = array();
        $data['sch_setting'] = $this->setting_model->get();
        $data['certificate'] = $this->Generatecertificate_model->getcertificatebyid($certificate_id);

        foreach ($student_array as $key => $value) {
            $std_arr[] = $value->student_id;
        }
        $data['students'] = $this->student_model->getStudentsByArray($std_arr);
        
        // Load certificate log model
        $this->load->model('certificate_log_model');
        
        foreach ($data['students'] as $key => $value) {
            // Set student name
            $data['students'][$key]->name = $this->customlib->getFullName($value->firstname, $value->middlename, $value->lastname, $this->sch_setting_detail->middlename, $this->sch_setting_detail->lastname);
            
            // Log certificate generation for each student
            $log_data = array(
                'certificate_id' => $certificate_id,
                'student_id' => $value->id,
                'class_id' => $class,
                'section_id' => $value->section_id,
                'admission_no' => $value->admission_no,
                'student_name' => $data['students'][$key]->name,
                'certificate_name' => $data['certificate'][0]->certificate_name,
                'generated_by' => $this->customlib->getStaffID(),
                'created_at' => date('Y-m-d H:i:s')
            );
            
            $this->certificate_log_model->add($log_data);
        }

        $data['sch_setting'] = $this->sch_setting_detail;
        $certificates        = $this->load->view('admin/certificate/printcertificate', $data, true);
        echo $certificates;
    }

}
