<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Certificatelogs extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('certificate_log_model');
        $this->load->model('certificate_model');
        $this->load->model('class_model');
        $this->load->model('section_model');
        $this->load->model('staff_model');
        $this->load->model('student_model');
        $this->load->library('pagination');
        $this->load->library('customlib');
        $this->sch_setting_detail = $this->setting_model->getSetting();
    }

    /**
     * Default method - shows certificate logs
     */
    public function index()
    {
        // Use existing permissions for certificate viewing
        if (!$this->rbac->hasPrivilege('student_certificate', 'can_view') && 
            !$this->rbac->hasPrivilege('generate_certificate', 'can_view')) {
            access_denied();
        }
        
        $this->session->set_userdata('top_menu', 'Certificate');
        $this->session->set_userdata('sub_menu', 'admin/certificatelogs/index');
        
        $data = array();
        $data['title'] = 'Certificate Logs';
        
        // Get pagination parameters
        $config['base_url'] = base_url() . 'admin/certificatelogs/index';
        $config['total_rows'] = $this->certificate_log_model->getCount();
        $config['per_page'] = 25;
        $config['uri_segment'] = 4;
        $config['full_tag_open'] = '<div class="pagination"><ul>';
        $config['full_tag_close'] = '</ul></div>';
        $config['first_link'] = '&laquo; First';
        $config['first_tag_open'] = '<li class="prev page">';
        $config['first_tag_close'] = '</li>';
        $config['last_link'] = 'Last &raquo;';
        $config['last_tag_open'] = '<li class="next page">';
        $config['last_tag_close'] = '</li>';
        $config['next_link'] = 'Next &rarr;';
        $config['next_tag_open'] = '<li class="next page">';
        $config['next_tag_close'] = '</li>';
        $config['prev_link'] = '&larr; Previous';
        $config['prev_tag_open'] = '<li class="prev page">';
        $config['prev_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="active"><a href="">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li class="page">';
        $config['num_tag_close'] = '</li>';
        
        $this->pagination->initialize($config);
        
        $page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
        
        $data['logs'] = $this->certificate_log_model->getAll($config['per_page'], $page);
        $data['pagination'] = $this->pagination->create_links();
        
        // Get certificates for filter
        $data['certificates'] = $this->certificate_model->certificateList();
        
        // Get classes for filter
        $data['classlist'] = $this->class_model->get();
        
        $this->load->view('layout/header', $data);
        $this->load->view('admin/certificate/certificatelogs', $data);
        $this->load->view('layout/footer', $data);
    }
    
    /**
     * Search certificate logs
     */
    public function search()
    {
        if (!$this->rbac->hasPrivilege('certificate_logs', 'can_view')) {
            access_denied();
        }
        
        $this->session->set_userdata('top_menu', 'Certificate');
        $this->session->set_userdata('sub_menu', 'admin/certificatelogs');
        
        $data = array();
        $data['title'] = 'Certificate Logs';
        
        // Get search parameters
        $params = array();
        
        if ($this->input->post('certificate_id') != '') {
            $params['certificate_id'] = $this->input->post('certificate_id');
        }
        
        if ($this->input->post('class_id') != '') {
            $params['class_id'] = $this->input->post('class_id');
        }
        
        if ($this->input->post('section_id') != '') {
            $params['section_id'] = $this->input->post('section_id');
        }
        
        if ($this->input->post('admission_no') != '') {
            $params['admission_no'] = $this->input->post('admission_no');
        }
        
        if ($this->input->post('student_name') != '') {
            $params['student_name'] = $this->input->post('student_name');
        }
        
        if ($this->input->post('date_from') != '') {
            $params['date_from'] = $this->input->post('date_from');
        }
        
        if ($this->input->post('date_to') != '') {
            $params['date_to'] = $this->input->post('date_to');
        }
        
        // Get pagination parameters
        $config['base_url'] = base_url() . 'admin/certificatelogs/search';
        $config['total_rows'] = $this->certificate_log_model->getSearchCount($params);
        $config['per_page'] = 25;
        $config['uri_segment'] = 4;
        $config['full_tag_open'] = '<div class="pagination"><ul>';
        $config['full_tag_close'] = '</ul></div>';
        $config['first_link'] = '&laquo; First';
        $config['first_tag_open'] = '<li class="prev page">';
        $config['first_tag_close'] = '</li>';
        $config['last_link'] = 'Last &raquo;';
        $config['last_tag_open'] = '<li class="next page">';
        $config['last_tag_close'] = '</li>';
        $config['next_link'] = 'Next &rarr;';
        $config['next_tag_open'] = '<li class="next page">';
        $config['next_tag_close'] = '</li>';
        $config['prev_link'] = '&larr; Previous';
        $config['prev_tag_open'] = '<li class="prev page">';
        $config['prev_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="active"><a href="">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li class="page">';
        $config['num_tag_close'] = '</li>';
        
        $this->pagination->initialize($config);
        
        $page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
        
        $data['logs'] = $this->certificate_log_model->search($params, $config['per_page'], $page);
        $data['pagination'] = $this->pagination->create_links();
        
        // Get certificates for filter
        $data['certificates'] = $this->certificate_model->certificateList();
        
        // Get classes for filter
        $data['classlist'] = $this->class_model->get();
        
        // Set search parameters in view
        $data['search_params'] = $params;
        
        $this->load->view('layout/header', $data);
        $this->load->view('admin/certificate/certificatelogs', $data);
        $this->load->view('layout/footer', $data);
    }
    
    /**
     * Get sections by class ID (AJAX)
     */
    public function getSectionByClass()
    {
        $class_id = $this->input->post('class_id');
        $data = $this->section_model->getClassBySection($class_id);
        echo json_encode($data);
    }
}
